import { reactive } from 'vue'
/**
 *  @name store
 *  ------------------------------------------------------
 *  Global verfügbarer Speicher
 *  Zugriff möglich von allen Vue-Komponenten mittels import
 * @author DigS-Gov Projekt
 *  ------------------------------------------------------
 */
 export const store = reactive({
   // 'config': Enthält einige Konfigurationsmöglichkeiten und Texte, die in der Anwendung genutzt werden
    config: {
      // (VARIANTEN A - C-- > VERALTET)
      // 'variante_A': Klicken auf Lieferwagen/ Stoppschilder
     variante_A: true, // ---------- lediglich auf true, da ein Teil der Anwendungslogik auf dieser Variable basiert ---------
      // 'variante_B': Klicken auf Kacheln
      // variante_B: false,
      //  // 'variante_C': Eingefärbte Strassen in Auflösung
      //  variante_C: false,
       // 'route_onboarding': Route für Onboarding-Seite
       route_onboarding: "/begruessung",
      // 'route_eingabe': Route für Eingabe-Seite
      route_eingabe: "/eingabe",
      // 'route_aufloesung': Route für Auflösung-Seite
      route_aufloesung: "/aufloesung",
     // 'route_musterloesung': Route für Musterlösung-Seite
     route_musterloesung: "/musterloesung",
      // 'route_var_A': Route für Variante A
      // route_var_A: "/a",
      //  // 'route_var_B': Route für Variante B
      //  route_var_B: "/b",
      //   // 'route_var_C': Route für Variante C
      // route_var_C: "/c",
      // 'header_varA': Überschrift für Variante A
     header_varA: "Zu welchen Behörden erfolgt Ihrer Meinung nach keine automatische Datenweitergabe durch die Meldebehörde? \n Klicken Sie einmal auf eine Straße, um mit dem Warndreieck eine Datenweitergabe nur unter bestimmten Bedingungen anzuzeigen.\n Klicken Sie ein zweites Mal und blockieren Sie so den Datenfluss komplett.\n\nSobald Sie fertig sind, klicken Sie unten auf \"Zur Auflösung\"",
      // 'header_varB': Überschrift für Variante B
    //  header_varB: "Zu welchen Behörden erfolgt Ihrer Meinung nach eine automatische Datenweitergabe durch die Meldebehörde? \nKlicken Sie auf eine Behörde, um den Datenfluss anzuzeigen.\n\nSobald Sie fertig sind, klicken Sie unten auf \"Zur Auflösung\"",
     header_aufloesung: "Klicken Sie auf die Symbole auf den Straßen, um mehr über den Datenfluss zu erfahren.\nKlicken Sie auf die Behörden, um mehr über deren Aufgaben zu erfahren.",
     header_musterloesung: "Hier sehen Sie die tatsächlichen Datenflüsse im Überblick.\n\n Klicken Sie auf die Symbole auf den Straßen, um mehr über den Datenfluss zu erfahren.\nKlicken Sie auf die Behörden, um mehr über deren Aufgaben zu erfahren.",
      // 'data_section': "Richtig/Falsch"-Popup Text für Bereich "Daten im Paket"
      data_section:{
        landesamt_fuer_statistik: "Geburtstag und -ort, Geschlecht, Staatsangehörigkeit, Religionszugehörigkeit, derzeitiger und früherer Wohnort, Tag des Ein- und Auszugs, Familienstand",
        bundeszentralamt_fuer_steuern: "Persönliche Daten, neue Anschrift, Einzugs- und Auszugsdatum, Steuer-Identifikationsnummer",
        auslaenderbehoerde: "Persönliche Daten, alte und neue Anschrift, derzeitige Staatsangehörigkeiten, Familienstand",
        gez: "Persönliche Daten zur Identifikation, neue und alte Anschrift",
        religionsgemeinschaft: "Persönliche Daten, Anschriften, Familienstand, Religionszugehörigkeit, Staatsangehörigkeit, Daten der engsten Familienangehörigen (wenn sie nicht derselben Gemeinschaft angehören)",
        krankenkasse: "Es erfolgt keine automatische Datenweitergabe durch die Meldebehörde.",
        parteien: "Familienname, Vornamen, Doktorgrad, derzeitige Anschriften, Information, ob Person verstorben",
        bundeswehr: "Familiennamen, Vornamen, gegenwärtige Anschrift",
        wegzugsmeldebehoerde: "Daten für die Identifikation, Anschrift Absender- und Empfängergemeinde, Staatsangehörigkeit, Ausweisdokumente",
        jubilaeen: "Familienname, Vornamen, Doktorgrad, Anschrift sowie Datum und Art des Jubiläums",
        deutsche_rentenversicherung: "Persönliche Daten, alte und neue Anschrift",
        bundesverwaltungsamt: "Es erfolgt keine automatische Datenweitergabe durch die Meldebehörde.",
      },
      // 'law_section': "Richtig/Falsch"-Popup Text für Bereich "Gesetzliche Grundlage"
      law_section:{
        landesamt_fuer_statistik: "Meldedatenübermittlungs- verordnung des jeweiligen Bundeslandes (z.\u00A0B. für Schleswig-Holstein: §11\u00A0Absatz\u00A01 Landesdatenübermittlungs- verordnung)",
        bundeszentralamt_fuer_steuern: "§9\u00A0Absatz\u00A01 Verordnung zur Durchführung von regelmäßigen Datenübermittlungen der Meldebehörden",
        auslaenderbehoerde: "§72\u00A0Aufenthaltsverordnung",
        gez: "Meldegesetz des jeweiligen Bundeslandes (z.\u00A0B. für Schleswig-Holstein: §8\u00A0Landesmeldegesetz)",
        religionsgemeinschaft: "§42\u00A0Absatz\u00A01 und 3 Bundesmeldegesetz ",
        krankenkasse: "Es kann sein, dass Ihr Arbeitgeber Ihre neue Adresse an Ihre Krankenkasse übermittelt, sofern dieser von Ihrem Umzug informiert ist. Besser ist es jedoch, Sie melden Ihre neue Adresse selbst der Krankenkasse.",
        parteien: "Parteien und Wählergruppen dürfen zwecks der Wahlwerbung die Namen und Anschriften von mehreren Personen (Gruppenauskunft) erhalten. Die Auswahl erfolgt dabei nach dem Lebensalter der Personen.",
        bundeswehr: "Das Bundesamt für Personalmanagement der Bundeswehr erhält zum Übersenden von Informationsmaterial jährlich am 31.03. die Namen und Anschriften von Personen, die im nächsten Jahr volljährig werden.",
        wegzugsmeldebehoerde: "§33\u00A0Absatz\u00A01 Bundesmeldegesetz",
        jubilaeen: "§50\u00A0Absatz\u00A02 Bundesmeldegesetz sowie ein Erlaubnistatbestand der jeweiligen Landesgesetzgeber (z.\u00A0B. für Schleswig-Holstein: §6\u00A0Amtsordnung)",
        deutsche_rentenversicherung: "§6\u00A0Absatz\u00A01 Verordnung zur Durchführung von regelmäßigen Datenübermittlungen der Meldebehörden",
        bundesverwaltungsamt: "Haben Sie BAföG erhalten, müssen Sie selbst Adressänderungen dem Bundesverwaltungsamt mitteilen. Es können sonst zusätzliche Kosten für Sie anfallen.",
      },
      // 'info_text': Text für Popup "Aufgaben der Behörde XY"
      info_text:{
        landesamt_fuer_statistik: {
          heading: "Welche Aufgabe erfüllt das Landesamt für Statistik?",
          text: "Das Landesamt für Statistik ist die zentrale Behörde für die Durchführung amtlicher Statistiken im eigenen Bundesland sowie für die Veröffentlichung der Ergebnisse. Es berät außerdem öffentliche Stellen und stellt volkswirtschaftliche Gesamtrechnungen auf.",
        },
        bundeszentralamt_fuer_steuern: {
          heading:"Welche Aufgaben erfüllt das Bundeszentralamt für Steuern?",
          text:"Das Bundeszentralamt für Steuern hat zentrale steuerliche Aufgaben mit nationalem und internationalem Bezug wie z.\u00A0B. die Verwaltung eines Teils der Bundessteuern. Mit Hilfe der Steueridentifikationsnummer werden alle relevanten Steuerdaten gesammelt."
        },
        auslaenderbehoerde: {
          heading:"Welche Aufgabe erfüllt die Ausländerbehörde?",
          text:"Die Ausländerbehörde überprüft die jeweiligen Aufenthaltszwecke des Aufenthaltsgesetzes und erteilt oder versagt dementsprechend eine Aufenthaltserlaubnis."
        },
        gez: {
          heading:"Welche Aufgabe erfüllt der Beitragsservice?",
          text:"Die Hauptaufgabe des Beitragsservice (ehemals GEZ) sind der Einzug des Rundfunkbeitrags und die Verwaltung der rund 46,1 Millionen Beitragskonten. Dadurch wird die Finanzierung der öffentlich-rechtlichen Sender wie ARD, ZDF und Deutschlandradio gesichert und bleibt unabhängig."
        },
        religionsgemeinschaft: {
          heading:"Welche Aufgabe erfüllt die Religionsgemeinschaft?",
          text:"Religionsgemeinschaften sind Vereinigungen, die sich das Ziel gesetzt haben, sich der gemeinsamen Ausübung ihrer Religion zu widmen. Sie dienen der umfassenden Erfüllung der durch das religiöse Bekenntnis gestellten Aufgaben."
        },
        krankenkasse:{
          heading:"Welche Aufgabe erfüllt die Krankenkasse?",
          text:"Gesetzliche Krankenversicherung (SGB\u00A0V) nennt als Aufgabe, die Gesundheit der Versicherten zu erhalten, wiederherzustellen oder ihren Gesundheitszustand zu verbessern sowie die Versicherten aufzuklären, zu beraten und auf eine gesunde Lebensführung hinzuwirken."
        }, 
        parteien: {
          heading:"Welche Aufgabe erfüllen die Parteien?",
          text:"Die Parteien wirken an der Bildung des politischen Willens des Volkes mit, indem sie insbesondere auf die Gestaltung der öffentlichen Meinung Einfluss nehmen, die politische Bildung anregen und vertiefen, die aktive Teilnahme der Bürger am politischen Leben fördern, auf die politische Entwicklung in Parlament und Regierung Einfluss nehmen, die von ihnen erarbeiteten politischen Ziele in den Prozess der staatlichen Willensbildung einführen und für eine ständige lebendige Verbindung zwischen dem Volk und den Staatsorganen sorgen."
        },
        bundeswehr:{
          heading:"Welche Aufgabe erfüllt die Bundeswehr?",
          text:"Die Bundeswehr verteidigt Deutschlands Souveränität sowie das Staatsgebiet und schützt seine Bürger. Sie trägt außerdem dazu bei, Staat und Gesellschaft widerstandsfähig gegen äußere Bedrohungen zu halten und handlungsfähig zu bleiben."
        },
        wegzugsmeldebehoerde:{
          heading:"Welche Aufgabe erfüllt die Wegzugsmeldebehörde?",
          text:"Die Meldebehörde hat die in ihrem Zuständigkeitsbereich wohnhaften Personen zu registrieren, um deren Identität und deren Wohungen feststellen und nachweisen zu können."
        }, 
        jubilaeen: {
          heading:"Was ist die Repräsentations- pflicht aus Anlass zu Alters- oder Ehejubiläen?",
          text:"Die Meldebehörde darf bei Alters- und Ehejubiläen der Bürger zum Zwecke der Gratulation an Mandatsträger sowie Presse und Rundfunk auf deren Verlangen Auskunft erteilen, soweit nicht eine Übermittlungssperre beantragt wurde. Altersjubiläen sind der 70. Geburtstag, jeder fünfte weitere Geburtstag und ab dem 100. Geburtstag jeder folgende Geburtstag; Ehejubiläen sind das 50. und jedes folgende Ehejubiläum."
        },
        deutsche_rentenversicherung:{
          heading:"Welche Aufgabe erfüllt die Rentenversicherung?",
          text:"Die Renterversicherung zahlt Leistungen wie z.\u00A0B. Renten, verwaltet Versicherungsabläufe und gibt Auskünfte zur Altersvorsorge."
        },
        bundesverwaltungsamt:{
          heading:"Welche Aufgabe erfüllt das Bundesverwaltungsamt im Rahmen des BAföG?",
          text:"Das Bundesverwaltungsamt (BVA) ist für die Darlehensverwaltung und den Einzug des Darlehens nach dem BAföG (Bundesausbilungsförderungsgesetz) zuständig. BAföG-Empfänger sind verpflichtet, Adress- und Namensänderungen dem BVA unverzüglich mitzuteilen."
        }, 
      },
      widerspruch_text: "Es besteht die Möglichkeit, mittels der Übermittlungssperre Widerspruch gegen die Datenweitergabe einzulegen.",
      // 'widerspruch_moeglich': Einrichtungen, bei denen ein Widerspruch gegen die Datenweitergabe möglich ist"
      widerspruch_moeglich:["parteien","bundeswehr","jubilaeen"],
      // 'ausnahmen': Einrichtungen, bei denen die Datenweitergabe nur unter bestimmten Bedingungen passiert"
      ausnahmen:["auslaenderbehoerde", "religionsgemeinschaft"],
      // 'ausnahmen_text': Texte für Ausnahmen"
      ausnahmen_text:{
        auslaenderbehoerde:"Daten fließen nur, wenn Person keine deutsche Staatsbürgerschaft hat.",
        religionsgemeinschaft:"Daten werden nur übermittelt, wenn Sie oder Ihr*e Ehe-/Lebenspartner*in Mitglied in einer öffentlich-rechtlichen Religionsgemeinschaft sind."
      }
    },
    // 'id_table': Zuordnungstabelle von value_names der Einrichtungen und deren dom-IDs"
    id_table:{
      landesamt_fuer_statistik: "LandesamtFuerStatistik",
      bundeszentralamt_fuer_steuern: "BundeszentralamtFuerSteuern",
      auslaenderbehoerde: "Auslaenderbehoerde",
      gez: "GEZ",
      religionsgemeinschaft: "Religionsgemeinschaft",
      krankenkasse: "Krankenkasse",
      parteien: "Parteien",
      bundeswehr: "Bundeswehr",
      wegzugsmeldebehoerde: "Wegzugsmeldebehoerde",
      jubilaeen: "Jubilaeen",
      deutsche_rentenversicherung: "DeutscheRentenversicherung",
      bundesverwaltungsamt: "Bundesverwaltungsamt",
    },
    //  'aufloesung_popup': Speichert angeklickte Institution zwischen, um im "Richtig/Falsch"-Popup die richtigen Daten anzuzeigen
     aufloesung_popup: "",
    //  'info_popup': Speichert angeklickte Institution zwischen, um im Popup "Aufgaben der Behörde XY" die richtigen Daten anzuzeigen
     info_popup:"",
   /** 'values': Werte zeigen an, ob die Kachel ausgegeraut ist oder nicht*/
    values: {
      landesamt_fuer_statistik: true,
      bundeszentralamt_fuer_steuern: true,
      auslaenderbehoerde: true,
      gez: true,
      religionsgemeinschaft: true,
      krankenkasse: true,
      parteien: true,
      bundeswehr: true,
      wegzugsmeldebehoerde: true,
      jubilaeen: true,
      deutsche_rentenversicherung: true,
      bundesverwaltungsamt: true,
      default: true,
    },
    /* conditional_values speichern die Eingabe des Users
    - lwk: zeigt an, dass der Lkw aktiv ist und somit daten fließen
    - bedingt: zeigt an, dass nur bedingt daten fließen
    - stopp: zeigt an, dass das Stoppschild aktiv ist und somit keine daten fließen*/
    conditional_values:{
    landesamt_fuer_statistik: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
      bundeszentralamt_fuer_steuern: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      auslaenderbehoerde: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      gez: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      religionsgemeinschaft: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      krankenkasse: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      parteien: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      bundeswehr: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      wegzugsmeldebehoerde: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      jubilaeen: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      deutsche_rentenversicherung: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      bundesverwaltungsamt: {
        lkw: true,
        bedingt: false,
        stopp: false,
      },
      default: true,
  },
    /**
 * 'correct_values':
  - lwk: zeigt an, dass der Lkw aktiv ist und somit daten fließen
  - bedingt: zeigt an, dass nur bedingt daten fließen
  - stopp: zeigt an, dass das Stoppschild aktiv ist und somit keine daten fließen
 */
    correct_values : {
    
    landesamt_fuer_statistik: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
    bundeszentralamt_fuer_steuern: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
    auslaenderbehoerde: {
      lkw: false,
      bedingt: true,
      stopp: false,
    },
    gez: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
    religionsgemeinschaft: {
      lkw: false,
      bedingt: true,
      stopp: false,
    },
    krankenkasse: {
      lkw: false,
      bedingt: false,
      stopp: true,
    },
    parteien: {
      lkw: false,
      bedingt: true,
      stopp: false,
    },
    bundeswehr: {
      lkw: false,
      bedingt: true,
      stopp: false,
    },
    wegzugsmeldebehoerde: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
    jubilaeen: {
      lkw: false,
      bedingt: true,
      stopp: false,
    },
    deutsche_rentenversicherung: {
      lkw: true,
      bedingt: false,
      stopp: false,
    },
    bundesverwaltungsamt: {
      lkw: false,
      bedingt: false,
      stopp: true,
    },
  },


    // 'checked_values': Werte zeigen an, welche Daten Nutzer:innen korrekt gewählt haben (true) und welche nicht (false)
     checked_values: {
      landesamt_fuer_statistik: false,
      bundeszentralamt_fuer_steuern: false,
      auslaenderbehoerde: false,
      gez: false,
      religionsgemeinschaft: false,
      krankenkasse: false,
      parteien: false,
      bundeswehr: false,
      wegzugsmeldebehoerde: false,
      jubilaeen: false,
      deutsche_rentenversicherung: false,
      bundesverwaltungsamt: false,
    },
   /**'alreadyPlayedOnce': zeigt an, ob Spiel bereits einmal gespielt wurde. --> Für Logging notwendig */
   alreadyPlayedOnce: false,
   /**'alreadyPlayedTilTheEnd': zeigt an, ob Spiel bereits einmal bis zur Musterlösung gespielt wurde. --> Für Logging notwendig */
   alreadyPlayedTilTheEnd: false,
   /**'session_id': Die für Evaluationszwecke aus der URL ausgelesene Session-ID */
   session_id: "",
     /**
      * (VARIANTEN A-C --> VERALTET)
     * 'setStates()':
     *  setzt den Status aller 'values' auf true, wenn 'variante_A' true ist
     */
  //     setStates() {
  //       var state = this.config.variante_A ? true : false;
  //       for (var value in this.values) {
  //         this.values[value] = state;
  //    }
  //  },
   /**
    * setzt 'values' auf den User-Input zurück (mittels localStorage)
    * z. B. nach Page-Refresh nötig
    * */
   setValuesToUserInput() {
     for (var val in this.values) {
       var string = localStorage.getItem(val);
       if (string === "true") {
         this.values[val] = true;
       } else {
         this.values[val] = false;
        }
        this.values.default = true;
      }
   },
   /**
  * Setzt die behörden grau auf der Musterlösungsseite, bei denen keine Daten ausgetauscht werden.
  */
   setGray() {
    for(var authority in this.correct_values){
      var correct_value = this.getCorrectValue(authority, this.correct_values)
        if(correct_value === "stopp"){
          this.values[authority] = false;
        }
        else{
          this.values[authority] = true;
        }
    }
  },

   /**
    * Prüft, ob die geratenen Werte korrekt oder falsch sind
    */
   checkUserInput() {
    for (var authority in this.correct_values) {
      var correctValue = this.getCorrectValue(authority, this.correct_values)
      var userInputValue = this.getCorrectValue(authority, this.conditional_values)
      if (correctValue == userInputValue) {
        store.checked_values[authority] = true;
      } else {
        store.checked_values[authority] = false;
        }
      }
   },
   /**
    * berechnet für eine übergebene property (correct_values oder conditional_values)
    * den Wert, welcher für eine Behörde als true gespeichert ist
    */
   getCorrectValue(authority, values_to_check) {
      for (var value in values_to_check[authority]){    
        if (values_to_check[authority][value] == true){ 
          return value;
        }
      }
   },
      /**
     * 'checkValues()':
     *  Prüft, wieviele der eingegebenen Werte der Nutzer:innen korrekt sind
     */
       checkValues()  {
        var output  = 0;
        for (var authority in this.correct_values) {
          if(this.getCorrectValue(authority, this.correct_values) == this.getCorrectValue(authority, this.conditional_values)){
            output++;
          }
        }
         return output;
      },
   /** function to send logs of user input for evaluation process */
   logData(conditional_values) {
     var myHeaders = new Headers();

     myHeaders.append("Content-Type",
       "application/x-www-form-urlencoded");

     var urlencoded = new URLSearchParams();

     urlencoded.append("session",
       store.session_id);

     urlencoded.append("section",
      conditional_values);

     urlencoded.append("prototype",
       "Umzugsquiz");

     if (store.config.variante_A) var variante = "a";
     if (store.config.variante_B) var variante = "b";
     if (store.config.variante_C) var variante = "c";

     urlencoded.append("info",
       variante);

     urlencoded.append("debug",
       "");

     var requestOptions = {
       method: 'POST', headers: myHeaders, body: urlencoded, redirect: 'follow'
     };

     fetch("https://link.jil.sh/eval/evaluate.php",
       requestOptions).then(response => response.text()).then(result => console.log(result)).catch(error => console.log('error', error));

   }
  });