import { createApp } from 'vue'
import { createRouter, createWebHistory } from 'vue-router'
import App from './App.vue'
import Page1 from "./Page1.vue";
import Page2 from "./Page2.vue";
import Page3 from "./Page3.vue";
import Onboarding from "./Page_Onboarding.vue";
import { store } from './store';
/**
 * ------------------------------------------------------
 * Metainformationen
 * @author DigS-Gov Projekt
 * ------------------------------------------------------
 */
const BASE_URL = "/digsgov/umzug";

const routes = [
  //#region redirects
  {path: "/", redirect: store.config.route_onboarding},
  {path: store.config.route_var_A, redirect: store.config.route_var_A + store.config.route_onboarding},
  {path: store.config.route_var_B, redirect: store.config.route_var_B + store.config.route_onboarding},
  {path: store.config.route_var_C, redirect: store.config.route_var_C + store.config.route_onboarding},
  //#endregion

  //#region Feste Links für 3 Varianten (VARIANTEN A-C --> VERALTET)
  // {
  //   name: "onboarding_a", path: store.config.route_var_A + store.config.route_onboarding, component: Onboarding,
  // },
  // {
  //   name: "onboarding_b", path: store.config.route_var_B + store.config.route_onboarding, component: Onboarding,
  // },
  // {
  //   name: "onboarding_c", path: store.config.route_var_C + store.config.route_onboarding, component: Onboarding,
  // },
  // {
  //   name: "eingabe_a", path: store.config.route_var_A + store.config.route_eingabe, component: Page1,
  // },
  // {
  //   name: "eingabe_b", path: store.config.route_var_B + store.config.route_eingabe, component: Page1,
  // },
  // {
  //   name: "eingabe_c", path: store.config.route_var_C + store.config.route_eingabe, component: Page1,
  // },
  // {
  //   name: "aufloesung_a", path: store.config.route_var_A + store.config.route_aufloesung, component: Page2,
  // },
  // {
  //   name: "aufloesung_b", path: store.config.route_var_B + store.config.route_aufloesung, component: Page2,
  // },
  // {
  //   name: "aufloesung_c", path: store.config.route_var_C + store.config.route_aufloesung, component: Page2,
  // },
  //#endregion

  //#region Links für dynamisches Wechseln der Varianten
  { name:"onboarding", path: store.config.route_onboarding, component: Onboarding },
  { name:"eingabe", path: store.config.route_eingabe, component: Page1 },
  { name:"aufloesung", path: store.config.route_aufloesung, component: Page2 },
  { name: "musterloesung", path: store.config.route_musterloesung, component: Page3 },
  //#endregion
]

const router = createRouter({
  history: createWebHistory(BASE_URL),
  routes, // short for `routes: routes`
})

createApp(App).use(router).mount('#app')
