
import { _decorator, Component, Node, resources, SpriteFrame, Sprite, RichText, AudioSource } from 'cc';
import { InfoTextWartezimmerTS } from './InfoTextWartezimmerTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Wartend1TS
 * DateTime = Wed Jun 08 2022 00:35:07 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = Wartend1TS.ts
 * FileBasenameNoExtension = Wartend1TS
 * URL = db://assets/scripts/Wartezimmer/Wartend1TS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Alter Herr wartend Logik
 */
 
@ccclass('WartendEinsTS')
export class WartendEinsTS extends Component {
    // [1]
    // dummy = '';

    @property({type:Sprite})
    private lebenslauf1 = null;

    @property({type:Sprite})
    private lebenslauf2 = null;

    @property({type:Sprite})
    private lebenslauf3 = null;

    start () {
        this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
            resources.load("new assets/Wartezimmer/WartezimmerPersonEinsM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
        }, this);
        this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
            resources.load("new assets/Wartezimmer/WartezimmerPersonEins/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
        }, this);
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.lebenslauf1.node.active = true;
            this.lebenslauf2.node.active = false;
            this.lebenslauf3.node.active = false;
            InfoTextWartezimmerTS.WAIT1 = true;
        }, this);
    }

}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
