
import { _decorator, Component, Node, director, resources, SpriteFrame, Sprite } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TuerVermittlungsraumTS
 * DateTime = Sat Jun 25 2022 11:15:08 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = TuerVermittlungsraumTS.ts
 * FileBasenameNoExtension = TuerVermittlungsraumTS
 * URL = db://assets/scripts/Wartezimmer/TuerVermittlungsraumTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Tür Logik
 */
 
@ccclass('TuerVermittlungsraumTS')
export class TuerVermittlungsraumTS extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {

        this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
            resources.load("new assets/Wartezimmer/WartezimmerTürM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                this.node.setPosition(-91, 13, 0);
            });
        }, this);
        this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
            resources.load("new assets/Wartezimmer/WartezimmerTür/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                this.node.setPosition(-93, 48, 0);
            });
        }, this);

        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {

            director.loadScene("Vermittlungsraum");

        }, this);
    }

    update (deltaTime: number) {
         this.node.on(Node.EventType.MOUSE_DOWN, (event) => {

            director.loadScene("Vermittlungsraum");

        }, this);
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
