
import { _decorator, Component, Node, Sprite, Label, RichText, SpriteFrame, resources, sp } from 'cc';
import { Buch } from '../Allgemein/Buch';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = InfoTextWartezimmerTS
 * DateTime = Mon May 23 2022 09:44:29 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = InfoTextWartezimmerTS.ts
 * FileBasenameNoExtension = InfoTextWartezimmerTS
 * URL = db://assets/scripts/InfoTextWartezimmerTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Szenenablauf Wartezimmer
 */
 
@ccclass('InfoTextWartezimmerTS')
export class InfoTextWartezimmerTS extends Component {
    @property({type:RichText})
    private infoText = null;

    @property({type:Node})
    private continue = null;

    @property({type:Sprite})
    private lebenslauf1 = null;

    @property({type:Sprite})
    private lebenslauf2 = null;

    @property({type:Sprite})
    private lebenslauf3 = null;


    public static WAIT1 = false;
    public static WAIT2 = false;
    public static WAIT3 = false;

    private next_dialog = false;
    private dialog_count = 0;

    dialog_update(new_text){
        this.next_dialog = false;
        this.dialog_count ++;
        this.infoText.string = new_text;
    }

    wartender_dialog(new_text){
        this.continue.active = true;
        this.infoText.string = new_text;
    }

    onLoad() {
        this.dialog_update(Dialog_Strings.szene3);
    }

    start () {
        Buch.CURRENT_SCENE = 'Wartezimmer';
        Buch.NEW_SCENE = true;
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                this.next_dialog = true;
        }, this);
    }

    update (deltaTime: number) {
        if(InfoTextWartezimmerTS.WAIT1){
            this.wartender_dialog(Dialog_Strings.wartender_1);
            InfoTextWartezimmerTS.WAIT1 = false;
        }
        else if(InfoTextWartezimmerTS.WAIT2){
            this.wartender_dialog(Dialog_Strings.wartender_2);
            InfoTextWartezimmerTS.WAIT2 = false;       
        }
        else if(InfoTextWartezimmerTS.WAIT3){
            this.wartender_dialog(Dialog_Strings.wartender_3);
            InfoTextWartezimmerTS.WAIT3 = false;
        }
        else if(this.next_dialog && this.dialog_count >= 1){
            this.continue.active = false;
            this.dialog_update(Dialog_Strings.szene3_1)
            this.lebenslauf1.node.active = false;
            this.lebenslauf2.node.active = false;
            this.lebenslauf3.node.active = false;
        }

        }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
