
import { _decorator, Component, Node, RichText, Sprite, AudioSource, resources, SpriteFrame } from 'cc';
import { InfoTextVermittlungsraumTS } from './InfoTextVermittlungsraumTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = SchulungTS
 * DateTime = Mon Sep 26 2022 09:35:57 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = SchulungTS.ts
 * FileBasenameNoExtension = SchulungTS
 * URL = db://assets/scripts/Vermittlungsraum/SchulungTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Schulung Logik
 */
 
@ccclass('SchulungTS')
export class SchulungTS extends Component {
    // [1]
    // dummy = '';

   public static FINISHINTRO = false;

    start () {
      
    }

    update (deltaTime: number) {
        if(SchulungTS.FINISHINTRO){
            resources.load("new assets/Vermittlungsraum/VermittlungsraumSchulungM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
           
            this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                resources.load("new assets/Textbanner/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                   InfoTextVermittlungsraumTS.DOKTORHUT = true;
                });
            }, this);
        }
        if(InfoTextVermittlungsraumTS.MITARBEITERIN){
            this.node.off(Node.EventType.MOUSE_DOWN);
            resources.load("new assets/Vermittlungsraum/VermittlungsraumSchulung/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });

        }
    
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
