
import { _decorator, Component, Node, RichText, Sprite, SpriteFrame, resources, Size, Vec3 } from 'cc';
import { Buch } from '../Allgemein/Buch';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
import { SucheUndHutTS } from './SucheUndHutTS';
import { SchulungTS } from './SchulungTS';
import { GeldTS } from './GeldTS';
import { VermittlungsraumMitarbeiterinTS } from './VermittlungsraumMitarbeiterinTS';
import { ShowDesktopButton } from './ShowDesktopButton';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = InfoTextVermittlungsraumTS
 * DateTime = Sat Jun 25 2022 11:10:54 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = InfoTextVermittlungsraumTS.ts
 * FileBasenameNoExtension = InfoTextVermittlungsraumTS
 * URL = db://assets/scripts/Vermittlungsraum/InfoTextVermittlungsraumTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Szenenablauf der Vermittlung
 */
 
@ccclass('InfoTextVermittlungsraumTS')
export class InfoTextVermittlungsraumTS extends Component {
    // [1]
    // dummy = '';

    @property({type:RichText})
    private infoText = null;

    @property({type:Node})
    private continue = null;

    @property({type:Node})
    private textframe = null;
    
    public static LUPE = false;
    public static MUENZE = false;
    public static DOKTORHUT = false;
    public static MITARBEITERIN = false;

    private lupe_next_dialog = false;
    private lupe_count = 0;

    private muenze_next_dialog = false;
    private muenze_count = 0;

    private mitarbeiterin_next_dialog = false;
    private mitarbeiterin_count = 0;

    private doktorhut_count = 0;

    private next_dialog = false;
    private dialog_count = 0;

    lupe_dialog_update(new_text){
        this.lupe_next_dialog = false;
        this.lupe_count ++;
        this.infoText.string = new_text;
    }

    muenze_dialog_update(new_text){
        this.muenze_next_dialog = false;
        this.muenze_count ++;
        this.infoText.string = new_text;
    }

    doktorhut_update(new_text){
        this.doktorhut_count ++;
        this.infoText.string = new_text;
    }

    mitarbeiterin_dialog_update(new_text){
        this.mitarbeiterin_next_dialog = false;
        this.mitarbeiterin_count ++;
        this.infoText.string = new_text;
    }

    dialog_update(new_text){
        this.next_dialog = false;
        this.dialog_count ++;
        this.infoText.string = new_text;
    }

    textframe_scale(width, height){
        this.textframe.setContentSize(new Size(width, height));
    }

    onLoad() {
        ShowDesktopButton.SHOWDESKTOP = false;
        this.dialog_update(Dialog_Strings.szene4);
    }

    start () {
        Buch.CURRENT_SCENE = 'Vermittlungsraum';
        Buch.NEW_SCENE = true;
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            if(InfoTextVermittlungsraumTS.LUPE){
               this.lupe_next_dialog = true;
            }
            else if(InfoTextVermittlungsraumTS.MUENZE){
                this.muenze_next_dialog = true;
            }
            else if(InfoTextVermittlungsraumTS.MITARBEITERIN){
                this.mitarbeiterin_next_dialog = true;
            }
            else{
                this.next_dialog = true;
            }
            
    }, this);
    }

    update (deltaTime: number) {
        if(InfoTextVermittlungsraumTS.LUPE && SchulungTS.FINISHINTRO){
            this.textframe_scale(941, 500);
            this.continue.setPosition(new Vec3(509, -106, 0));
            if(this.lupe_count == 0){
                this.lupe_dialog_update(Dialog_Strings.szene4_lupe)
                this.lupe_count = 0;
                InfoTextVermittlungsraumTS.LUPE = false;
                VermittlungsraumMitarbeiterinTS.PINBOARD_CLICKED = true;
            }
        }

        else if(InfoTextVermittlungsraumTS.MUENZE && GeldTS.FINISHINTRO ){
            this.textframe_scale(941, 520);
            this.continue.setPosition(new Vec3(509, -115, 0));
            this.continue.active = true;
            if(this.muenze_count == 0){
                this.muenze_dialog_update(Dialog_Strings.szene4_muenz)
            }
            if(this.muenze_count == 1 && this.muenze_next_dialog){
                this.muenze_dialog_update(Dialog_Strings.szene4_muenz_1)
            }
            if(this.muenze_count == 2 && this.muenze_next_dialog){
                this.muenze_dialog_update(Dialog_Strings.szene4_muenz_2)
                this.muenze_count = 0;
                InfoTextVermittlungsraumTS.MUENZE = false;
                VermittlungsraumMitarbeiterinTS.PINBOARD_CLICKED = true;
                this.continue.active = false;
            }
        }

        else if(InfoTextVermittlungsraumTS.DOKTORHUT && SucheUndHutTS.FINISHINTRO){
            this.textframe_scale(941, 520);
            this.continue.setPosition(new Vec3(509, -115, 0));
            this.doktorhut_update(Dialog_Strings.szene4_doktorhut);
            this.doktorhut_count = 0;
            InfoTextVermittlungsraumTS.DOKTORHUT = false;
            VermittlungsraumMitarbeiterinTS.PINBOARD_CLICKED = true;
        }

        else if(InfoTextVermittlungsraumTS.MITARBEITERIN){
            SucheUndHutTS.FINISHINTRO = false;
            SchulungTS.FINISHINTRO = false;
            GeldTS.FINISHINTRO = false;
            
            this.continue.active = true;
            this.textframe_scale(941, 500);
            this.continue.setPosition(new Vec3(509, -106, 0));
            if(this.mitarbeiterin_count == 0){
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm)
                VermittlungsraumMitarbeiterinTS.PINBOARD_CLICKED = false;
            }
            if(this.mitarbeiterin_count == 1 && this.mitarbeiterin_next_dialog){
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm_1)
                Buch.NEW_DATA = true;
            }
            if(this.mitarbeiterin_count == 2 && this.mitarbeiterin_next_dialog){
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm_2)
            }
            if(this.mitarbeiterin_count == 3 && this.mitarbeiterin_next_dialog){
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm_3)
            }
            if(this.mitarbeiterin_count == 4 && this.mitarbeiterin_next_dialog){
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm_4)
            }
            if(this.mitarbeiterin_count == 5 && this.mitarbeiterin_next_dialog){
                this.textframe_scale(941, 401);
                this.mitarbeiterin_dialog_update(Dialog_Strings.szene4_verm_5)
                InfoTextVermittlungsraumTS.MITARBEITERIN = false;
                console.log("Desktop active")
                this.continue.active = false;
                ShowDesktopButton.SHOWDESKTOP = true
            }

        }


        else{
            if(this.next_dialog && this.dialog_count == 1){
                this.dialog_update(Dialog_Strings.szene4_1)
            }
            if(this.next_dialog && this.dialog_count == 2){
                this.dialog_update(Dialog_Strings.szene4_2)
            }
            if(this.next_dialog && this.dialog_count == 3){
                this.dialog_update(Dialog_Strings.szene4_3)
            }
            if(this.next_dialog && this.dialog_count == 4){
                this.dialog_update(Dialog_Strings.szene4_4)
            }
            if(this.next_dialog && this.dialog_count == 5){
                this.dialog_update(Dialog_Strings.szene4_5)
                Buch.NEW_DATA = true;
                SucheUndHutTS.FINISHINTRO = true;
                SchulungTS.FINISHINTRO = true;
                GeldTS.FINISHINTRO = true;
                this.continue.active = false;
            }
    }

    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
