
import { _decorator, Component, Node, director, resources, Sprite, SpriteFrame } from 'cc';
import { InfoTextVermittlungsraumTS } from './InfoTextVermittlungsraumTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = GeldTS
 * DateTime = Mon Aug 15 2022 10:31:54 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = GeldTS.ts
 * FileBasenameNoExtension = GeldTS
 * URL = db://assets/scripts/Vermittlungsraum/GeldTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Geldbeutel Logik
 */
 
@ccclass('GeldTS')
export class GeldTS extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    public static FINISHINTRO = false;

    start () {
     
    }

    update (deltaTime: number) {
        if(GeldTS.FINISHINTRO){
            resources.load("new assets/Vermittlungsraum/VermittlungsraumGeldM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                resources.load("new assets/Textbanner/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                   InfoTextVermittlungsraumTS.MUENZE = true;
                });
            }, this);
        }

        if(InfoTextVermittlungsraumTS.MITARBEITERIN){
            this.node.off(Node.EventType.MOUSE_DOWN);
            resources.load("new assets/Vermittlungsraum/VermittlungsraumGeld/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
        }  

    }
    
    
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
