
import { _decorator, Component, Node, resources, Sprite, SpriteFrame, director } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = SZAuswahlVermittlungsraumTS
 * DateTime = Wed Jun 22 2022 20:48:38 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = SZAuswahlVermittlungsraumTS.ts
 * FileBasenameNoExtension = SZAuswahlVermittlungsraumTS
 * URL = db://assets/scripts/SZAuswahl/SZAuswahlVermittlungsraumTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Szenenwechsel Vermittlung
 */
 
@ccclass('SZAuswahlVermittlungsraumTS')
export class SZAuswahlVermittlungsraumTS extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
            resources.load("new assets/ScenenPinnwand/PinnwandSZVermittlungsraumM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
        }, this);
        this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
            resources.load("new assets/ScenenPinnwand/PinnwandSZVermittlungsraum/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
        }, this);

        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            director.loadScene("Vermittlungsraum");
        }, this); 
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
