
import { _decorator, Component, Node, Sprite, RichText, resources, SpriteFrame, Button, AudioSource, sys } from 'cc';
import { Person } from './Person';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TaschenrechnerTS
 * DateTime = Thu Aug 04 2022 12:48:04 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = TaschenrechnerTS.ts
 * FileBasenameNoExtension = TaschenrechnerTS
 * URL = db://assets/scripts/Leistungsberechnung/TaschenrechnerTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Logik des Taschenrechners der Szene
 *
 */
 
@ccclass('TaschenrechnerTS')
export class TaschenrechnerTS extends Component {


    public static TRIGGER = false;
    private Website_opened = false;

    start () {


    }
    update (deltaTime: number) {
    
        if(TaschenrechnerTS.TRIGGER){

            this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
                resources.load("new assets/Leistungsberechnung/LeistungsberechnungTaschenrechnerM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);

            this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
                resources.load("new assets/Leistungsberechnung/LeistungsberechnungTaschenrechner/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);

            this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                if(!this.Website_opened){
                    this.Website_opened = true;
                    sys.openURL('https://www.pub.arbeitsagentur.de/start.html');
                    console.log(this.Website_opened)
                }
            }, this);
            
        }
    }

    
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
