
import { _decorator, Component, Node, resources, Sprite, SpriteFrame } from 'cc';
import { InfoTextLeistungsberechnungTS } from './InfoTextLeistungsberechnungTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Person
 * DateTime = Sat Nov 18 2023 11:30:13 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = Person.ts
 * FileBasenameNoExtension = Person
 * URL = db://assets/scripts/Leistungsberechnung/Person.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 *
 */
 
@ccclass('Person')
export class Person extends Component {
    public static ACTIVATE = false;

    start () {
        // [3]
    }

    update (deltaTime: number) {
        if(Person.ACTIVATE){
            this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
                resources.load("new assets/Leistungsberechnung/LeistungsberechnungPersonM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);

            this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
                resources.load("new assets/Leistungsberechnung/Person/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);

            this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                InfoTextLeistungsberechnungTS.PERSON = true;
            }, this);
        }
    
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
