
import { _decorator, Component, Node, resources, SpriteFrame, Sprite, RichText, Size, Vec3, director } from 'cc';
const { ccclass, property } = _decorator;
import { Buch } from '../Allgemein/Buch';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
import { LBMitarbeiterTS } from './LBMitarbeiterTS';
import { TaschenrechnerTS } from './TaschenrechnerTS';
import { Person } from './Person';
/**
 * Predefined variables
 * Name = InfoTextLeistungsberechnungTS
 * DateTime = Mon Aug 08 2022 09:21:19 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = InfoTextLeistungsberechnungTS.ts
 * FileBasenameNoExtension = InfoTextLeistungsberechnungTS
 * URL = db://assets/scripts/Leistungsberechnung/InfoTextLeistungsberechnungTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Logik der Leistungsabrechnung-Szene
 */
 
@ccclass('InfoTextLeistungsberechnungTS')
export class InfoTextLeistungsberechnungTS extends Component {
    // [1]
    // dummy = '';

    @property({type:RichText})
    private infoText = null;

    @property({type:Node})
    private textBox = null;

    @property({type:Node})
    private continue = null;

    @property({type:Node})
    private infoGroup = null;

    public static MITARBEITER = false;

    public static PERSON = false;

    private scene_switch = false;

    private next_dialog = false;
    private dialog_count = 0

    dialog_update(new_text){
        this.next_dialog = false;
        this.dialog_count ++;
        this.infoText.string = new_text;
    }

    onLoad() {  
        this.dialog_update(Dialog_Strings.szene5_leist)
    }

    start () {
        Buch.NEW_SCENE = true;
        Buch.CURRENT_SCENE = 'Leistungsabrechnung';  
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.next_dialog = true
        }, this);
    }

    update (deltaTime: number) {
        if(this.next_dialog && this.dialog_count == 1){
            this.dialog_update(Dialog_Strings.szene5_leist_1)
            Buch.NEW_DATA = true;
            LBMitarbeiterTS.TRIGGER = true;
            this.continue.active = false;
        }
        if(InfoTextLeistungsberechnungTS.MITARBEITER){
            if(this.dialog_count == 2){
                this.continue.active = true;
                this.dialog_update(Dialog_Strings.szene5_leist_2)
            }
            InfoTextLeistungsberechnungTS.MITARBEITER = false;
        }

        if(this.next_dialog && this.dialog_count == 3){
            this.dialog_update(Dialog_Strings.szene5_leist_3)
            LBMitarbeiterTS.TRIGGER = false;
        }

        if(this.next_dialog && this.dialog_count == 4){
            this.dialog_update(Dialog_Strings.szene5_leist_4)
        }

        //6
        if(this.next_dialog && this.dialog_count == 5){
            this.continue.setPosition(new Vec3(509, -115, 0));
            this.textBox.setContentSize(new Size(941, 550));
            this.dialog_update(Dialog_Strings.szene5_leist_5)
        }

        if(this.next_dialog && this.dialog_count == 6){
            this.continue.setPosition(new Vec3(509, -44, 0));
            this.textBox.setContentSize(new Size(941, 341));
            this.dialog_update(Dialog_Strings.szene5_leist_6)
        }

        if(this.next_dialog && this.dialog_count == 7){
            this.continue.setPosition(new Vec3(509, -125, 0));
            this.textBox.setContentSize(new Size(941, 565));
            this.dialog_update(Dialog_Strings.szene5_leist_7)
        }

        if(this.next_dialog && this.dialog_count == 8){
            this.dialog_update(Dialog_Strings.szene5_leist_8)
        }
        if(this.next_dialog && this.dialog_count == 9){
            this.continue.active = false;
            this.textBox.setContentSize(new Size(941, 401));
            //8c
            this.dialog_update(Dialog_Strings.szene5_leist_9)
            TaschenrechnerTS.TRIGGER = true;
            Person.ACTIVATE = true;
        }
        if(InfoTextLeistungsberechnungTS.PERSON){
            TaschenrechnerTS.TRIGGER = false
            this.continue.active = true;
            this.dialog_update(Dialog_Strings.szene5_leist_10)
            this.continue.setPosition(new Vec3(509, -44, 0));
            Person.ACTIVATE = false;
            this.scene_switch = true;
            InfoTextLeistungsberechnungTS.PERSON = false;
        }
        if(this.scene_switch && this.next_dialog){
            director.loadScene("Ende");
        }

   
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
