import { _decorator, Component, Node, RichText, sys } from 'cc';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
import { Buch } from '../Allgemein/Buch';

const { ccclass, property } = _decorator;
// Author = DigS-Gov Projekt
// Logik der Testbox in der End-Szene
@ccclass('Info')
export class Info extends Component {

    @property({type:RichText})
    private infoText1: RichText = null;

    @property({type:RichText})
    private infoText2: RichText = null;

    @property({type:RichText})
    private infoText3: RichText = null;

    @property({type:RichText})
    private infoLink1: RichText = null;

    @property({type:RichText})
    private infoLink2: RichText = null;

    @property({type:RichText})
    private infoLink3: RichText = null;

    start() {
        Buch.NEW_SCENE = true;
        Buch.CURRENT_SCENE = 'Ende';
        
        this.infoText1.string = Dialog_Strings.szene6_end;
        this.infoText2.string = Dialog_Strings.szene6_end2;
        this.infoText3.string = Dialog_Strings.szene6_end3;

        this.infoLink1.string = Dialog_Strings.szene6_link1;
        this.infoLink2.string = Dialog_Strings.szene6_link2;
        this.infoLink3.string = Dialog_Strings.szene6_link3;

        this.infoLink1.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            sys.openURL('https://www.arbeitsagentur.de/arbeitslos-arbeit-finden/arbeitslosengeld');
        }, this);

        this.infoLink2.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            sys.openURL('https://www.pub.arbeitsagentur.de/start.html');
        }, this);

        this.infoLink3.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            sys.openURL('https://jil.sh/portfolio/projekte/digs-gov/');
        }, this);

        Buch.NEW_DATA = true;
    }
}
