
import { _decorator, Component, Node, Sprite, resources, SpriteFrame, AudioSource, assert } from 'cc';
const { ccclass, property } = _decorator;
import { WilkommensTextTS } from './WilkommensTextEmpfangTS';

/**
 * Predefined variables
 * Name = goBackTS
 * DateTime = Sun Feb 20 2022 18:53:47 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = goBackTS.ts
 * FileBasenameNoExtension = goBackTS
 * URL = db://assets/scripts/goBackTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Schließen des Formulares
 */
 
@ccclass('goBackTS')
export class goBackTS extends Component {
    // [1]
    // dummy = '';

    @property({type:Sprite})
    private anmeldeformular = null;

    @property({type:Sprite})
    private goBack = null;

    @property(AudioSource)
     public paperWrap: AudioSource = null!

    onLoad() {
         // Get the AudioSource component
         const audioSource = this.node.getComponent(AudioSource)! ;
         // Check if it contains AudioSource, if not, output an error message
         assert(audioSource);
         // Assign the component to the global variable _audioSource
         this.paperWrap = audioSource;
    }

    start () {
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {

            resources.load("test assets/Empty/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.anmeldeformular.spriteFrame = spriteFrame;
                this.goBack.spriteFrame = spriteFrame;
                // this.paperWrap.play();
                if(WilkommensTextTS.OPEN_FORMULAR){
                    WilkommensTextTS.READ_FORMULAR = true;
                }
            });

        }, this);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
