
import { _decorator, Component, Node, Sprite, Label, resources, SpriteFrame, RichText, AudioSource, director, Button } from 'cc';
const { ccclass, property } = _decorator;
import { Buch } from '../Allgemein/Buch';
import { ObererPfeilTS } from './ObererPfeilTS';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
import { SceneSwitch } from './SceneSwitch';

/**
 * Predefined variables
 * Name = WilkommensTextTS
 * DateTime = Wed Mar 23 2022 11:37:53 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = WilkommensTextTS.ts
 * FileBasenameNoExtension = WilkommensTextTS
 * URL = db://assets/newScripts/WilkommensTextTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Die Logik der Empfangs-Szene
 */
 
@ccclass('WilkommensTextEmpfangTS')
export class WilkommensTextTS extends Component {
    // [1]
    // dummy = '';

    @property({type:RichText})
    private infoText = null;

    @property({type:Node})
    private continue = null;

    public static OPEN_FORMULAR = false;
    public static READ_FORMULAR = false;

    private next_dialog = false;
    private dialog_count = 0;

    private arbeitslos_dialog_count = 0;
    private arbeitslos_next_dialog = false;

    public static ARBEITSLOS = false;



    dialog_update(new_text){
        this.next_dialog = false;
        this.dialog_count ++;
        this.infoText.string = new_text;
    }

    arbeitslos_dialog_update(new_text){
        this.continue.active = true;
        this.arbeitslos_next_dialog = false;
        this.arbeitslos_dialog_count ++;
        this.infoText.string = new_text;
    }

    arbeitslos_dialog(){
        if(this.arbeitslos_dialog_count == 0){
            this.arbeitslos_dialog_update(Dialog_Strings.szene2_10)
        }
        if(this.arbeitslos_next_dialog && this.arbeitslos_dialog_count == 1){
            this.arbeitslos_dialog_update(Dialog_Strings.szene2_11)
        }
        if(this.arbeitslos_next_dialog && this.arbeitslos_dialog_count == 2){
            this.arbeitslos_dialog_update(Dialog_Strings.szene2_12)
        }
        if(this.arbeitslos_next_dialog && this.arbeitslos_dialog_count == 3){
            this.arbeitslos_dialog_update(Dialog_Strings.szene2_13)
        }
        if(this.arbeitslos_next_dialog && this.arbeitslos_dialog_count == 4){
            WilkommensTextTS.ARBEITSLOS = false;
            this.arbeitslos_dialog_update(Dialog_Strings.szene2_14)
            this.arbeitslos_dialog_count = 0;
            this.continue.active = false;
        }

    }

    onLoad() {
        this.dialog_update(Dialog_Strings.szene2_0);
    }

    start () {
        SceneSwitch.SWITCH = false;
        Buch.CURRENT_SCENE = 'Empfang';
        Buch.NEW_SCENE = true;
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                if(WilkommensTextTS.ARBEITSLOS){
                    console.log("Arbeitlos click")
                    this.arbeitslos_next_dialog = true;
                }
                else{
                    this.next_dialog = true;
                }
        }, this);
        
    }

    update (deltaTime: number) {
        if(WilkommensTextTS.ARBEITSLOS){
            console.log("Arbeitlos")
            this.arbeitslos_dialog()
        }
        else{
            if(this.next_dialog && this.dialog_count == 1){
                this.dialog_update(Dialog_Strings.szene2_1)
                Buch.NEW_DATA = true;
            }
            if(this.next_dialog && this.dialog_count == 2){
                this.dialog_update(Dialog_Strings.szene2_2)
            }
            if(this.next_dialog && this.dialog_count == 3){
                this.dialog_update(Dialog_Strings.szene2_3)
            }
            if(this.next_dialog && this.dialog_count == 4){
                this.dialog_update(Dialog_Strings.szene2_3_1)
            }
            if(this.next_dialog && this.dialog_count == 5){
                this.continue.active = false;
                ObererPfeilTS.TRIGGER = true;
                this.dialog_update(Dialog_Strings.szene2_4)
                Buch.NEW_DATA = true;
            }
            if(this.dialog_count == 6 && WilkommensTextTS.OPEN_FORMULAR && WilkommensTextTS.READ_FORMULAR){
                this.continue.active = true;
                ObererPfeilTS.TRIGGER = false;
                this.dialog_update(Dialog_Strings.szene2_5)
            }
            if(this.next_dialog && this.dialog_count == 7){
                this.dialog_update(Dialog_Strings.szene2_6)
            }
            if(this.next_dialog && this.dialog_count == 8){
                this.dialog_update(Dialog_Strings.szene2_7)
            }
            if(this.next_dialog && this.dialog_count == 9){
                this.dialog_update(Dialog_Strings.szene2_8)     
            }
            if(this.next_dialog && this.dialog_count == 10){
                this.continue.active = false;
                console.log("switch")
                SceneSwitch.SWITCH = true;
                this.next_dialog = false;
                this.dialog_count ++;
            } 
        } 
    }
}


/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
