
import { _decorator, Component, Node, resources, SpriteFrame, Sprite, director, Layout } from 'cc';
import { WilkommensTextTS } from './WilkommensTextEmpfangTS';
import { ObererPfeilTS } from './ObererPfeilTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = UntererPfeilTS
 * DateTime = Tue Mar 15 2022 10:02:00 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = UntererPfeilTS.ts
 * FileBasenameNoExtension = UntererPfeilTS
 * URL = db://assets/newScripts/UntererPfeilTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Die Logik des unteren Pfeil Schildes
 */
 
@ccclass('UntererPfeilTS')
export class UntererPfeilTS extends Component {
    // [1]
    // dummy = '';


    start () {
    }

    update () {
        if (ObererPfeilTS.TRIGGER){
            this.node.on(Node.EventType.MOUSE_ENTER, (event) => {
                resources.load("new assets/Empfang/UntererPfeilM/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);
            this.node.on(Node.EventType.MOUSE_LEAVE, (event) => {
                resources.load("new assets/Empfang/UntererPfeil/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                    this.node.getComponent(Sprite).spriteFrame = spriteFrame;
                });
            }, this);
    
           this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
                WilkommensTextTS.ARBEITSLOS = true;
            }, this);
        }
        else{
            resources.load("new assets/Empfang/UntererPfeil/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.node.getComponent(Sprite).spriteFrame = spriteFrame;
            });
            this.node.off(Node.EventType.MOUSE_DOWN)
            this.node.off(Node.EventType.MOUSE_ENTER)
        }
    }


   
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
