
import { _decorator, Component, Node, Button,Sprite, LabelComponent, resources, SpriteFrame,screen} from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = ScaleTS
 * DateTime = Tue Mar 01 2022 10:47:34 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = ScaleTS.ts
 * FileBasenameNoExtension = ScaleTS
 * URL = db://assets/scripts/ScaleTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Logik des Fullscreens
 */
 
@ccclass('ScaleTS')
export class ScaleTS extends Component {
    // [1]
    // dummy = '';

    @property (Button)
    button: Button | null = null;


    private fullScreen = false;

    onLoad() {
        this.button.node.on(Button.EventType.CLICK, this.goToFull, this);
    }


    start () {
    }

    goToFull(button: Button) {
        screen.requestFullScreen();
        this.fullScreen = true;
    }

    goToWin(button: Button) {
        screen.exitFullScreen();
        this.fullScreen = false;
    }


    update (deltaTime: number) {
        if(this.fullScreen){
            this.button.node.on(Button.EventType.CLICK, this.goToWin, this);
            resources.load("new assets/NewWindow/spriteFrame", SpriteFrame, (err, spriteFrame) => {
               this.button.normalSprite = spriteFrame; // TODO: Verursacht Fehler
            });
        }
        else {
            this.button.node.on(Button.EventType.CLICK, this.goToFull, this);
            resources.load("new assets/NewFullscreen/spriteFrame", SpriteFrame, (err, spriteFrame) => {
                this.button.normalSprite = spriteFrame; // TODO: Verursacht Fehler
            });
        }
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
