
import { _decorator, Component, Node, Sprite, Label, resources, SpriteFrame, RichText, AudioSource, ProgressBar } from 'cc';
import { Buch } from '../Allgemein/Buch';
import { Dialog_Strings } from '../Allgemein/Dialog_Strings';
import { AnkunftTuerTS } from './AnkunftTuerTS';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = WilkommensTextTS
 * DateTime = Wed Mar 23 2022 11:37:53 GMT+0100 (Mitteleuropäische Normalzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = WilkommensTextTS.ts
 * FileBasenameNoExtension = WilkommensTextTS
 * URL = db://assets/newScripts/WilkommensTextTS.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Die Logik der Startszene
 */
 
@ccclass('WilkommensTextTS')
export class WilkommensTextTS extends Component {
    // [1]
    // dummy = '';

    @property({type:RichText})
    private infoText = null;

    @property({type:Node})
    private continue = null;

    @property({type:Sprite})
    private textBox = null;

    @property({type:AudioSource})
    private talk = null;

    /*private timerKuendigung: number;
    private timerKuendigungEnded: boolean;
    private timerContinueEnded: boolean;

    private isLoaded = false;*/

    private next_dialog = false;
    private dialog_count = 0
    dialog_update(new_text){
        this.next_dialog = false;
        this.dialog_count ++;
        this.infoText.string = new_text;
    }

    onLoad() {
        /*this.timerKuendigung = 0.0;
        this.timerKuendigungEnded = false;
        this.timerContinueEnded = false;*/
        this.dialog_update(Dialog_Strings.szene1_0)
    }

    start () {
        Buch.CURRENT_SCENE = 'Ankunft';
        Buch.NEW_SCENE = true;
        //this.isLoaded = true;
        this.node.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.next_dialog = true
        }, this);
    }

    update (deltaTime: number) {
        if(this.next_dialog && this.dialog_count == 1){
            this.dialog_update(Dialog_Strings.szene1_1)
        }
        if(this.next_dialog && this.dialog_count == 2){
            Buch.NEW_DATA = true;
            this.dialog_update(Dialog_Strings.szene1_2)
        }
        if(this.next_dialog && this.dialog_count == 3){
            this.continue.active = false;
            this.dialog_update(Dialog_Strings.szene1_3)
            AnkunftTuerTS.OPENDOOR = true;           
        }
    }

    

}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
