
import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Dialog_Strings
 * DateTime = Fri Sep 15 2023 12:33:51 GMT+0200 (Mitteleuropäische Sommerzeit)
 * Author = DigS-Gov Projekt
 * FileBasename = Dialog_Strings.ts
 * FileBasenameNoExtension = Dialog_Strings
 * URL = db://assets/scripts/Allgemein/Dialog_Strings.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/en/
 * Die Texte der Textboxen sind hier definiert.
 */
 
@ccclass('Dialog_Strings')
export class Dialog_Strings extends Component {

    public static MAX_WIDTH = 850;

    //Ankunft-Szene
    public static szene1_0 = `<color=#0000>Willkommen bei der Agentur für Arbeit.
    Erfahren Sie in diesem Spiel mehr über
    unsere Aufgaben, wie wir Sie bei der
    Arbeitssuche unterstützen können und
    welchen Weg Ihre Daten nehmen.<color>`;

    public static szene1_1 = `<color=#0000>Informationen, die Sie im Spiel erhalten,
    werden in einem Notizbuch abgelegt. Sie 
    finden es am linken unteren Bildschirmrand. 
    Sind neue Informationen hinzugekommen,
    wird das Notizbuch hüpfen, um 
    Sie darauf aufmerksam zu machen. …</color>`;

    public static szene1_2 = `<color=#0000>Sie können jederzeit das Buch anklicken, 
    um es zu öffnen und Informationen 
    nachzuschlagen. Probieren Sie es 
    gleich mal aus!</color>`;

    public static szene1_3 = `<color=#0000><i>Klicken Sie auf die Tür, 
    um das Spiel zu beginnen.</i></color>`;


    //Empfang-Szene
    public static szene2_0 = `<color=#DC143C>Mitarbeiterin:</color><color=#000000> „Willkommen bei der Agentur 
    für Arbeit. Hier können Sie sich anmelden 
    und Ihre Kontaktdaten hinterlassen. Ich helfe
    Ihnen gern bei Terminvereinbarungen, Fragen
    zu Anträgen und nötigen Formularen oder
    aktualisiere Ihre Kontakt- oder Kontodaten." </color>`;

    public static szene2_1 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Wie kann ich Ihnen helfen?"</color>`;

    public static szene2_2 = `<color=#0000>„Ich habe einen befristeten Arbeitsvertrag, 
    der in 6 Monaten endet. 
    Ich möchte nicht arbeitslos
    werden und bin mir unsicher,
    was ich jetzt tun soll"</color>`;

    public static szene2_3 =  `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Es ist gut, dass Sie direkt
    zu uns gekommen sind. Wir unterstützen Sie
    bei der Suche nach einer neuen Arbeitsstelle
    und besprechen Ihre Möglichkeiten...“</color>`
    
    public static szene2_3_1 = `<color=#0000>„Mit Ihrer rechtzeitigen
    Arbeitssuchendmeldung vermeiden Sie auch
    finanzielle Nachteile beim möglichen
    Bezug von Arbeitslosengeld.“</color>`;

    public static szene2_4 =  `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Füllen Sie den Antrag für die 
    Arbeitssuchendmeldung aus, ich 
    werde Ihre Daten aufnehmen und
    dann nach einem freien Termin
    für ein Beratungsgespräch suchen.“</color>`;

    public static szene2_5 =  `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Vielen Dank. Ich habe Ihren
    Antrag aufgenommen und leite diesen an Ihre
    Vermittlungsfachkraft weiter..."</color>`;

    public static szene2_6 = `<color=#0000>...„Ich kann Ihnen für nächste Woche 
    Donnerstag um 16 Uhr einen Termin für
    das erste Beratungsgespräch anbieten.
    Können Sie den Termin einrichten?" </color>`;

    public static szene2_7 = `<color=#0000>„Ja, das kann ich. Danke.“</color>`;
    
    public static szene2_8 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Sehr gern. 
    Ich wünsche Ihnen noch einen schönen Tag.“</color>`;
    //Empfang Arbeitslos

    public static szene2_10 =  `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Sie können sich frühestens
    3 Monate vor Beginn Ihrer Arbeitslosigkeit
    arbeitslos melden, spätestens aber 
    am ersten Tag Ihrer Arbeitslosigkeit."</color>`;

    public static szene2_11 = `<color=#0000>„Muss ich mich auch arbeitslos
    melden, wenn ich mich bereits
    arbeitssuchend gemeldet habe?“</color>`;

    public static szene2_12 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Ja, Sie müssen sich arbeitslos
    melden, auch wenn Sie sich schon
    arbeitssuchend gemeldet haben. Die
    Arbeitslosmeldung ist eine wichtige
    Voraussetzung dafür, dass Sie
    Arbeitslosengeld erhalten können..."</color>`;

    public static szene2_13 =  `<color=#0000>„Es wird frühestens ab dem Tag
    gezahlt, an dem Sie sich arbeitslos
    gemeldet haben, sofern alle weiteren
    Voraussetzungen erfüllt sind.“</color>`;

    public static szene2_14 =  `<color=#0000>„Ok, gut zu wissen.“</color>`;

    //Wartezimmer-Szene
    public static szene3 = `<color=#0000>Heute ist Ihr erster Beratungstermin mit
    Ihrer Vermittlungsfachkraft. Im Wartebereich
    sitzen weitere Bürger und Bürgerinnen.
    Möchten Sie mehr über ihre Gedanken
    erfahren und wie die Agentur für Arbeit
    ihnen helfen kann, klicken Sie auf
    die Personen. …</color>`;

    public static szene3_1 = `<color=#0000>… Möchten Sie zu Ihrem
    Beratungstermin gehen, <i>klicken Sie
    auf die Tür.</i></color>`;

    //Wartezimmer Wartende 
    public static wartender_1 = `<color=#0066ff>Frank</color><color=#000000>: "Mehr als 40 Jahre habe ich im 
    selben Betrieb gearbeitet und nun ist dieser
    insolvent gegangen und ich stehe ohne Arbeit
    da. Jetzt nochmal einen guten Job zu
    finden stelle ich mir schwierig vor. 
    Hoffentlich kann man mir hier helfen." </color>`;

    public static wartender_2 = `<color=#009900>Elias</color><color=#000000>: "In meinem Heimatland
    war ich Bäcker, aber das war vor dem Krieg.
    Wird meine Ausbildung hier überhaupt
    anerkannt? Hoffentlich werde ich
    freundlich und gut beraten." </color>`;

    public static wartender_3 =  `<color=#ff3300>Marie</color><color=#000000>: "Ich habe gerade
    meinen Schulabschluss gemacht, aber ich
    weiß noch nicht, welche Ausbildung zu
    mir passen könnte. Ob die Agentur für
    Arbeit auch dabei unterstützen kann?" </color>`;

    //Vermittlungs-Szene
    public static szene4 = `<color=#0000>Das erste Beratungsgespräch dient
    dem Kennenlernen Ihrer persönlichen
    beruflichen Situation.</color>`;

    public static szene4_1 =  `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Guten Tag. 
    Ich möchte heute mit Ihnen besprechen,
    wie Sie sich Ihre berufliche Zukunft
    vorstellen.“…</color>`;

    public static szene4_2 = `<color=#0000>… „In welchem Umfang können Sie arbeiten?
    Wo sehen Sie Ihre Stärken? In welcher
    Branche wären Sie gerne tätig?
    Darüber möchte ich mit Ihnen sprechen.“</color>`;

    public static szene4_3 = `<color=#0000> „Ich brauche nur dringend einen
    neuen Job. Ich mache gerne das,
    was ich gelernt habe.“</color>`;

    public static szene4_4 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Ich unterstütze Sie 
    gern bei der Suche nach einem neuen
    Job und vermittle Ihnen Stellengesuche,
    die auf Ihr Profil passen. Falls das nicht
    ausreichen sollte, unterstützen wir Sie auch
    bei Weiterbildungen oder Umschulungen.“ …</color>`;

    public static szene4_5 = `<color=#0000>… „Werfen Sie gerne einen Blick auf
    die Pinnwand mit unseren Aufgaben, um mehr
    zu erfahren. Danach sprechen wir weiter.“</color>`;

    //Vermittlung Lupe

    public static szene4_lupe = `<color=#0000>Ihre Stärken und Interessen einer
    Vermittlungsfachkraft mitzuteilen, erfolgt
    auf freiwilliger Basis. Direkt nach einem
    Schulabschluss, wenn Sie sich unsicher sind
    über die passende Ausbildung oder ein
    passendes Studium, können Sie beispielsweise
    die Berufsberatung in Anspruch nehmen. </color>`;

    public static szene4_lupe_1 = `<color=#0000>Die Bundesagentur für Arbeit bietet dafür
    neben der persönlichen Berufsberatung auch
    verschiedene kostenlose Tests an, bei denen
    Sie psychologisch fundierte Ergebnisse zur
    eigenen Reflexion erhalten. Check-U ist
    beispielsweise ein Tool mit verschiedenen
    Tests für die Berufsorientierung. Und beim
    Berufecheck können Sie herausfinden, wie gut
    Ihre Stärken zu Ihrem aktuellen Beruf passen.</color>`;

    //Vermittlung Doktorhut

    public static szene4_doktorhut = `<color=#0000>Informationen zu Ihren Abschlüssen sind
    wichtig für die Aufgaben der Arbeitsagentur,
    daher müssen Sie diese immer angeben. Wenn
    Sie Abschlüsse nachholen oder sich
    beruflich verändern wollen und dafür
    Weiterbildungen benötigen, kann Sie die
    Arbeitsagentur auch dazu beraten und bei der
    Suche nach geeigneten Kursen unterstützen. </color>`;

    //Vermittlung Münzbeutel

    public static szene4_muenz = `<color=#0000>Neben Beratung und Vermittlung unterstützt
    die Arbeitsagentur auch finanziell während
    der Jobsuche oder Weiterbildung. Anspruch
    auf Arbeitslosengeld haben beispielsweise
    Bürger und Bürgerinnen, die bereits eine
    sozialversicherungspflichtige Beschäftigung
    ausgeübt haben und somit in die
    Arbeitslosenversicherung eingezahlt haben. </color>`;

    public static szene4_muenz_1 = `<color=#0000>Nach Beratung durch die Arbeitsagentur
    können Sie für Ihre berufliche Weiterbildung
    oder Umschulung auch einen Bildungsgutschein
    erhalten. Außerdem berät Sie Ihre
    Vermittlungsfachkraft, ob Sie selbst Anspruch
    auf Kindergeld haben oderbei eigenen Kindern
    Anspruch auf Kinderzuschlag besteht und
    unterstützt Sie bei den Anträgen.</color>`;

    public static szene4_muenz_2 = `<color=#0000>Das ehemalige Arbeitslosengeld 2,
    umgangssprachlich Hartz 4 genannt, wurde seit
    dem 01.07.2023 vom Bürgergeld abgelöst. Für
    das Bürgergeld sind nicht die Arbeitsagenturen
    direkt, sondern die Jobcenter zuständig.
    Jobcenter sind Einrichtungen der Bundesagentur
    für Arbeit und eines kommunalen Trägers,
    beispielsweise einer Stadt oder Landkreis.</color>`;

    //Vermittlung Vermittlungskraft

    public static szene4_verm = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Jetzt haben Sie erstmal einen
    Überblick bekommen, wie wir Sie unterstützen
    können. Ich werde Sie regelmäßig zu
    Beratungsterminen einladen, um über
    das weitere Vorgehen und geeignete
    Maßnahmen zu sprechen, damit Sie bald
    erfolgreich eine neue Stelle antreten können.“ …</color>`;

    public static szene4_verm_1 = `<color=#0000>… „Ich werde Beratungsnotizen verfassen
    und Stellenangebote, auf denen Sie
    sich beworben haben, notieren. So
    können meine Vertretungsfachkräfte Sie
    ebenfalls gut unterstützen, falls ich
    beispielsweise durch Krankheit ausfallen sollte.“</color>`;

    public static szene4_verm_2 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Haben Sie zu diesem
    Zeitpunkt noch Fragen?“</color>`;

    public static szene4_verm_3 = `<color=#0000>„Ich bin mir unsicher, ob das Arbeitslosengeld
    ausreichen würde, um meinen Lebensunterhalt
    zu bestreiten. Wieviel Arbeitslosengeld
    würde ich erhalten?“</color>`;

    public static szene4_verm_4 = `<color=#DC143C>Mitarbeiterin</color><color=#0000>: „Aus Datenschutzgründen erfolgt
    die  Berechnung der Höhe Ihres
    Arbeitslosengeldes in einer anderen
    Abteilung. Ich kann gerne einen Termin
    für Sie bei einem meiner Kollegen aus
    der Leistungsberechnung vereinbaren,
    der Ihnen mehr dazu erzählen kann.“</color>`;

    public static szene4_verm_5 = `<color=#0000><i>Klicken Sie auf den Computerbildschirm,
    um zur Leistungsberechnung zur wechseln.</i></color>`;
    //Leistungsabrechnung-Szene

    public static szene5_leist = `<color=#0000>Normalerweise haben die Mitarbeiter und
    Mitarbeiterinnen der Leistungsberechnung
    keinen direkten Kundenkontakt. Heute wird
    für Sie eine Ausnahme gemacht und Sie
    können dem Mitarbeiter für die Berechnung
    Ihrer Leistung über die Schulter schauen.</color>`;

    public static szene5_leist_1 = `<color=#0000>Ihre Daten, die für die Berechnung des
    Arbeitslosengeldes benötigt werden, kann
    nur der Ihnen hier zugeteilte Mitarbeiter
    und seine fest eingeteilten Vertretungen
    einsehen.</color>`;

    public static szene5_leist_2 = `<color=#DC143C>Mitarbeiter</color><color=#0000>: „Hallo, ich habe schon erfahren, dass
    ich heute ausnahmsweise Besuch bekomme.
    Meine Aufgabe besteht darin, festzustellen,
    ob Sie Anspruch auf Arbeitslosengeld 1 haben
    und wenn ja, die Höhe und Dauer des
    Arbeitslosengeldes festzulegen.“</color>`;

    public static szene5_leist_3 = `<color=#DC143C>Mitarbeiter</color><color=#0000>: „Wussten Sie, dass das
    Arbeitslosengeld 1 eine
    Versicherungsleistung ist, auf die
    Sie Anspruch haben, sofern Sie in die 
    Arbeitslosenversicherung eingezahlt haben?“</color>`;

    public static szene5_leist_4 = `<color=#0000>„Ja schon, ich bin aktuell auch
    sozialversicherungspflichtig beschäftigt,
    aber leider nur für 6 Monate und davor war
    ich einige Monate nur geringfügig beschäftigt.
    Ich weiß gar nicht genau, ob ich unter diesen
    Umständen einen Anspruch habe.“</color>`;

    public static szene5_leist_5 = `<color=#DC143C>Mitarbeiter</color><color=#0000>: „Es gibt verschiedene Bedingungen
    und Ausnahmen, unter denen doch Anspruch
    auf Arbeitslosengeld besteht. Es ist
    immer ratsam, sich diesbezüglich bei uns
    beraten zu lassen. Bei Ihnen sehe ich, dass
    Sie die Anwartschaftszeit erfüllen, da Sie
    bis vor einem Jahr in Elternzeit für Ihr Kind
    waren. Diese Zeit zählt mit rein, so dass Sie
    Anspruch auf ALG 1 haben.“</color>`;

    public static szene5_leist_6 = `<color=#0000>„Da bin ich aber erleichtert.
    Doch wie hoch wird dieses ausfallen?“</color>`;

    public static szene5_leist_7 = `<color=#DC143C>Mitarbeiter</color><color=#0000>: „Ganz grundsätzlich bestimmt man
    Ihr Brutto-Arbeitsentgelt (Gehalt) der
    letzten 12 Monate. Dieses wird durch 365
    geteilt, so erhält man Ihr Bemessungsentgelt
    pro Tag. Von diesem werden 20%
    Sozialversicherungsbeiträge und die
    Lohnsteuer abgezogen. Das ergibt Ihr
    Netto-Entgelt pro Tag, wir nennen
    das Leistungsentgelt.“ … </color>`;

    public static szene5_leist_8 = `<color=#DC143C>Mitarbeiter</color><color=#0000>: … „Falls Sie mindestens ein Kind
    haben,  für das Sie Kindergeld bekommen,
    entspricht Ihr tägliches Arbeitslosengeld
    67% des Leistungsentgelts. Sonst erhalten Sie 
    60% des Leistungsentgelts. Wenn Sie
    diese Berechnung für Ihre eigenen Zahlen
    nachvollziehen wollen, können Sie gerne den
    Arbeitslosengeld-Rechner auf der Webseite
    der Arbeitsagentur nutzen.“</color>`;

    public static szene5_leist_9 = `<color=#0000><i>Beim Klick auf den Taschenrechner gelangen
    Sie zum Arbeitslosengeld-Rechner.
    Mit einem Klick auf Ihre Spielfigur
    geht das Spiel weiter.</i></color>`;

    public static szene5_leist_10 = `<color=#0000>„Danke für Ihre Zeit. Ich wünsche
    Ihnen noch einen schönen Tag.“</color>`;

    //Ende
    public static szene6_end = `<color=#0000> Hiermit ist die Simulation beendet. Vielen Dank, dass Sie 
    die Simulation ausprobiert haben. Wir hoffen, sie war für Sie 
    interessant und hilfreich. Blättern Sie gerne noch
    einmal durch das Notizbuch, wenn Sie in Ruhe nachlesen wollen, welche
    Daten die Arbeitsagentur von Ihnen erfasst.

    Mehr Informationen rund um die Arbeitslosmeldung, den Antrag auf
    Arbeitslosigkeit und den Anspruch auf Arbeitslosengeld erhalten
    Sie bei der Agentur für Arbeit.</color>`;

    public static szene6_end2 = `<color=#0000>Den erwähnten Arbeitslosengeld-Rechner finden Sie hier:</color>`;

    public static szene6_end3 = `<color=#0000>Das Simulations-Spiel ist im Rahmen des Forschungsprojektes
    „Digitale Souveränität durch E-Government“ entstanden.
    Mehr Informationen zu diesem Projekt erhalten sie hier:</color>`;


   public static szene6_link1 = `<color=#0000>Link:</color> <color=#0000EE>https://www.arbeitsagentur.de/arbeitslos-arbeit-finden/arbeitslosengeld </color>`;

   public static szene6_link2 = `<color=#0000EE>https://www.pub.arbeitsagentur.de/start.html</color>`;

   public static szene6_link3 = `<color=#0000EE>https://jil.sh/portfolio/projekte/digs-gov/ </color>`;
    

}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
