
import { _decorator, Component, Node, BlockInputEvents, Canvas, Sprite, SpriteComponent, Color, color, Label, isPropertyModifier, Asset, SpriteFrame, EventTarget, animation, Animation, RichText, input, RenderComponent, director, error, game, find, UITransform, v3 } from 'cc';
const { ccclass, property } = _decorator;

// const eventTarget = new EventTarget();
// Author = DigS-Gov Projekt
// Hier ist die Logik des Buches beschrieben

@ccclass('Buch')
export class Buch extends Component {

    static NEW_DATA = false;
    static NEW_CONTENT = 0;
    static CURRENT_SCENE = "";
    static NEW_SCENE = false;
    static BOOK_UPDATE = 0;

    @property({ type: Node })
    public overlay;

    @property({ type: Node })
    public backgroundLeft;

    @property({ type: Node })
    public backgroundRight;

    @property({ type: Node })
    public buchKlein;

    @property({ type: Node })
    public close;

    @property({ type: Node })
    public goBack;

    @property({ type: Node })
    public buchGroß;

    // TABS
    @property({ type: Node })
    public tab1;
    @property({ type: Node })
    public tab2;
    @property({ type: Node })
    public tab3;
    @property({ type: Node })
    public tab4;
    @property({ type: Node })
    public tab5;
    @property({ type: Node })
    public tab6;

    private active_tab = 0;
    private active_tab_color = new Color(255, 163, 0);

    // TILES
    @property({ type: Node })
    public tile1;
    @property({ type: Node })
    public tile2;
    @property({ type: Node })
    public tile3;
    @property({ type: Node })
    public tile4;
    @property({ type: Node })
    public tile5;
    @property({ type: Node })
    public tile6;

    private active_tile = 1;
    private active_tile_color = new Color(255, 163, 0);
    private institution1_color = new Color(255, 230, 155);
    private institution2_color = new Color(197, 224, 180);
    private institution3_color = new Color(189, 215, 238);

    // PAGE-CONTENTS
    @property({ type: Node })
    public plain_text;
    @property({ type: Node })
    public info_sections;
    @property({ type: Sprite })
    public section1_picto;
    @property({ type: Label })
    public section1_picto_label;
    @property({ type: Node })
    public section1_text;
    @property({ type: Sprite })
    public section2_picto;
    @property({ type: Label })
    public section2_picto_label;
    @property({ type: Node })
    public section2_text;
    @property({ type: Node })
    public section2_minipicto1;
    @property({ type: Label })
    public section2_minipicto1_label;
    @property({ type: Node })
    public section2_minipicto2;
    @property({ type: Label })
    public section2_minipicto2_label;
    @property({ type: Node })
    public section2_minipicto3;
    @property({ type: Label })
    public section2_minipicto3_label;
    @property({ type: Sprite })
    public section3_picto;
    @property({ type: Label })
    public section3_picto_label;
    @property({ type: Node })
    public section3_text;
    @property({ type: Node })
    public extra_text;
    @property({ type: Node })
    public extra_text_right;


    // SPRITES
    //page 1
    @property({ type: SpriteFrame })
    public institution1_picto;
    @property({ type: SpriteFrame })
    public institution2_picto;
    @property({ type: SpriteFrame })
    public institution3_picto;
    //page 2
    @property({ type: SpriteFrame })
    public stammdaten1_picto;
    @property({ type: SpriteFrame })
    public stammdaten2_picto;
    @property({ type: SpriteFrame })
    public stammdaten3_picto;
    @property({ type: SpriteFrame })
    public stammdaten4_picto;
    @property({ type: SpriteFrame })
    public stammdaten5_picto;
    @property({ type: SpriteFrame })
    public stammdaten6_picto;
    //page 3
    @property({ type: SpriteFrame })
    public vermittlung1_picto;
    @property({ type: SpriteFrame })
    public vermittlung2_picto;
    @property({ type: SpriteFrame })
    public vermittlung3_picto;
    @property({ type: SpriteFrame })
    public vermittlung4_picto;
    @property({ type: SpriteFrame })
    public vermittlung5_picto;
    @property({ type: SpriteFrame })
    public vermittlung6_picto;
    //page4
    @property({ type: SpriteFrame })
    public Leistung1_picto;
    @property({ type: SpriteFrame })
    public Leistung2_picto;
    @property({ type: SpriteFrame })
    public Leistung3_picto;
    @property({ type: SpriteFrame })
    public Leistung4_picto;
    @property({ type: SpriteFrame })
    public Leistung5_picto;
    @property({ type: SpriteFrame })
    public Leistung6_picto;
    //page5
    @property({ type: SpriteFrame })
    public doku1_picto;
    @property({ type: SpriteFrame })
    public doku2_picto;
    @property({ type: SpriteFrame })
    public doku3_picto;
    //page6
    @property({ type: Node })
    public paragraph1;
    @property({ type: Node })
    public paragraph2;
    @property({ type: Node })
    public paragraph3;
    @property({ type: Node })
    public paragraph4;
    @property({ type: Node })
    public paragraph5;
    @property({ type: Node })
    public paragraph6;
    @property({ type: SpriteFrame })
    public empty;
    @property({ type: Node })
    public Lawtext_scrollbar;
    @property({ type: Node})
    public scrollbar_content;
    @property({ type: Label})
    public Lawtext_label;

    // title on right page
    @property({ type: Node })
    public title;

    //#region STRINGS
    // tab titles
    private txt_tab1_title = "Abteilungen";
    private txt_tab2_title = "Stammdaten";
    private txt_tab3_title = "Vermittlung";
    private txt_tab4_title = "Dokumentation";
    private txt_tab5_title = "Leistungsbezug";
    private txt_tab6_title = "Gesetze";
    // section titles
    private txt_section1_title = "Infos";
    private txt_section2_title = "Datenschutz";
    private txt_section2_heading = "einsehbar durch:"; // hard coded in editor
    private txt_section3_title = "Gesetzliche\nGrundlage";
    // institution titles (for minipicto labels)
    private institution1_title = "Eingangszone";
    private institution2_title = "Vermittlung/\nBeratung";
    private institution3_title = "Leistungs-\nberechnung";
    //tab 0
    private txt_tab0_title = "Notizen";
    private txt_tab0_plaintext = "November 2023: Beratungsgespräch beim Arbeitsamt"
    // tab 1 - tile titles
    private txt_tab1_tile1_title = "Eingangszone";
    private txt_tab1_tile2_title = "Vermittlung/Beratung";
    private txt_tab1_tile3_title = "Leistungsberechnung";
    // tab 1 - tile plain texts
    private txt_tab1_tile1_plaintext = "Mitarbeiter und Mitarbeiterinnen bei der Anmeldung vor Ort in der Arbeitsagentur oder im Service am Telefon nehmen Anfragen der Kunden (Bürger) entgegen und leiten diese weiter, können generelle Fragen zum Ablauf und nötigen Formularen beantworten und einfache Kundendaten (Adresse, Kontodaten) auf Wunsch ändern. Sie haben keine Einsicht in die fallbezogenen Daten der Kunden.";
    private txt_tab1_tile2_plaintext = "Jedem Kunden wird bei der Arbeitsagentur eine Vermittlungsfachkraft zugeordnet. Dieser Mitarbeiter oder Mitarbeiterin bearbeitet die Arbeitslosenmeldung des Kunden, führt persönliche Gespräche mit dem Kunden und informiert und berät zu Weiterbildungsangeboten und passenden Stellenangeboten. Vermittlungsfachkräfte sehen nur die fallbezogenen Daten der ihnen zugeteilten Kunden sowie die Kundendaten der Kollegen, für die sie als Vertretung zugeteilt sind.";
    private txt_tab1_tile3_plaintext = "Mitarbeiter und Mitarbeiterinnen in dieser Abteilung erhalten alle nötigen Daten und Informationen, die sie benötigen, um den Anspruch auf Leistung (ALG 1) zu überprüfen und dessen Höhe zu bestimmen.";
    // tab 2 - tile titles
    private txt_tab2_tile1_title = "Kundennummer";
    private txt_tab2_tile2_title = "Persönliche Daten";
    private txt_tab2_tile3_title = "Anschrift und Familienstand";
    private txt_tab2_tile4_title = "Staatsangehörigkeit";
    private txt_tab2_tile5_title = "Sozialversicherungs-nummern";
    private txt_tab2_tile6_title = "Freiwillige Kontaktdaten";
    // tab 2 - section 1 texts
    private txt_tab2_tile1_section1 = "Ihre eindeutige Kundennummer zur Zuordnung im bundesweiten System der Arbeitsagenturen";
    private txt_tab2_tile2_section1 = "Name, Vorname, Geburtsort, Geburtsdatum";
    private txt_tab2_tile3_section1 = "Adresse und Familienstand";
    private txt_tab2_tile4_section1 = "Staatsangehörigkeit und Aufenthaltsstatus";
    private txt_tab2_tile5_section1 = "Renten- und Sozialversicherungs-nummer";
    private txt_tab2_tile6_section1 = "Telefonnummer und E-Mail (freiwillige Angabe)";
    // tab 2 - section 3 texts
    private txt_tab2_tile1_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    private txt_tab2_tile2_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    private txt_tab2_tile3_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    private txt_tab2_tile4_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    private txt_tab2_tile5_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    private txt_tab2_tile6_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    // tab 3 - tile titles
    private txt_tab3_tile1_title = "Lebenslauf und Qualifikationen";
    private txt_tab3_tile2_title = "Nachweise über Abschlüsse";
    private txt_tab3_tile3_title = "Kenntnisse und Fähigkeiten";
    private txt_tab3_tile4_title = "Leistungsfähigkeit, Motivation";
    private txt_tab3_tile5_title = "Persönliche Rahmenbedingungen";
    private txt_tab3_tile6_title = "Einschätzung der Arbeitsfähigkeit";
    // tab 3 - section 1 texts
    private txt_tab3_tile1_section1 = "Lebenslauf (schulischer und beruflicher Werdegang), Weiterbildungen, zertifizierte Lehrgänge, Führerschein";
    private txt_tab3_tile2_section1 = "Beispielsweise Schulabschlüsse, Studienabschlüsse oder Berufsausbildungen";
    private txt_tab3_tile3_section1 = "Ihre eigenen Angaben zu Fähigkeiten ohne schriftliche Nachweise";
    private txt_tab3_tile4_section1 = "Persönliche Angaben zur Einschätzung der eigenen Leistungsfähigkeit und Motivation für bestimmte Tätigkeiten";
    private txt_tab3_tile5_section1 = "Angaben zu Rahmenbedingungen wie Mobilität, freiwillige Angaben zu familiärer Situation, Wohnsituation";
    private txt_tab3_tile6_section1 = "Die Arbeitsagentur darf medizinische oder psychologische Dienste mit der Einschätzung der Arbeitsfähigkeit von Ihnen beauftragen. Die Mitarbeiter in der Arbeitsagentur erhalten daraufhin keine Diagnosen, sondern nur die Information, in welchem Umfang Sie arbeitsfähig sind oder nicht.";
    // tab 3 - section 3 texts
    private txt_tab3_tile1_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab3_tile2_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab3_tile3_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab3_tile4_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab3_tile5_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab3_tile6_section3 = "§ 394 SGB III";
    // tab 4 - tile titles
    private txt_tab4_tile1_title = "Vermerke und Notizen";
    private txt_tab4_tile2_title = "Stellenangebote";
    private txt_tab4_tile3_title = "Stellengesuche";
    //Noch nicht benötigt
    private txt_tab4_tile4_title = "Vermerke und Notizen";
    private txt_tab4_tile5_title = "Stellenangebote";
    private txt_tab4_tile6_title = "Stellengesuche";
    // tab 4 - section 1 texts
    private txt_tab4_tile1_section1 = "Beratungs- und Vermittlungsvermerke, zum Beispiel wann welche Beratungstermine stattgefunden haben";
    private txt_tab4_tile2_section1 = "Stellenangebote, die zu Ihrem Profil passen und vorgeschlagen wurden";
    private txt_tab4_tile3_section1 = "Informationen über Stellengesuche           (Bewerbungen), die Sie gestellt haben, gegebenenfalls auch Rückmeldungen dazu";
    //Noch nicht benötigt
    private txt_tab4_tile4_section1 = "Beratungs- und Vermittlungsvermerke, zum Beispiel wann welche Beratungstermine stattgefunden haben";
    private txt_tab4_tile5_section1 = "Stellenangebote, die zu Ihrem Profil passen und vorgeschlagen wurden";
    private txt_tab4_tile6_section1 = "Informationen über Stellengesuche           (Bewerbungen), die Sie gestellt haben, gegebenenfalls auch Rückmeldungen dazu";
    // tab 4 - section 3 texts
    private txt_tab4_tile1_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab4_tile2_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab4_tile3_section3 = "§ 67a ff SGB X und § 394 SGB III";
    //Noch nicht benötigt
    private txt_tab4_tile4_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab4_tile5_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab4_tile6_section3 = "§ 67a ff SGB X und § 394 SGB III";
    // tab 5 - tile titles
    private txt_tab5_tile1_title = "Bank- und Steuerdaten";
    private txt_tab5_tile2_title = "Einkommensnachweise";
    private txt_tab5_tile3_title = "Zeitraum letztes Beschäftigungsverhältnis";
    private txt_tab5_tile4_title = "Kranken- und Pflegeversicherung";
    private txt_tab5_tile5_title = "Rentenversicherung";
    private txt_tab5_tile6_title = "Anspruch auf Nahtlosigkeitsregelung";
    // tab 5 - section 1 texts
    private txt_tab5_tile1_section1 = "Bankverbindung und Steuer-ID";
    private txt_tab5_tile2_section1 = "Einkommensnachweise für sozialversicherungspflichtiges Einkommen der letzten 12 Monate";
    private txt_tab5_tile3_section1 = "Dauer und Ende des letzten Beschäftigungsverhältnisses";
    private txt_tab5_tile4_section1 = "Daten zur Kranken- und Pflegeversicherung";
    private txt_tab5_tile5_section1 = "Daten zur Rentenversicherung werden üblicherweise nicht erfasst";
    private txt_tab5_tile6_section1 = "Es kann in besonderen Fällen ein Anspruch auf Arbeitslosengeld bestehen, auch wenn Sie aktuell arbeitsunfähig sind und kein Anspruch mehr auf Krankengeld besteht (§ 145 SGB III). Ihr zuständiger Vermittler kann Sie dazu beraten.";
    // tab 5 - section 3 texts
    private txt_tab5_tile1_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab5_tile2_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab5_tile3_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab5_tile4_section3 = "§ 67a ff SGB X und § 394 SGB III";
    private txt_tab5_tile5_section3 = "§ 397 SGB III";
    private txt_tab5_tile6_section3 = "§ 67a ff SGB X und § 394 SGB III ";
    // tab 6 - tile titles
    private txt_tab6_tile1_title = "Leistungen der Arbeitsförderung";
    private txt_tab6_tile2_title = "Sozialgeheimnis";
    private txt_tab6_tile3_title = "Mitwirkung des Leistungsberechtigten";
    private txt_tab6_tile4_title = "Verarbeitung von Sozialdaten";
    private txt_tab6_tile5_title = "Meldepflicht";
    private txt_tab6_tile6_title = "tab6_tile6_title";
    // tab 6 - Pictotext
    private txt_tab6_tile1_pict = "§ 19 SGB I";
    private txt_tab6_tile2_pict = "§ 35 Abs. 1 SGB I";
    private txt_tab6_tile3_pict = "§ 60 ff SGB I";
    private txt_tab6_tile4_pict = "§ 67 ff SGB X & § 394 SGB III";
    private txt_tab6_tile5_pict = "§ 38 Abs. 1 SGB III";
    private txt_tab6_tile6_pict = "tab6_tile6_title";
    // tab 6 - section 1 texts
    private txt_tab6_tile1_plaintext = "Das Gesetz regelt die Leistungen der Arbeitsförderung. Zuständig als Leistungsträger sind die Agenturen für Arbeit (ehemals Arbeitsamt). Nach dem Recht können in Anspruch genommen werden: Berufs- und Arbeitsmarktberatung, Ausbildungs- und Arbeitsvermittlung, verschiedene Leistungen (zB zur beruflichen Eingliederung, zur beruflichen Weiterbildung oder zur Aufnahme einer Erwerbstätigkeit) sowie Arbeitslosengeld.";
    private txt_tab6_tile2_plaintext = "Leistungsträger dürfen die Sozialdaten einer Person nicht unbefugt verarbeiten. Leistungsträger sind auch verpflichtet, innerhalb des Trägers sicherzustellen, dass nur Befugte Zugriff auf die Sozialdaten haben.";
    private txt_tab6_tile3_plaintext = "Wer Sozialleistungen beantragt oder erhält, hat gewisse Mitwirkungspflichten. So müssen u.a. alle Tatsachen angegeben werden, die für die Leistung erheblich sind und Änderungen in den Verhältnissen, die relevant sind für die Leistung, unverzüglich mitgeteilt werden. Auch das persönliche Erscheinen beim Leistungsträger, die Teilnahme an ärztlichen und psychologischen Untersuchungen, sofern sie für die Entscheidung über die Leistung erforderlich und zumutbar sind, und die Teilnahme an Heilbehandlungen fällt in diesen Bereich der Mitwirkungspflicht. Unter der Berücksichtigung der beruflichen Neigung und der eigenen Leistungsfähigkeit sowie der geeigneten Förderung der Erwerbs- oder Vermittlungsfähigkeit kann auch die Teilnahme an Leistungen zur Teilhabe am Arbeitsleben verlangt werden.";
    private txt_tab6_tile4_plaintext = "Sozialdaten sind gem. § 67 Abs. 2 SGB X personenbezogene Daten, die von den Leistungsträgern (zB Agenturen für Arbeit) für ihre Aufgaben gemäß dem Sozialgesetzbuch verarbeitet werden (Aufgaben werden aufgeführt in §394 Abs. 1 SGB III). Dabei sind die Leistungsträger befugt diese Daten zu erheben, wenn die Kenntnis der Daten zur Erfüllung ihrer Aufgaben erforderlich ist (zB der Lebenslauf für die Arbeitsvermittlung). Sozialdaten müssen primär bei der betroffenen Person erhoben werden, außer andere Stellen sind befugt die Daten an den Leistungsträger zu übermitteln. Jegliche Speicherung, Veränderung, Nutzung und Übermittlung der Sozialdaten bedarf einer Vorschrift aus dem Sozialgesetzbuch und die Verarbeitung der Daten muss dabei zweckbestimmt erfolgen. ";
    private txt_tab6_tile5_plaintext = "Endet ein Ausbildungs- oder Arbeitsverhältnis, ist die Person verpflichtet, sich spätestens 3 Monate vor dessen Beendigung bei der Agentur für Arbeit arbeitssuchend zu melden. Erfährt man kurzfristiger vom Ende des Ausbildungs- oder Arbeitsverhältnisses, ist man verpflichtet sich innerhalb von 3 Tagen nach Kenntnis des Beendigungszeitpunktes zu melden. Bei Verstoß gegen die Meldepflicht (verspätete Arbeitssuchendmeldung) erhält man eine Sperrzeit von einer Woche, in der man kein Arbeitslosengeld beziehen kann.";
    
    // extra allowed institutions
    private txt_tab3_tile6_section2_extra = "(*) nur 3 explizite Mitarbeiter der Vermittlung";
    private txt_tab5_tile5_section2_extra = "Nur bei Unstimmigkeiten mit anderen Daten erfolgt ein Austausch zwischen dem Mitarbeiter der Leistungsberechnung und der Rentenversicherung.";
    //private txt_tab5_tile6_section2_extra = "(*) Leistungsberechnung erhält nur Information, dass Anspruch besteht";
    private txt_tab4_tile1_section2_extra = "(*) Eingangszone erhält nur Information, falls Ihr Vermittler die Daten freigegeben hat";

    //#endregion

    //#region SECTION 2 VALUES
    // map institutions to ids (usage below)
    private institution_ids = new Map<string, number>([
        [this.txt_tab1_tile1_title, 1],
        [this.txt_tab1_tile2_title, 2],
        [this.txt_tab1_tile3_title, 3],
    ]);
    // tab 2
    private allowed_institutions_tab2_tile1 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab2_tile2 = new Map<number, boolean>([
        [1, true],
        [2, true], 
        [3, true]
    ]);
    private allowed_institutions_tab2_tile3 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab2_tile4 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab2_tile5 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab2_tile6 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    // tab 3
    private allowed_institutions_tab3_tile1 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab3_tile2 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab3_tile3 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab3_tile4 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab3_tile5 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab3_tile6 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    // tab 4
    private allowed_institutions_tab4_tile1 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab4_tile2 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab4_tile3 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
     //nicht benötigt in doku
    private allowed_institutions_tab4_tile4 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab4_tile5 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
    private allowed_institutions_tab4_tile6 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, false]
    ]);
    // tab 5
    private allowed_institutions_tab5_tile1 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab5_tile2 = new Map<number, boolean>([
        [1, false],
        [2, false],
        [3, true]
    ]);
    private allowed_institutions_tab5_tile3 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab5_tile4 = new Map<number, boolean>([
        [1, false],
        [2, false],
        [3, true]
    ]);
    private allowed_institutions_tab5_tile5 = new Map<number, boolean>([
        [1, false],
        [2, false],
        [3, true]
    ]);
    private allowed_institutions_tab5_tile6 = new Map<number, boolean>([
        [1, false],
        [2, true],
        [3, true]
    ]);
    // tab 6
    private allowed_institutions_tab6_tile1 = new Map<number, boolean>([
        [1, false],
        [2, false],
        [3, true]
    ]);
    private allowed_institutions_tab6_tile2 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab6_tile3 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab6_tile4 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab6_tile5 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    private allowed_institutions_tab6_tile6 = new Map<number, boolean>([
        [1, true],
        [2, true],
        [3, true]
    ]);
    //#endregion

turn_tab_on(on_tab) {
    on_tab.active = true;
}

turn_tab_off(off_tab) {
    off_tab.active = false;
}

turn_tabs_off(){
    this.tab1.active = false;
    this.tab2.active = false;
    this.tab3.active = false;
    this.tab4.active = false;
    this.tab5.active = false;
    this.tab6.active = false;
}

turn_tile_on(on_tile) {
    on_tile.active = true;
}

turn_tile_off(off_tile){
    off_tile.active = false;
}

toggle_book(){
    if (this.buchGroß.active){
        this.buchGroß.active = false;
        this.overlay.active = false;
        this.backgroundRight.active = false;
        this.backgroundLeft.active = false;
    }
    else{
        this.buchGroß.active = true;
        this.overlay.active = true;
        this.backgroundRight.active = true;
        this.backgroundLeft.active = true;
    }
}

change_tile_text_size(tile, size){
    var labelNode = tile.getChildByName("Label");
    var labelComponent = labelNode.getComponent(Label);
    labelComponent.fontSize = size;
}

switch_law_on(){
        this.paragraph1.active = true;
        this.paragraph2.active = true;
        this.paragraph3.active = true;
        this.paragraph4.active = true;
        this.paragraph5.active = true;
        this.paragraph6.active = true;
}

switch_law_off(){
        this.paragraph1.active = false;
        this.paragraph2.active = false;
        this.paragraph3.active = false;
        this.paragraph4.active = false;
        this.paragraph5.active = false;
        this.paragraph6.active = false;
}

empty_book(){
    this.turn_tabs_off()
    this.turn_tile_off(this.tile1)
    this.turn_tile_off(this.tile2)
    this.turn_tile_off(this.tile3)
    this.turn_tile_off(this.tile4)
    this.turn_tile_off(this.tile5)
    this.turn_tile_off(this.tile6)
    
}


    start() {
        this.backgroundRight.active = false;
        this.backgroundLeft.active = false;
        this.close.on(Node.EventType.MOUSE_DOWN, (event) => {
            console.log("cross click");
            this.toggle_book();

        }, this);
        
        this.buchKlein.on(Node.EventType.MOUSE_DOWN, (event) => {
            if(!this.buchGroß.active && !this.overlay.active){
                console.log("book click");
                this.buchGroß.active = true;
                this.overlay.active = true;
                this.backgroundRight.active = true;
                this.backgroundLeft.active = true;
            }
        }, this);

        this.backgroundLeft.on(Node.EventType.MOUSE_DOWN, (event) => {
            if(this.overlay.active){
                console.log("background click")
                this.toggle_book()
            }
        }, this);

        this.backgroundRight.on(Node.EventType.MOUSE_DOWN, (event) => {
            if(this.overlay.active){
                console.log("background click")
                this.toggle_book()
            }
        }, this);



        // initial tab setup
        this.tab1.getChildByName("Label").getComponent(Label).string = this.txt_tab1_title;
        this.tab2.getChildByName("Label").getComponent(Label).string = this.txt_tab2_title;
        this.tab3.getChildByName("Label").getComponent(Label).string = this.txt_tab3_title;
        this.tab4.getChildByName("Label").getComponent(Label).string = this.txt_tab4_title;
        this.tab5.getChildByName("Label").getComponent(Label).string = this.txt_tab5_title;
        this.tab6.getChildByName("Label").getComponent(Label).string = this.txt_tab6_title;

        // tab-logic
        this.tab1.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 1;
            // set active tile to 1 as default 
            this.active_tile = 1;
        }, this);
        this.tab2.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 2;
        }, this);
        this.tab3.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 3;
        }, this);
        this.tab4.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 4;
        }, this);
        this.tab5.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 5;
        }, this);
        this.tab6.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tab = 6;
        }, this);

        // tile-logic
        this.tile1.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 1;
        }, this);
        this.tile2.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 2;
        }, this);
        this.tile3.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 3;
        }, this);
        this.tile4.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 4;
        }, this);
        this.tile5.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 5;
        }, this);
        this.tile6.on(Node.EventType.MOUSE_DOWN, (event) => {
            this.active_tile = 6;
        }, this);

        // initial sections setup
        this.section1_picto_label.string = this.txt_section1_title;
        this.section2_picto_label.string = this.txt_section2_title;
        this.section3_picto_label.string = this.txt_section3_title;

        // close book
        //this.goBack.on(Node.EventType.MOUSE_DOWN, (event) => {
            //this.overlay.active = false;
           // this.buchGroß.active = false;
            //console.log("back click");
            // this.getComponent(BlockInputEvents).enabled = false;
        //}, this);

        this.buchGroß.active = false;
    }

    update(deltaTime: number) {
        //init scene
        if (Buch.NEW_SCENE){
            switch (Buch.CURRENT_SCENE) {
                case 'Ankunft':
                    this.active_tab = 0;
                    this.empty_book()
                    Buch.NEW_SCENE = false;
                    Buch.BOOK_UPDATE = 0;
                    break;
                case 'Empfang':
                    this.active_tab = 0;
                    this.empty_book()
                    Buch.NEW_SCENE = false;
                    Buch.BOOK_UPDATE = 1;
                    break;
                case 'Leistungsabrechnung':
                    this.empty_book()
                    this.turn_tab_on(this.tab1);
                    this.turn_tab_on(this.tab2);
                    this.turn_tab_on(this.tab3);
                    this.turn_tab_on(this.tab4)
                    this.active_tab = 4;
                    Buch.NEW_SCENE = false;
                    Buch.BOOK_UPDATE = 5;
                    break;
                case 'Szenenauswahl':
                    this.turn_tab_on(this.tab4)
                    Buch.NEW_SCENE = false;
                    break;
                case 'Vermittlungsraum':
                    this.empty_book()
                    this.turn_tab_on(this.tab1);
                    this.turn_tab_on(this.tab2);
                    this.active_tab = 2;
                    Buch.BOOK_UPDATE = 3;
                    Buch.NEW_SCENE = false;
                    break;
                case 'Wartezimmer':
                    this.empty_book()
                    this.turn_tab_on(this.tab1);
                    this.turn_tab_on(this.tab2);
                    this.active_tab = 2;
                    Buch.BOOK_UPDATE = 3;
                    Buch.NEW_SCENE = false;
                    break;
                case 'Wohnung':
                    this.turn_tab_on(this.tab6)
                    Buch.NEW_SCENE = false;
                    break;
                case 'Ende':
                    this.turn_tab_on(this.tab1);
                    this.turn_tab_on(this.tab2);
                    this.turn_tab_on(this.tab3);
                    this.turn_tab_on(this.tab4);
                    this.turn_tab_on(this.tab5);
                    this.turn_tab_on(this.tab6);
                    this.active_tab = 6;
                    Buch.BOOK_UPDATE = 6;
                    Buch.NEW_SCENE = false;
                    break;
                default:
                    this.turn_tab_on(this.tab1)
                    Buch.NEW_SCENE = false;
                    break;
            } 
    }

        // event "NEW_DATA" triggered? --> run animation small book
        //Buch change in running game
        if (Buch.NEW_DATA) {
            Buch.NEW_DATA = false;
            console.log("Trigger Animation");
            this.buchKlein.getComponent(Animation).play();
            console.log(Buch.NEW_CONTENT);
                    // event "NEW_DATA" triggered? --> run animation small book
            switch(Buch.BOOK_UPDATE){
                case 0:
                    //Init
                    this.empty_book()
                    this.active_tab = 0;
                    break;
                case 1:
                    //Empfang
                    this.turn_tab_on(this.tab1);
                    this.active_tab = 1;
                    break;
                case 2:
                    //Empfang
                    this.turn_tab_on(this.tab2)
                    this.active_tab = 2;
                    break;
                case 3:
                    this.turn_tab_on(this.tab3)
                    this.active_tab = 3;
                    break;
                case 4:
                    this.turn_tab_on(this.tab4)
                    this.active_tab = 4;
                    break;
                case 5:
                    this.turn_tab_on(this.tab5)
                    this.active_tab = 5;
                    break;
                case 6:
                    this.active_tab = 6
                    break;
                default:
                    this.active_tab = 1;
                    break;
            }
            Buch.BOOK_UPDATE++;
        }
        //Tab an left side of tiles
        switch (this.active_tab) {
            case 0:
                this.switch_law_off()
                //this.switch_law(false);
                this.paragraph1.active = false;
                this.title.getComponent(Label).string = this.txt_tab0_title;
                this.plain_text.getComponent(Label).string = this.txt_tab0_plaintext;
                this.plain_text.active = true;
                //Intro text position
                this.plain_text.position = v3(343, 211, 0);
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = false;
                break;

            case 1:
                //Normale position
                this.plain_text.position = v3(343, -52, 0);
                this.switch_law_off()
                //this.switch_law(false);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_off(this.tile4);
                this.turn_tile_off(this.tile5);
                this.turn_tile_off(this.tile6);
                // set active tab color
                this.tab1.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab2.getComponent(Sprite).color = Color.WHITE;
                this.tab3.getComponent(Sprite).color = Color.WHITE;
                this.tab4.getComponent(Sprite).color = Color.WHITE;
                this.tab5.getComponent(Sprite).color = Color.WHITE;
                this.tab6.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution1_picto;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                // set tile labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab1_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab1_tile2_title;
                this.change_tile_text_size(this.tile3, 20)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab1_tile3_title;
                // set page content
                this.plain_text.active = true;
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = false;

                break;
            case 2:
                this.switch_law_off()
                //this.switch_law(false);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_on(this.tile4);
                this.turn_tile_on(this.tile5);
                this.turn_tile_on(this.tile6);
                // set active tab color
                this.tab2.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab1.getComponent(Sprite).color = Color.WHITE;
                this.tab3.getComponent(Sprite).color = Color.WHITE;
                this.tab4.getComponent(Sprite).color = Color.WHITE;
                this.tab5.getComponent(Sprite).color = Color.WHITE;
                this.tab6.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten1_picto;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten2_picto;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten3_picto;
                this.tile4.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten4_picto;
                this.tile5.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten5_picto;
                this.tile6.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.stammdaten6_picto;
                //set tiles labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile2_title;
                this.change_tile_text_size(this.tile3, 20)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile3_title;
                this.tile4.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile4_title;
                this.tile5.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile5_title;
                this.tile6.getChildByName("Label").getComponent(Label).string = this.txt_tab2_tile6_title;
                // set page content
                this.plain_text.active = false;
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = true;
                break;
            case 3:
                this.switch_law_off()
                //this.switch_law(false);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_on(this.tile4);
                this.turn_tile_on(this.tile5);
                this.turn_tile_on(this.tile6);

                // set active tab color
                this.tab3.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab2.getComponent(Sprite).color = Color.WHITE;
                this.tab1.getComponent(Sprite).color = Color.WHITE;
                this.tab4.getComponent(Sprite).color = Color.WHITE;
                this.tab5.getComponent(Sprite).color = Color.WHITE;
                this.tab6.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung1_picto;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung2_picto;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung3_picto;
                this.tile4.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung4_picto;
                this.tile5.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung5_picto;
                this.tile6.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.vermittlung6_picto;
                //set tiles labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile2_title;
                this.change_tile_text_size(this.tile3, 20)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile3_title;
                this.tile4.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile4_title;
                this.tile5.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile5_title;
                this.tile6.getChildByName("Label").getComponent(Label).string = this.txt_tab3_tile6_title;
                // set page content
                this.plain_text.active = false;
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = true;
                break;
            case 4:
                this.switch_law_off()
                //this.switch_law(false);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_off(this.tile4);
                this.turn_tile_off(this.tile5);
                this.turn_tile_off(this.tile6);
                // set active tab color
                this.tab4.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab2.getComponent(Sprite).color = Color.WHITE;
                this.tab3.getComponent(Sprite).color = Color.WHITE;
                this.tab1.getComponent(Sprite).color = Color.WHITE;
                this.tab5.getComponent(Sprite).color = Color.WHITE;
                this.tab6.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.doku1_picto;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.doku2_picto;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.doku3_picto;
                //set tiles labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile2_title;
                this.change_tile_text_size(this.tile3, 20)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile3_title;
                this.tile4.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile4_title;
                this.tile5.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile5_title;
                this.tile6.getChildByName("Label").getComponent(Label).string = this.txt_tab4_tile6_title;
                // set page content
                this.plain_text.active = false;
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = true;
                break;

            case 5:
                this.switch_law_off()
                //this.switch_law(false);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_on(this.tile4);
                this.turn_tile_on(this.tile5);
                this.turn_tile_off(this.tile6);
                // set active tab color
                this.tab5.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab2.getComponent(Sprite).color = Color.WHITE;
                this.tab3.getComponent(Sprite).color = Color.WHITE;
                this.tab1.getComponent(Sprite).color = Color.WHITE;
                this.tab4.getComponent(Sprite).color = Color.WHITE;
                this.tab6.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung1_picto;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung2_picto;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung3_picto;
                this.tile4.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung4_picto;
                this.tile5.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung5_picto;
                this.tile6.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.Leistung6_picto;
                //set tiles labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile2_title;
                //Text größe ändern
                this.change_tile_text_size(this.tile3, 18)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile3_title;
                this.tile4.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile4_title;
                this.tile5.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile5_title;
                this.tile6.getChildByName("Label").getComponent(Label).string = this.txt_tab5_tile5_title;
                // set page content
                this.plain_text.active = false;
                this.Lawtext_scrollbar.active = false;
                this.info_sections.active = true;
                break;
            case 6:
                this.switch_law_on()
                //this.switch_law(true);
                this.turn_tile_on(this.tile1);
                this.turn_tile_on(this.tile2);
                this.turn_tile_on(this.tile3);
                this.turn_tile_on(this.tile4);
                this.turn_tile_on(this.tile5);
                this.turn_tile_off(this.tile6);
                // set active tab color
                this.tab6.getComponent(Sprite).color = this.active_tab_color;
                // reset other tab-colors
                this.tab2.getComponent(Sprite).color = Color.WHITE;
                this.tab3.getComponent(Sprite).color = Color.WHITE;
                this.tab1.getComponent(Sprite).color = Color.WHITE;
                this.tab5.getComponent(Sprite).color = Color.WHITE;
                this.tab4.getComponent(Sprite).color = Color.WHITE;
                // set tile pictos
                this.tile1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.tile2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.tile3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.tile4.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.tile5.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.tile6.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.empty;
                this.paragraph1.getComponent(Label).string = this.txt_tab6_tile1_pict;
                this.paragraph2.getComponent(Label).string = this.txt_tab6_tile2_pict;
                this.paragraph3.getComponent(Label).string = this.txt_tab6_tile3_pict;
                this.paragraph4.getComponent(Label).string = this.txt_tab6_tile4_pict;
                this.paragraph5.getComponent(Label).string = this.txt_tab6_tile5_pict;
                this.paragraph6.getComponent(Label).string = this.txt_tab6_tile5_pict;
                //set tiles labels
                this.tile1.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile1_title;
                this.tile2.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile2_title;
                //this.change_tile_text_size(this.tile3, 20)
                this.tile3.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile3_title;
                this.tile4.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile4_title;
                this.tile5.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile5_title;
                this.tile6.getChildByName("Label").getComponent(Label).string = this.txt_tab6_tile5_title;
                // set page content
                this.Lawtext_scrollbar.active = true;
                this.info_sections.active = false;
                break;
        }

        // highlight the active tile with color and set according data on right page
        switch (this.active_tile) {
            case 1:
                this.extra_text.getComponent(Label).string = "";
                this.extra_text_right.getComponent(Label).string = "";
                this.plain_text.getComponent(Label).fontSize = 30;
                // set tile color
                if (this.active_tab != 1) {
                this.tile1.getComponent(Sprite).color = this.active_tile_color;
                } else {
                    this.tile1.getComponent(Sprite).color = this.institution1_color;
                }
                // reset other tile colors
                this.tile2.getComponent(Sprite).color = Color.WHITE;
                this.tile3.getComponent(Sprite).color = Color.WHITE;
                this.tile4.getComponent(Sprite).color = Color.WHITE;
                this.tile5.getComponent(Sprite).color = Color.WHITE;
                this.tile6.getComponent(Sprite).color = Color.WHITE;
                // set tab1 content
                if (this.active_tab == 1) {
                    this.title.getComponent(Label).string = this.txt_tab1_tile1_title;
                    this.plain_text.getComponent(Label).string = this.txt_tab1_tile1_plaintext;
                }
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile1_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile1_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile1);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile1_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile1_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile1_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile1);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile1_section3;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile1_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile1_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile1);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile1_section3;
                    this.extra_text.getComponent(Label).string = this.txt_tab4_tile1_section2_extra;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile1_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile1_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile1);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile1_section3;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile1_title;
                    this.Lawtext_label.string = this.txt_tab6_tile1_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
            case 2:
                this.extra_text.getComponent(Label).string = "";
                this.section1_text.getComponent(Label).fontSize = 25;
                this.extra_text_right.getComponent(Label).string = "";
                this.plain_text.getComponent(Label).fontSize = 30;
                // set tile color
                if (this.active_tab != 1) {
                    this.tile2.getComponent(Sprite).color = this.active_tile_color;
                } else {
                    this.tile2.getComponent(Sprite).color = this.institution2_color;
                }
                // reset other tile colors
                this.tile1.getComponent(Sprite).color = Color.WHITE;
                this.tile3.getComponent(Sprite).color = Color.WHITE;
                this.tile4.getComponent(Sprite).color = Color.WHITE;
                this.tile5.getComponent(Sprite).color = Color.WHITE;
                this.tile6.getComponent(Sprite).color = Color.WHITE;
                // set title text
                // set tab1 content
                if (this.active_tab == 1) {
                    this.title.getComponent(Label).string = this.txt_tab1_tile2_title;
                    this.plain_text.getComponent(Label).string = this.txt_tab1_tile2_plaintext;

                }
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile2_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile2_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile2);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile2_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile2_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile2_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile2);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile2_section3;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile2_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile2_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile2);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile2_section3;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile2_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile2_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile2);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile2_section3;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile2_title;
                    this.Lawtext_label.string = this.txt_tab6_tile2_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
            case 3:
                this.plain_text.getComponent(Label).fontSize = 30;
                this.extra_text.getComponent(Label).string = "";
                this.section1_text.getComponent(Label).fontSize = 25;
                this.extra_text_right.getComponent(Label).string = "";
                // set tile color
                if (this.active_tab != 1) {
                    this.tile3.getComponent(Sprite).color = this.active_tile_color;
                } else {
                    this.tile3.getComponent(Sprite).color = this.institution3_color;
                }
                // reset other tile colors
                this.tile2.getComponent(Sprite).color = Color.WHITE;
                this.tile1.getComponent(Sprite).color = Color.WHITE;
                this.tile4.getComponent(Sprite).color = Color.WHITE;
                this.tile5.getComponent(Sprite).color = Color.WHITE;
                this.tile6.getComponent(Sprite).color = Color.WHITE;
                // set tab1 content
                if (this.active_tab == 1) {
                    this.title.getComponent(Label).string = this.txt_tab1_tile3_title;
                    this.plain_text.getComponent(Label).string = this.txt_tab1_tile3_plaintext;
                }
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile3_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile3_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile3);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile3_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile3_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile3_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile3);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile3_section3;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile3_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile3_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile3);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile3_section3;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile3_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile3_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile3);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile3_section3;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile3_title;
                    //this.plain_text.getComponent(Label).fontSize = 20;
                    this.Lawtext_label.string = this.txt_tab6_tile3_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
            case 4:
                this.plain_text.getComponent(Label).fontSize = 30;
                this.extra_text.getComponent(Label).string = "";
                this.section1_text.getComponent(Label).fontSize = 25;
                this.extra_text_right.getComponent(Label).string = "";
                // set tile color
                this.tile4.getComponent(Sprite).color = this.active_tile_color;
                // reset other tile colors
                this.tile2.getComponent(Sprite).color = Color.WHITE;
                this.tile3.getComponent(Sprite).color = Color.WHITE;
                this.tile1.getComponent(Sprite).color = Color.WHITE;
                this.tile5.getComponent(Sprite).color = Color.WHITE;
                this.tile6.getComponent(Sprite).color = Color.WHITE;
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile4_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile4_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile4);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile4_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile4_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile4_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile4);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile4_section3;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile4_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile4_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile4);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile4_section3;
                    this.extra_text.getComponent(Label).string = this.txt_tab4_tile1_section2_extra;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile4_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile4_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile4);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile4_section3;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile4_title;
                    //this.plain_text.getComponent(Label).fontSize = 20;
                    this.Lawtext_label.string = this.txt_tab6_tile4_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
            case 5:
                this.plain_text.getComponent(Label).fontSize = 30;
                this.extra_text.getComponent(Label).string = "";
                this.section1_text.getComponent(Label).fontSize = 25;
                this.extra_text_right.getComponent(Label).string = "";
                // set tile color
                this.tile5.getComponent(Sprite).color = this.active_tile_color;
                // reset other tile colors
                this.tile2.getComponent(Sprite).color = Color.WHITE;
                this.tile3.getComponent(Sprite).color = Color.WHITE;
                this.tile4.getComponent(Sprite).color = Color.WHITE;
                this.tile1.getComponent(Sprite).color = Color.WHITE;
                this.tile6.getComponent(Sprite).color = Color.WHITE;
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile5_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile5_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile5);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile5_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile5_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile5_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile5);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile5_section3;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile5_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile5_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile5);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile5_section3;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile5_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile5_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile5);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile5_section3;
                    this.extra_text_right.getComponent(Label).string = this.txt_tab5_tile5_section2_extra;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile5_title;
                    this.Lawtext_label.string = this.txt_tab6_tile5_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
            case 6:
                this.plain_text.getComponent(Label).fontSize = 30;
                this.extra_text.getComponent(Label).string = "";
                this.section1_text.getComponent(Label).fontSize = 25;
                this.extra_text_right.getComponent(Label).string = "";
                // set tile color
                this.tile6.getComponent(Sprite).color = this.active_tile_color;
                // reset other tile colors
                this.tile2.getComponent(Sprite).color = Color.WHITE;
                this.tile3.getComponent(Sprite).color = Color.WHITE;
                this.tile4.getComponent(Sprite).color = Color.WHITE;
                this.tile5.getComponent(Sprite).color = Color.WHITE;
                this.tile1.getComponent(Sprite).color = Color.WHITE;
                // set tab2 content
                if (this.active_tab == 2) {
                    this.title.getComponent(Label).string = this.txt_tab2_tile6_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab2_tile6_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab2_tile6);
                    this.section3_text.getComponent(Label).string = this.txt_tab2_tile6_section3;
                }
                // set tab3 content
                if (this.active_tab == 3) {
                    this.title.getComponent(Label).string = this.txt_tab3_tile6_title;
                    this.section1_text.getComponent(Label).fontSize = 20;
                    this.section1_text.getComponent(Label).string = this.txt_tab3_tile6_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab3_tile6);
                    this.section3_text.getComponent(Label).string = this.txt_tab3_tile6_section3;
                    this.extra_text.getComponent(Label).string = this.txt_tab3_tile6_section2_extra;
                }
                // set tab4 content
                if (this.active_tab == 4) {
                    this.title.getComponent(Label).string = this.txt_tab4_tile6_title;
                    this.section1_text.getComponent(Label).string = this.txt_tab4_tile6_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab4_tile6);
                    this.section3_text.getComponent(Label).string = this.txt_tab4_tile6_section3;
                }
                // set tab5 content
                if (this.active_tab == 5) {
                    this.title.getComponent(Label).string = this.txt_tab5_tile5_title;
                    //this.section1_text.getComponent(Label).fontSize = 15;
                    this.section1_text.getComponent(Label).string = this.txt_tab5_tile5_section1;
                    this.visualizeMiniPictos(this.allowed_institutions_tab5_tile5);
                    this.section3_text.getComponent(Label).string = this.txt_tab5_tile5_section3;
                    this.extra_text_right.getComponent(Label).string = this.txt_tab5_tile5_section2_extra;
                }
                // set tab6 content
                if (this.active_tab == 6) {
                    this.title.getComponent(Label).string = this.txt_tab6_tile5_title;
                    this.Lawtext_label.string = this.txt_tab6_tile5_plaintext;
                    this.scrollbar_content.getComponent(UITransform).height =  this.Lawtext_label.getComponent(UITransform).height;
                }
                break;
        }

    }

    visualizeMiniPictos(input: Map<number, boolean>) {
        // number of allowed institutions
        let count = 0;
        input.forEach(element => {
            if (element == true) {
                count++;
            }
        });
        // set minipicto templates active or inactive according to the number of allowed institutions
        if (count == 1) {
            this.section2_minipicto1.active = true;
            this.section2_minipicto2.active = false;
            this.section2_minipicto3.active = false;
            // set minipicto pictos, labels and colors according to allowed institutions
            if (input.get(1) == true) {
                this.section2_minipicto1.getComponent(Sprite).spriteFrame = this.institution1_picto;
                this.section2_minipicto1_label.string = this.institution1_title;
                this.section2_minipicto1.getComponent(Sprite).color = this.institution1_color;
            }
            if (input.get(2) == true) {
                this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                this.section2_minipicto1_label.string = this.institution2_title;
                this.section2_minipicto1.getComponent(Sprite).color = this.institution2_color;
            }
            if (input.get(3) == true) {
                this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                this.section2_minipicto1_label.string = this.institution3_title;
                this.section2_minipicto1.getComponent(Sprite).color = this.institution3_color;
            }
        }
        if (count == 2) {
            this.section2_minipicto1.active = true;
            this.section2_minipicto2.active = true;
            this.section2_minipicto3.active = false;
            // check if minipicto already used
            let check = 0;
            // set minipicto pictos, labels and colors according to allowed institutions
            if (input.get(1) == true) {
                this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution1_picto;
                this.section2_minipicto1_label.string = this.institution1_title;
                this.section2_minipicto1.getComponent(Sprite).color = this.institution1_color;
                check++;
            }
            if (input.get(2) == true) {
                if (check < 1) {
                    this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                    this.section2_minipicto1_label.string = this.institution2_title;
                    this.section2_minipicto1.getComponent(Sprite).color = this.institution2_color;
                    check++;
                } else {
                    this.section2_minipicto2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                    this.section2_minipicto2_label.string = this.institution2_title;
                    this.section2_minipicto2.getComponent(Sprite).color = this.institution2_color;
                    check++;
                }
            }
            if (input.get(3) == true) {
                if (check < 1) {
                    this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                    this.section2_minipicto1_label.string = this.institution3_title;
                    this.section2_minipicto1.getComponent(Sprite).color = this.institution3_color;
                    check++;
                } else {
                    this.section2_minipicto2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                    this.section2_minipicto2_label.string = this.institution3_title;
                    this.section2_minipicto2.getComponent(Sprite).color = this.institution3_color;
                } 
            }
        }
        if (count == 3) {
            this.section2_minipicto1.active = true;
            this.section2_minipicto2.active = true;
            this.section2_minipicto3.active = true;
            // check if minipicto already used
            let check = 0;
            // set minipicto pictos, labels and colors according to allowed institutions
            if (input.get(1) == true) {
                this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution1_picto;
                this.section2_minipicto1_label.string = this.institution1_title;
                this.section2_minipicto1.getComponent(Sprite).color = this.institution1_color;
                check++;
            }
            if (input.get(2) == true) {
                if (check < 1) {
                    this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                    this.section2_minipicto1_label.string = this.institution2_title;
                    this.section2_minipicto1.getComponent(Sprite).color = this.institution2_color;
                    check++;
                } else {
                    this.section2_minipicto2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution2_picto;
                    this.section2_minipicto2_label.string = this.institution2_title;
                    this.section2_minipicto2.getComponent(Sprite).color = this.institution2_color;
                    check++;
                }
            }
            if (input.get(3) == true) {
                if (check < 1) {
                    this.section2_minipicto1.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                    this.section2_minipicto1_label.string = this.institution3_title;
                    this.section2_minipicto1.getComponent(Sprite).color = this.institution3_color;
                    check++;
                } else if (check < 2) {
                    this.section2_minipicto2.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                    this.section2_minipicto2_label.string = this.institution3_title;
                    this.section2_minipicto2.getComponent(Sprite).color = this.institution3_color;
                    check++;
                } else {
                    this.section2_minipicto3.getChildByName("Picto").getComponent(Sprite).spriteFrame = this.institution3_picto;
                    this.section2_minipicto3_label.string = this.institution3_title;
                    this.section2_minipicto3.getComponent(Sprite).color = this.institution3_color;
                }
            }
        }
    }

}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/en/scripting/life-cycle-callbacks.html
 */
