/*Sound manager
Author = DigS-Gov Projekt 
*/

var muted = false;

var environment_sounds = {
    doorbell: new Audio ('sounds/door-bell.wav'),
    dooropen: new Audio ('sounds/door-open.wav'),
    letteropen: new Audio ('sounds/letter-open.wav'),
    //backsoundScene1: new Audio ('sounds/backgroundsoundszene1.wav'),
    //birdSound: new Audio('sounds/stille_mit_Vogel.wav'),
    //scene2 sounds
    //backsoundScene2: new Audio('sounds/hospital_background.wav'),
    writingSound: new Audio('sounds/writing_sound.wav'),
    //scene3 sounds
    printerSound: new Audio ('sounds/printer.wav'),
    phoneSound: new Audio ('sounds/phone_dialing.wav'),
    //backsoundScene3: new Audio('sounds/background_office.wav'),
    //scene4 sounds
    emailSound: new Audio('sounds/email_notification.wav'),

    //pinboard sounds
    pinSound: new Audio('sounds/pinSound.wav'),
}

var dialogue_sounds = {
    alreadyDone_audio: 'sounds/dialogue/alreadyDone_audio.mp3',
    gameEndMessage1_2_audio: 'sounds/dialogue/gameEndMessage1_2_audio.mp3',
    gameEndMessage1_audio: 'sounds/dialogue/gameEndMessage1_audio.mp3',
    gameEndMessage5_audio: 'sounds/dialogue/gameEndMessage5_audio.mp3',
    handyPart2_audio: 'sounds/dialogue/handyPart2_audio.mp3',
    handyPart4_audio: 'sounds/dialogue/handyPart4_audio.mp3',
    handyPart6_audio: 'sounds/dialogue/handyPart6_audio.mp3',
    handyPart8_audio: 'sounds/dialogue/handyPart8_audio.mp3',
    narrator_erfolgreich_audio: 'sounds/dialogue/narrator_erfolgreich_audio.mp3',
    pinboard_Info_Authority1_audio: 'sounds/dialogue/pinboard_Info_Authority1_audio.mp3',
    pinboard_Info_Authority2_audio: 'sounds/dialogue/pinboard_Info_Authority2_audio.mp3',
    pinboard_Info_Bzfst1_audio: 'sounds/dialogue/pinboard_Info_Bzfst1_audio.mp3',
    pinboard_Info_Bzfst2_audio: 'sounds/dialogue/pinboard_Info_Bzfst2_audio.mp3',
    pinboard_Info_Destatis1_audio: 'sounds/dialogue/pinboard_Info_Destatis1_audio.mp3',
    pinboard_Info_Destatis2_audio: 'sounds/dialogue/pinboard_Info_Destatis2_audio.mp3',
    pinboard_Info_Family1_audio: 'sounds/dialogue/pinboard_Info_Family1_audio.mp3',
    pinboard_Info_Family2_audio: 'sounds/dialogue/pinboard_Info_Family2_audio.mp3',
    pinboard_Info_Hospital_audio: 'sounds/dialogue/pinboard_Info_Hospital_audio.mp3',
    pinboard_Info_LASD_audio: 'sounds/dialogue/pinboard_Info_LASD_audio.mp3',
    pinboard_Info_News_audio: 'sounds/dialogue/pinboard_Info_News_audio.mp3',
    pinboard_Info_Office1_audio: 'sounds/dialogue/pinboard_Info_Office1_audio.mp3',
    pinboard_Info_Office2_audio: 'sounds/dialogue/pinboard_Info_Office2_audio.mp3',
    pinboard_Info_Office3_audio: 'sounds/dialogue/pinboard_Info_Office3_audio.mp3',
    pinboard_Info_Office4_audio: 'sounds/dialogue/pinboard_Info_Office4_audio.mp3',
    pinboard_Info_Renten_audio: 'sounds/dialogue/pinboard_Info_Renten_audio.mp3',
    pinboard_Info_Standes_audio: 'sounds/dialogue/pinboard_Info_Standes_audio.mp3',
    pinboard_Info_TaxId_audio: 'sounds/dialogue/pinboard_Info_TaxId_audio.mp3',
    pinboard_Info_TaxId2_audio: 'sounds/dialogue/pinboard_Info_TaxId2_audio.mp3',
    pinboard_Info_TaxId3_audio: 'sounds/dialogue/pinboard_Info_TaxId3_audio.mp3',
    pinboard_Intro_Authority_audio: 'sounds/dialogue/pinboard_Intro_Authority_audio.mp3',
    pinboard_Intro_Hospital_audio: 'sounds/dialogue/pinboard_Intro_Hospital_audio.mp3',
    pinboard_Intro_Office_audio: 'sounds/dialogue/pinboard_Intro_Office_audio.mp3',
    pinboard1_Part1_audio: 'sounds/dialogue/pinboard1_Part1_audio.mp3',
    pinboard1_Part2_audio: 'sounds/dialogue/pinboard1_Part2_audio.mp3',
    pinboard1_Part3_audio: 'sounds/dialogue/pinboard1_Part3_audio.mp3',
    pinboard1_Part4_audio: 'sounds/dialogue/pinboard1_Part4_audio.mp3',
    pinboard1_Part5_audio: 'sounds/dialogue/pinboard1_Part5_audio.mp3',
    scene1_2Part1_audio: 'sounds/dialogue/scene1_2Part1_audio.mp3',
    scene1_2Part2_audio: 'sounds/dialogue/scene1_2Part2_audio.mp3',
    scene1Part1_audio: 'sounds/dialogue/scene1Part1_audio.mp3',
    scene1Part2_audio: 'sounds/dialogue/scene1Part2_audio.mp3',
    scene1Part3_audio: 'sounds/dialogue/scene1Part3_audio.mp3',
    scene1Part4_audio: 'sounds/dialogue/scene1Part4_audio.mp3',
    scene2Part1_audio: 'sounds/dialogue/scene2Part1_audio.mp3',
    scene2Part2_audio: 'sounds/dialogue/scene2Part2_audio.mp3',
    scene2Part3_audio: 'sounds/dialogue/scene2Part3_audio.mp3',
    scene2Part4_audio: 'sounds/dialogue/scene2Part4_audio.mp3',
    scene2Part5_audio: 'sounds/dialogue/scene2Part6_audio.mp3',
    scene3_Opt1_1_audio: 'sounds/dialogue/scene3_Opt1_1_audio.mp3',
    scene3_Opt1_2_audio: 'sounds/dialogue/scene3_Opt1_2_audio.mp3',
    scene3_Opt1_3_audio: 'sounds/dialogue/scene3_Opt1_3_audio.mp3',
    scene3_Opt1_4_audio: 'sounds/dialogue/scene3_Opt1_4_audio.mp3',
    scene3_Opt2_1_audio: 'sounds/dialogue/scene3_Opt2_1_audio.mp3',
    scene3_Opt2_2_audio: 'sounds/dialogue/scene3_Opt2_2_audio.mp3',
    scene3_Opt2_3_audio: 'sounds/dialogue/scene3_Opt2_3_audio.mp3',
    scene3_Opt2_4_audio: 'sounds/dialogue/scene3_Opt2_4_audio.mp3',
    scene3_Opt3_1_audio: 'sounds/dialogue/scene3_Opt3_1_audio.mp3',
    scene3_Opt3_2_audio: 'sounds/dialogue/scene3_Opt3_2_audio.mp3',
    scene3_Opt4_1_audio: 'sounds/dialogue/scene3_Opt4_1_audio.mp3',
    scene3_Opt4_2_audio: 'sounds/dialogue/scene3_Opt4_2_audio.mp3',
    scene3_Opt4_3_audio: 'sounds/dialogue/scene3_Opt4_3_audio.mp3',
    scene3_Opt4_4_audio: 'sounds/dialogue/scene3_Opt4_4_audio.mp3',
    scene3_Opt5_1_audio: 'sounds/dialogue/scene3_Opt5_1_audio.mp3',
    scene3_Opt6_1_audio: 'sounds/dialogue/scene3_Opt6_1_audio.mp3',
    scene3_Opt6_2_audio: 'sounds/dialogue/scene3_Opt6_2_audio.mp3',
    scene3_postit1_1_audio: 'sounds/dialogue/scene3_postit1_1_audio.mp3',
    scene3_postit1_2_audio: 'sounds/dialogue/scene3_postit1_2_audio.mp3',
    scene3_postit1_audio: 'sounds/dialogue/scene3_postit1_audio.mp3',
    scene3_postit3_audio: 'sounds/dialogue/scene3_postit3_audio.mp3',
    scene3Part_last_audio: 'sounds/dialogue/scene3Part_last_audio.mp3',
    scene3Part1_audio: 'sounds/dialogue/scene3Part1_audio.mp3',
    scene3Part2_1_audio: 'sounds/dialogue/scene3Part2_1_audio.mp3',
    scene3Part2_audio: 'sounds/dialogue/scene3Part2_audio.mp3',
    scene3Part3_audio: 'sounds/dialogue/scene3Part3_audio.mp3',
    scene3Part4_audio: 'sounds/dialogue/scene3Part4_audio.mp3',
    scene4_database_fail2_audio: 'sounds/dialogue/scene4_database_fail2_audio.mp3',
    scene4_database_fail3_audio: 'sounds/dialogue/scene4_database_fail3_audio.mp3',
    scene4_database_fail4_audio: 'sounds/dialogue/scene4_database_fail4_audio.mp3',
    scene4_database_fail5_audio: 'sounds/dialogue/scene4_database_fail5_audio.mp3',
    scene4_database_success_audio: 'sounds/dialogue/scene4_database_success_audio.mp3',
    scene4_email_fail2_audio: 'sounds/dialogue/scene4_email_fail2_audio.mp3',
    scene4_email_fail3_audio: 'sounds/dialogue/scene4_email_fail3_audio.mp3',
    scene4_email_fail4_audio: 'sounds/dialogue/scene4_email_fail4_audio.mp3',
    scene4_email_success_audio: 'sounds/dialogue/scene4_email_success_audio.mp3',
    scene4_newMail_audio: 'sounds/dialogue/scene4_newMail_audio.mp3',
    scene4_openedData_audio: 'sounds/dialogue/scene4_openedData_audio.mp3',
    scene4Part1_audio: 'sounds/dialogue/scene4Part1_audio.mp3',
    scene4Part2_audio: 'sounds/dialogue/scene4Part2_audio.mp3',
    scene5Part1_audio: 'sounds/dialogue/scene5Part1_audio.mp3',
    scene5Part2_audio: 'sounds/dialogue/scene5Part2_audio.mp3',
    thatwasWrong_audio: 'sounds/dialogue/thatwasWrong_audio.mp3',
    thatwasWrong2_audio: 'sounds/dialogue/thatwasWrong2_audio.mp3',
    tutorialPart1_audio: 'sounds/dialogue/tutorialPart1_audio.mp3',
    tutorialPart2_audio: 'sounds/dialogue/tutorialPart2_audio.mp3',
    tutorialPart3_audio: 'sounds/dialogue/tutorialPart3_audio.mp3',
    tutorialPart4_audio: 'sounds/dialogue/tutorialPart4_audio.mp3',
    welcomePart1_2_audio: 'sounds/dialogue/welcomePart1_2_audio.mp3',
}

var playing_audio;


function playDoorBell(){
    environment_sounds.doorbell.volume = 0.05;
    environment_sounds.doorbell.muted = muted;
    environment_sounds.doorbell.play();
}

function playDoorOpen(){
    environment_sounds.dooropen.muted = muted;
    environment_sounds.dooropen.play();
    // window.setTimeout(playBirdSound, 2720);
}

function playLetterOpen(){
    environment_sounds.letteropen.muted = muted;
    environment_sounds.letteropen.play();
    //window.setTimeout(playBacksound1, 3500);
}

/*
function playBacksound1(){
    sounds.backsoundScene1.muted = muted;
    sounds.backsoundScene1.volume = 0.06;
    sounds.backsoundScene1.play();
}
function playBirdSound(){
    sounds.birdSound.muted = muted;
    sounds.birdSound.volume = 0.1;
    sounds.birdSound.play();
    sounds.birdSound.loop = true;
}
function stopBirdSound(){
    sounds.birdSound.muted = muted;
    sounds.birdSound.loop = false;
    sounds.birdSound.pause();
    //sounds.backsoundScene1.pause();
}
function playBacksound2(){
    sounds.backsoundScene2.muted = muted;
    sounds.backsoundScene2.volume = 0.06;
    sounds.backsoundScene2.play();
    sounds.backsoundScene2.loop = true;
}
function stopBacksound2(){
    sounds.backsoundScene2.muted = muted;
    sounds.backsoundScene2.loop = false;
    sounds.backsoundScene2.pause();
}
*/

function playWritingSound(){
    environment_sounds.writingSound.muted = muted;
    environment_sounds.writingSound.volume = 0.2;
    environment_sounds.writingSound.play();
}

function playPrinterSound(){
    environment_sounds.printerSound.muted = muted;
    environment_sounds.printerSound.volume = 0.08;
    environment_sounds.printerSound.play();
}

function playPhoneSound(){
    environment_sounds.phoneSound.muted = muted;
    environment_sounds.phoneSound.volume = 0.08;
    environment_sounds.phoneSound.play();
}

/*
function playBacksound3(){
    sounds.backsoundScene3.muted = muted;
    sounds.backsoundScene3.volume = 0.06;
    sounds.backsoundScene3.play();
    sounds.backsoundScene3.loop = true;
}
function stopBacksound3(){
    sounds.backsoundScene3.muted = muted;
    sounds.backsoundScene3.loop = false;
    sounds.backsoundScene3.pause();
}
*/

function playEmailSound(){
    environment_sounds.emailSound.volume = 0.08;
    environment_sounds.emailSound.muted = muted;
    environment_sounds.emailSound.play();
}

function playPinSound(){
    environment_sounds.pinSound.volume = 0.3;
    environment_sounds.pinSound.muted = muted;
    environment_sounds.pinSound.play();
}


function playSound(sound, volume_value = 1){
    window.setTimeout(function() {stop_running_audio();
    startSound(sound, volume_value)}, DIALOG_OFFSET);
}

function startSound(sound, volume_value){
    var sound_audio = generate_audio_mp3_path(sound)
    playing_audio = sound_audio;
    sound_audio.volume = volume_value;
    sound_audio.muted = muted;
    sound_audio.play();
}

function playMutipleSound(sound1, sound2, volume_value = 1){
    var sound_audio = new Audio(sound1);
    playing_audio = sound_audio;
    window.setTimeout(function() {stop_running_audio();
        sound_audio.volume = volume_value;
        sound_audio.muted = muted;
        sound_audio.play();
       }, DIALOG_OFFSET);
    
    sound_audio.addEventListener('ended', function() {
        playSound(sound2, volume_value);
      });
   
}
function stop_running_audio() {
    if(playing_audio != undefined){
        if(!playing_audio.paused && playing_audio.currentTime > 0){
            playing_audio.pause();
            playing_audio.currentTime = 0;
        }
    }
}
function toggle_mute_running_audio(){
    if(playing_audio != undefined){
        playing_audio.muted = muted;
    }
}
function generate_audio_mp3_path(audio){
    return new Audio (audio);
}


