/* Pop-up logic
Author = DigS-Gov Projekt 
*/

//function to create popup
class PopUp {
    static currentPopUp;

    static init(message, ...options) {
        Dialogue.remove();
        PopUp.currentPopUp = document.createElement("div");
        PopUp.currentPopUp.id = "popUp";

        const popupMessage = document.createElement("div");
        popupMessage.innerHTML = message;
        PopUp.currentPopUp.appendChild(popupMessage);

        const optionsRow = document.createElement("div");
        optionsRow.classList.add('popUpOptions');
        optionsRow.setAttribute('data-options', options.length);

        options.forEach((option) => {
            const optionButton = document.createElement("button");
            optionButton.innerText = option.title;

            optionButton.onclick = option.action;

            optionsRow.appendChild(optionButton);
        });

        PopUp.currentPopUp.appendChild(optionsRow);
        document.getElementById("gameSpace").appendChild(PopUp.currentPopUp);
        document.getElementById("popUp").style.fontSize = gameSpace.getBoundingClientRect().height / 25 + "px";
    }

    static remove() {
        PopUp.currentPopUp.remove();
    }
}

//function to create popup after completing the game
function gameEnd() {
    let percentage = (parseInt((destatis + news + standes + renten + lasd + family) / 6 * 100)).toFixed(0);
    let messageEnd;
    let completion;
    call == 0 ? completion = gameEndMessage4 : completion = gameEndMessage2;
    percentage == 100 ? messageEnd = gameEndMessage3 : messageEnd = completion;
    removeAllHitboxes();

    if (finalPopupAppeared == false) {
        PopUp.init(gameEndMessage1 + percentage + messageEnd + gameEndMessage5, {
            title: "Auf Pinnwand bleiben", action: () => {
                PopUp.remove();
                drawHitboxesPinboard_5();
                createContinueButton();
            }
        },
            // {
            //     title: "Credits ansehen", action: () => {
            //         PopUp.remove();
            //         window.location.href = "impressum/impressum.html";
            //     }
            // }
            //, {
            //     title: "Spiel bewerten", action: () => {
            //         window.open("https://survey.imis.uni-luebeck.de/index.php/247384", "_blank").focus();
            //     }
            // }
        );
        playMutipleSound(dialogue_sounds.gameEndMessage1_audio, dialogue_sounds.gameEndMessage5_audio);
        finalPopupAppeared = true;
    } else {
        drawHitboxesPinboard_5();
        createContinueButton();
    }
}

// function to create popups to go back to specific scenes during the game
function loadPopupScene(sceneToLoad) {
    // console.log(standes,destatis,news, renten, lasd, family);
    var popupText, goToSceneText, sceneloadFunction;
    const stayOnPinboardText = "Auf Pinnwand bleiben";

    functions = [initScene2, initScene3, initScene4, initScene5];
    switch (sceneToLoad) {
        case 1:
            popupText = popup_pin1;
            goToSceneText = "An Krankenhaus erinnern";
            sceneloadFunction = functions[0];
            break;
        case 2:
            popupText = popup_pin2;
            goToSceneText = "Daten folgen";
            sceneloadFunction = functions[1];
            break;
        case 3:
            popupText = popup_pin3;
            goToSceneText = "Daten folgen";
            sceneloadFunction = functions[2];
            break;
        case 4:
            popupText = popup_pin4;
            goToSceneText = "Steuer ID erhalten";
            sceneloadFunction = functions[3];
            break;
    }
    removeAllHitboxes();

    // UpdatePinboard in case of going back to pinboard during normal gameplay --> required primarily for counting up pinboardState, so going back to the right pinboard is made sure
    switch (pinboardState) {
        case 2:
            pinboardState = 3;
            break;
        case 4:
            pinboardState = 5;
            break;
        case 6:
            pinboardState = 7;
            break;
        case 8:
            pinboardState = 9;
            break;
    }

    // console.log(pinboardState);

    PopUp.init(popupText,
        {
            title: stayOnPinboardText, action: () => {
                PopUp.remove();

                // switch (pinboardState) {
                //     case 3:
                //         drawHitboxesPinboard_1_2();
                //         break;
                //     case 5:
                //         drawHitboxesPinboard_2();
                //         break;
                //     case 7:
                //         break;
                //     case 10:
                //         break;
                // }

                // console.log("PP: " + pinboardProgress);
                // console.log("PS: " + pinboardState);

                switch (pinboardProgress) {
                    case 2:
                        drawHitboxesPinboard_1_2();
                        break;
                    // After hospital has been played til the end (office pin visible, yet not connected)
                    case 3:
                        drawHitboxesPinboard_2();
                        break;
                    // After office has been visited (office pin connected)
                    case 4:
                        drawHitboxesPinboard_2();
                        break;
                    // After office has been played til the end (authority pin visible, yet not connected)
                    case 5:
                        drawHitboxesPinboard_3();
                        break;
                    // After authority has been visited (authority pin connected)  
                    case 6:
                        drawHitboxesPinboard_3();
                        break;
                    // After authority has been played til the end (Bzfst pin visible, yet not connected)
                    case 7:
                        drawHitboxesPinboard_4();
                        break;
                    // After Bzfst has been clicked (Bzfst pin connected)
                    case 8:
                        drawHitboxesPinboard_4_2();
                        break;
                    case 9:
                        drawHitboxesPinboard_4_2();
                        break;
                    case 10:
                        drawHitboxesPinboard_5();
                        break;
                }
            }
        },
        {
            title: goToSceneText, action: () => {

                // console.log("PP: " + pinboardProgress);
                // console.log("PS: " + pinboardState);

                window.setTimeout(hideImage.bind(null, "pinHospital"), 1100);
                window.setTimeout(hideImage.bind(null, "pinHospital_red"), 1100);
                window.setTimeout(hideImage.bind(null, "pinAuthority_red"), 1100);
                window.setTimeout(hideImage.bind(null, "pinOffice_red"), 1100);
                window.setTimeout(hideImage.bind(null, "pinBzfst_red"), 1100);
                window.setTimeout(hideImage.bind(null, "pinBzfst_grey"), 1100);
                window.setTimeout(hideImage.bind(null, "arrow_red"), 1100);
                window.setTimeout(hideImage.bind(null, "arrow_grey"), 1100);
                window.setTimeout(hideImage.bind(null, "pinFamily_grey"), 1100);
                if (call == 0) window.setTimeout(hideImage.bind(null, "pinHideNews"), 1100);
                if (news == 1) window.setTimeout(hideImage.bind(null, "pinNews"), 1100);
                if (destatis == 1) window.setTimeout(hideImage.bind(null, "pinDestatis"), 1100);
                if (standes == 1) window.setTimeout(hideImage.bind(null, "pinStandes"), 1100);
                if (lasd == 1) window.setTimeout(hideImage.bind(null, "pinLASD"), 1100);
                if (renten == 1) window.setTimeout(hideImage.bind(null, "pinRenten"), 1100);
                fadeToBlack();

                // load scene
                window.setTimeout(sceneloadFunction, 1000);
                PopUp.remove();
            }
        });
}

// function to create popups in scene 5 to go back to specific scenes
function loadPopupScene5(sceneToLoad) {
    // console.log(standes, destatis, news, renten, lasd, family);
    var popupText, goToSceneText, sceneloadFunction;
    const stayOnPinboardText = "Auf Pinnwand bleiben";

    functions = [initScene2, initScene3, initScene4, initScene5];
    switch (sceneToLoad) {
        case 1:
            popupText = popup_pin1;
            goToSceneText = "An Krankenhaus erinnern";
            sceneloadFunction = functions[0];
            break;
        case 2:
            popupText = popup_pin2;
            goToSceneText = "Daten folgen";
            sceneloadFunction = functions[1];
            break;
        case 3:
            popupText = popup_pin3;
            goToSceneText = "Daten folgen";
            sceneloadFunction = functions[2];
            break;
        case 4:
            popupText = popup_pin4;
            goToSceneText = "Steuer ID erhalten";
            sceneloadFunction = functions[3];
            break;
    }

    removeContinueButton();
    removeAllHitboxes();

    PopUp.init(popupText,
        {
            title: stayOnPinboardText, action: () => {
                PopUp.remove();
                createContinueButton();
                drawHitboxesPinboard_5();
            }
        },
        {
            title: goToSceneText, action: () => {
                window.setTimeout(hideImage.bind(null, "pinBzfst_grey"), 1100);
                window.setTimeout(hideImage.bind(null, "arrow_grey"), 1100);
                window.setTimeout(hideImage.bind(null, "pinFamily_grey"), 1100);
                if (call == 0) window.setTimeout(hideImage.bind(null, "pinHideNews"), 1100);
                if (news == 1) window.setTimeout(hideImage.bind(null, "pinNews"), 1100);
                if (destatis == 1) window.setTimeout(hideImage.bind(null, "pinDestatis"), 1100);
                if (standes == 1) window.setTimeout(hideImage.bind(null, "pinStandes"), 1100);
                if (lasd == 1) window.setTimeout(hideImage.bind(null, "pinLASD"), 1100);
                if (renten == 1) window.setTimeout(hideImage.bind(null, "pinRenten"), 1100);
                fadeToBlack();

                // load scene
                window.setTimeout(sceneloadFunction, 1000);
                PopUp.remove();
            }
        });

}