/* Author = DigS-Gov Projekt
constructor for the images*/
class Imager {
    constructor(id, scene_name, filename, highlight) {
        this.id = id;
        this.scene_name = scene_name;
        this.filename = filename;
        // is image a higlight image? true/false
        this.highlight = highlight;

        // html logic
        this.image = document.createElement('img');
        this.image.src = "images/" + scene_name + "/" + filename;
        this.image.id = id;
        this.image.className = "newImage";
    }

    show() {
        document.getElementById(activeLayer).appendChild(this.image);
    }

    hide() {
        if (document.getElementById(this.id) != null) {
            document.getElementById(this.id).remove();
        }
    }
}

var assets = new Array();
var pinboardState = 0;
var pinboardProgress = 2;
var images = {
    //pinboard assets
    pinHospital: new Imager('pinHospital', 'pinboard', 'pinnwand_krankenhaus.png', false),
    pinHospital_grey: new Imager('pinHospital_1', 'pinboard', 'faden1_grau.png', false),
    pinHospital_red: new Imager('pinHospital_1', 'pinboard', 'faden1_rot.png', false),
    pinOffice_grey: new Imager('pinOffice_1', 'pinboard', 'faden2_grau.png', false),
    pinOffice_red: new Imager('pinOffice_1', 'pinboard', 'faden2_rot.png', false),
    pinAuthority_grey: new Imager('pinAuthority_1', 'pinboard', 'faden3_grau.png', false),
    pinAuthority_red: new Imager('pinAuthority_1', 'pinboard', 'faden3_rot.png', false),
    pinDestatis: new Imager('pinDestatis', 'pinboard', 'Destatis100.png', false),
    pinStandes: new Imager('pinStandes', 'pinboard', 'Standes_100.png', false),
    pinNews: new Imager('pinNews', 'pinboard', 'News_100.png', false),
    pinRenten: new Imager('pinRenten', 'pinboard', 'Pinnwand_RentenVS_100.png', false),
    pinLASD: new Imager('pinLASD', 'pinboard', 'Pinnwand_LASD_100.png', false),
    pinBzfst_grey: new Imager('pinBzfst_1', 'pinboard', 'faden4_grau.png', false),
    pinBzfst_red: new Imager('pinBzfst_1', 'pinboard', 'faden4_rot.png', false),
    arrow_grey: new Imager('arrow', 'pinboard', 'Pinnwand_pfeil.png', false),
    arrow_red: new Imager('arrow', 'pinboard', 'Pinnwand_pfeil_100.png', false),
    pinFamily_grey: new Imager('pinFamily', 'pinboard', 'Pinnwand_Familienkasse.png', false),
    pinFamily: new Imager('pinFamily', 'pinboard', 'Pinnwand_familienkasse_100.png', false),
    pinHideNews: new Imager('hideNews', 'pinboard', 'Pinnwand_zeitung_hide.png', false),

    //scene0 assets
    cupcake: new Imager('cupcake', 'scene0', 'cupcake_highlight.png', true),

    //scene1 assets
    taxSheet: new Imager('taxSheet', 'scene1', 'szene1_zettel.png', false),
    doorHighlight: new Imager('doorHighlight', 'scene1', 'szene1_turhighlight.png', true),
    letterHighlight: new Imager('letterHighlight', 'scene1', 'szene1_brief_highlight.png', true),
    letter: new Imager('letter', 'scene1', 'szene1_brief.png', false),
    parents: new Imager('parents', 'scene1', 'szene1_eltern.png', false),
    narrator: new Imager('narrator', 'scene1', 'szene1_erzahler.png', false),

    //scene2 assets
    paper_highlight: new Imager('paper', 'scene2', 'Krankenhaus_klemmbrett_highlight.png', true),
    paper_highlight_big: new Imager('paper', 'scene2', 'klemmbrett_highlight.png', true),
    nurse: new Imager('nurse', 'scene2', 'nurse.png', false),
    paper_text: new Imager('text', 'scene2', 'klemmbrett_text.png', false),

    //scene3 assets
    letter2_highlight: new Imager('letter2Highlight', 'scene3', 'Standesamt_brief_highlight.png', true),
    pc_highlight: new Imager('pcHighlight', 'scene3', 'Standesamt_computer_highlight.png', true),
    printer_highlight: new Imager('printerHighlight', 'scene3', 'Standesamt_drucker_highlight.png', true),
    printer_page: new Imager('printerPage', 'scene3', 'Standesamt_drucker_urkunde.png', false),
    page_highlight: new Imager('pageHighlight', 'scene3', 'Standesamt_geburtsurkunde_highlight.png', true),
    birthpaper: new Imager('birthpaper', 'scene3', 'Standesamt_geburtsurkunde.jpg', false),
    handy_highlight: new Imager('handyHighlight', 'scene3', 'Standesamt_handy_highlight.png', true),
    buro_highlight: new Imager('buroHighlight', 'scene3', 'Standesamt_buro_highlight.png', true),
    postit_highlight: new Imager('postitHighlight', 'scene3', 'Standesamt_schreibtisch_postit_highlight.png', true),
    window2: new Imager('secondwindow', 'scene3', 'Fenster2.png', false),
    window2_highlight: new Imager('secondwindowHighlight', 'scene3', 'Fenster2_highlight.png', true),
    window2_data: new Imager('secondwindowData', 'scene3', 'Daten.png', false),
    window2_button: new Imager('secondwindowButton', 'scene3', 'Abschicken_highlight.png', true),
    window3_button: new Imager('windowPrintButton', 'scene3', 'drucken_highlight.png', true),
    handy_face: new Imager('handyFace', 'scene3', 'Standesamt_telefon.png', false),
    forward_highlight: new Imager('forwardHighlight', 'scene3', 'weiterleiten_highlight.png', true),
    forward_crosses: new Imager('forwardCrosses', 'scene3', 'weiterleiten_kreuze.png', false),

    //scene4 assets
    buro2_highlight: new Imager('buro2Highlight', 'scene4', 'Meldeamt_highlight.png', true),
    pc2_highlight: new Imager('pc2Highlight', 'scene4', 'Meldeamt_computer_highlight.png', true),
    email_highlight: new Imager('desktopHighlight', 'scene4', 'Meldeamt_desktop_highlight2.png', true),
    email_highlight2: new Imager('desktopHighlight2', 'scene4', 'Meldeamt_desktop_highlight3.png', true),
    database_highlight: new Imager('databaseHighlight', 'scene4', 'Meldeamt_desktop_highlight1.png', true),
    message: new Imager('message', 'scene4', 'Meldeamt_mitteilung.png', false),
    email: new Imager('email', 'scene4', 'Meldeamt_email.png', false),
    email_new: new Imager('emailNew', 'scene4', 'Meldeamt_email_neus.png', false),
    email_data: new Imager('emailData', 'scene4', 'Meldeamt_dokumente_highlight.png', true),
    person_data: new Imager('personData', 'scene4', 'Meldeamt_Personendaten.png', false),
    databaseWindow: new Imager('database', 'scene4', 'Meldeamt_Melderegister.png', false),
    sophia_txt: new Imager('sophia_txt', 'scene4', 'Meldeamt_sophia.png', false),
    nadine_txt: new Imager('nadine_txt', 'scene4', 'Meldeamt_nadine.png', false),
    clemens_txt: new Imager('clemens_txt', 'scene4', 'Meldeamt_clemens.png', false),
    sophia_txt_right: new Imager('sophia_txt_right', 'scene4', 'Meldeamt_sophia_richtig.png', false),
    nadine_txt_right: new Imager('nadine_txt_right', 'scene4', 'Meldeamt_nadine_richtig.png', false),
    clemens_txt_right: new Imager('clemens_txt_right', 'scene4', 'Meldeamt_clemens_richtig.png', false),
    confirmation: new Imager('confirmation', 'scene4', 'Meldeamt_bestatigung.png', false),
    confirmation_highlight: new Imager('confirmationHighlight', 'scene4', 'Meldeamt_bestatigen_highlight.png', true),
    addPerson_highlight: new Imager('addPersonHighlight', 'scene4', 'Meldeamt_person_anlegen_highlight.png', true),
    reference_highlight: new Imager('referenceHighlight', 'scene4', 'Betreff_highlight.png', true),
    reference: new Imager('reference', 'scene4', 'Meldeamt_Betreff_neu.png', false),
    reference_txt: new Imager('referenceTXT', 'scene4', 'Meldeamt_Betreff_txt.png', false),
    to: new Imager('to', 'scene4', 'Meldeamt_an.png', false),
    cc: new Imager('cc', 'scene4', 'Meldeamt_cc.png', false),
    to_highlight: new Imager('tohighlight', 'scene4', 'an_highlight.png', true),
    cc_highlight: new Imager('cchighlight', 'scene4', 'cc_highlight.png', true),
    text: new Imager('text', 'scene4', 'email_text.png', false),
    text_highlight: new Imager('texthighlight', 'scene4', 'Text_highlight.png', true),
    email_add: new Imager('emailAdd', 'scene4', 'Meldeamt_email_add.png', false),
    email_send: new Imager('emailSend', 'scene4', 'Meldeamt_Abschicken.png', false),
    send_highlight: new Imager('sendhigh', 'scene4', 'Abschicken_highlight.png', true),
    file: new Imager('file', 'scene4', 'Meldeamt_datei.png', false),
    file_highlight: new Imager('fileHighlight', 'scene4', 'Anhang_highlight.png', true),


};

//array used to store background images

assets[0] = 'images/scene1/szene1_zimmer.jpg';
assets[1] = 'images/scene0/Wohnzimmer.png';
assets[2] = 'images/scene1/szene1_hintergrund2.jpg';
assets[3] = 'images/independent/vollbild.png';
assets[4] = 'images/independent/novollbild.png';
assets[5] = 'images/scene2/Krankenhaus.png';
assets[6] = 'images/scene2/klemmbrett.jpg';
assets[7] = 'images/scene3/Standesamt_buro.jpg';
assets[8] = 'images/scene3/Standesamt_pc.jpg';
assets[9] = 'images/scene3/Standesamt_Schreibtisch.jpg';
assets[10] = 'images/pinboard/szene1_pinnwand.png';
assets[11] = 'images/pinboard/szene2_pinnwand.jpg';
assets[12] = 'images/pinboard/szene3_pinnwand.png';
assets[12] = 'images/pinboard/szene4_pinnwand.jpg';
assets[13] = 'images/scene4/Meldeamt_buro.jpg';
assets[14] = 'images/scene4/Meldeamt_schreibtisch.jpg';
assets[15] = 'images/scene4/Meldeamt_desktop.jpg';
assets[16] = 'images/independent/mute.png';
assets[17] = 'images/independent/unmute.png';
assets[18] = 'images/szene5.jpg';


var pictures = new Array();

//function to load images into array
function loadBackgroundImages() {

    for (i = 0; i < assets.length; i++) {
        pictures[i] = new Image();
        pictures[i].src = assets[i];
    }
}

//function to show images
function showImage(name) {
    images[name].show();

    // narrator is supposed to take place in front of other images as highlights
    if (name == "narrator") {
        document.getElementById("gameSpace").appendChild(images[name].image);
    }
}

//function to hide images
function hideImage(name) {
    images[name].hide();
}



//#region timer-logic for hint mechanism

var timer = 0;
var inactive_time = 0;
// treshold before hint is shown in s
const hint_treshold = 5;

// check every second for changes in inactive_time
window.setInterval(handleInactiveTime, 1000);

function startInactiveTime() {
    timer = setInterval(countInactiveTime, 1000);
}
function countInactiveTime() {
    inactive_time++;
}
function stopInactiveTime() {
    inactive_time = 0;
}
function resetInactiveTime() {
    clearInterval(timer);
    inactive_time = 0;
}
function handleInactiveTime() {
    // console.log(inactive_time);
    if (inactive_time > hint_treshold) {
        blinkImage();
    }
}

//#endregion


//#region functions for hint mechanism

// interactive elements starts blinking, serving as a hint for users
function blinkImage() {
    // accessing 'mapShapes' out of 'hitboxes.js', holds current scenes' hitboxes
    mapShapes.forEach(element => {
        if (element.id != undefined || element.id != null) {
            if (document.getElementById(images[element.id].id) == null) {
                images[element.id].show();
                document.getElementById(images[element.id].id).classList.add("blink");
            }
        }
    });
}

function stopBlinking() {
    mapShapes.forEach(element => {
        if (element.id != undefined || element.id != null) {
            try {
                document.getElementById(images[element.id].id).classList.remove("blink");
                images[element.id].hide();
            } catch (e) {
            }
        }
    });
}

//#endregion



//images needed in scene 1_2
//function to show content of letter
function openLetter() {
    document.getElementById("letter").src = 'images/scene1/szene1_zettel.png';
    window.setTimeout(scene1_2_Dialogue_1, 500);
}

//function to update pinboard on click
function updatePinboard() {
    // console.log("updated pinboard. New State: " + (pinboardState + 1));
    switch (pinboardState++) {
        case 0:
            showImage("pinHospital");
            return;
        case 1:
            if (!pin1_sound_played) {
                playPinSound();
                pin1_sound_played = true;
            }
            showImage("pinHospital_red");
            return;
        case 2:
            showImage("pinHospital");
            showImage("pinHospital_red");
            pinboardProgress = 3;
            // removeAllHitboxes();

            // PopUp.init(popup_pin1, {
            //     title: "Auf Pinnwand bleiben", action: () => {
            //         pinboardState--;
            //         createContinueButton();
            //         PopUp.remove();
            //         drawHitboxesPinboard_1_2();
            //     }
            // }, {
            //     title: "An Krankenhaus erinnern", action: () => {
            //         window.setTimeout(hideImage.bind(null, "pinHospital"), 1100);
            //         window.setTimeout(hideImage.bind(null, "pinHospital_red"), 1100);
            //         removeAllHitboxes();
            //         fadeToBlack();
            //         window.setTimeout(initScene2, 1000);
            //         PopUp.remove();
            //     }
            // });

            return;
        case 3:
            if (!pin2_sound_played) {
                playPinSound();
                pin2_sound_played = true;
            }
            showImage("pinOffice_red");
            pinboardProgress = 4;
            // document.getElementById("pinOffice_1").src = "images/pinboard/faden2_rot.png";
            return;
        case 4:
            showImage("pinOffice_red");
            pinboardProgress = 5;
            // console.log("Jetzt müsste alles richtig sein. PP: " + pinboardProgress + ", PS: " + pinboardState);
            // removeAllHitboxes();
            // PopUp.init(popup_pin2, {
            //     title: "Auf Pinnwand bleiben", action: () => {
            //         pinboardState--;
            //         createContinueButton();
            //         PopUp.remove();
            //         drawHitboxesPinboard_2();
            //     }
            // }, {
            //     title: "Daten folgen", action: () => {
            //         window.setTimeout(hideImage.bind(null, "pinOffice_grey"), 1100);
            //         removeAllHitboxes();
            //         fadeToBlack();
            //         window.setTimeout(initScene3, 1000);
            //         PopUp.remove();
            //     }
            // });
            return;
        case 5:
            if (!pin3_sound_played) {
                playPinSound();
                pin3_sound_played = true;
            }
            showImage("pinAuthority_red");
            // document.getElementById("pinAuthority_1").src = "images/pinboard/faden3_rot.png";
            pinboardProgress = 6;
            return;
        case 6:
            showImage("pinAuthority_red");
            pinboardProgress = 7;
            // removeAllHitboxes();
            // PopUp.init(popup_pin3, {
            //     title: "Auf Pinnwand bleiben", action: () => {
            //         pinboardState--;
            //         createContinueButton();
            //         PopUp.remove();
            //         drawHitboxesPinboard_3();
            //     }
            // }, {
            //     title: "Daten folgen", action: () => {
            //         window.setTimeout(hideImage.bind(null, "pinAuthority_grey"), 1100);
            //         if (call == 0) window.setTimeout(hideImage.bind(null, "pinHideNews"), 1100);
            //         if (news == 1) window.setTimeout(hideImage.bind(null, "pinNews"), 1100);
            //         if (destatis == 1) window.setTimeout(hideImage.bind(null, "pinDestatis"), 1100);
            //         if (standes == 1) window.setTimeout(hideImage.bind(null, "pinStandes"), 1100);
            //         removeAllHitboxes();
            //         fadeToBlack();
            //         window.setTimeout(initScene4, 1000);
            //         PopUp.remove();
            //     }
            // });
            return;
        case 7:
            if (!pin4_sound_played) {
                playPinSound();
                pin4_sound_played = true;
            }
            showImage("pinBzfst_red");
            // document.getElementById("pinBzfst_1").src = "images/pinboard/faden4_rot.png";
            showImage("pinFamily_grey");
            showImage("arrow_grey");
            pinboardProgress = 8;
            return;
        case 8:
            showImage("pinBzfst_red");
            pinboardProgress = 9;
            return;
        case 9:
            pinboardProgress = 10;
            // removeAllHitboxes();
            // PopUp.init(popup_pin4, {
            //     title: "Auf Pinnwand bleiben", action: () => {
            //         pinboardState--;
            //         createContinueButton();
            //         PopUp.remove();
            //         drawHitboxesPinboard_4_2();
            //     }
            // }, {
            //     title: "Steuer ID erhalten", action: () => {
            //         window.setTimeout(hideImage.bind(null, "pinBzfst_grey"), 1100);
            //         window.setTimeout(hideImage.bind(null, "arrow_grey"), 1100);
            //         window.setTimeout(hideImage.bind(null, "pinFamily_grey"), 1100);
            //         if (call == 0) window.setTimeout(hideImage.bind(null, "pinHideNews"), 1100);
            //         if (news == 1) window.setTimeout(hideImage.bind(null, "pinNews"), 1100);
            //         if (destatis == 1) window.setTimeout(hideImage.bind(null, "pinDestatis"), 1100);
            //         if (standes == 1) window.setTimeout(hideImage.bind(null, "pinStandes"), 1100);
            //         if (lasd == 1) window.setTimeout(hideImage.bind(null, "pinLASD"), 1100);
            //         if (renten == 1) window.setTimeout(hideImage.bind(null, "pinRenten"), 1100);
            //         fadeToWhite();
            //         window.setTimeout(initScene5, 1000);
            //         PopUp.remove();
            //     }
            // });
            return;
        default:
            gameEnd();
            return;
    }

}