/* Author = DigS-Gov Projekt
Size of the window elements
*/
var ratio = false;
var inFull = true;

//resize maps when resizing the window
window.addEventListener('resize', () => {
  checkAspectRatio(),
  setMapShapes(),
  setFontSize()
});

//function to set font size
function setFontSize() {
  if (document.getElementById("dialogue")) {
    document.getElementById("dialogue").style.fontSize = gameSpace.getBoundingClientRect().height / 25 + "px";
    document.getElementById("dots").style.fontSize = gameSpace.getBoundingClientRect().height / 10 + "px";
  }
  if (document.getElementById("popUp")) {
    document.getElementById("popUp").style.fontSize = gameSpace.getBoundingClientRect().height / 25 + "px";
  }
  if (document.getElementById("continueButton")) {
    document.getElementById("continueButton").style.fontSize = gameSpace.getBoundingClientRect().height / 15 + "px";
  }
  if (document.getElementById("screenMessageButton")) {
    document.getElementById("screenMessageButton").style.fontSize = gameSpace.getBoundingClientRect().height / 15 + "px";
  }
}

//check where borders are needed
function checkAspectRatio() {
    if(window.innerWidth/window.innerHeight <= 1.78) {
      document.getElementById("gameContainer").classList.toggle("vertical", true);
    }
    else {
      document.getElementById("gameContainer").classList.toggle("vertical", false);
    }
}

//change inFull variable and fullscreenButton
function toggleFull() {
  if (!inFull) {
    inFull = true;
    document.getElementById("fullscreenButton").classList.toggle("notFull", false);
  }

  else {
    inFull = false;
    document.getElementById("fullscreenButton").classList.toggle("notFull", true);
  }
}