/* Author = DigS-Gov Projekt
Initialziation of the game 
*/

var session_id;

function init() {

    document.getElementById("start-game-info").classList.add("fadeOutText");
    document.getElementById("playButton").remove();

    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    session_id = urlParams.get("session");

    // FIRST 
    logData("Tutorial");

    loadBackgroundImages();

    initPinboardButton();
    // hide pinboard button in beginning 
    document.getElementById("pinboardButton").style.visibility = "hidden";

    // fullscreen button
    initFullscreen();

    initSound();

    setFontSize();

    fadeToBlack();

    window.setTimeout(initTutorial, 1000);
}

function titleScreen() {
    play = document.createElement("div");
    play.id = "playButton";
    play.onclick = function () {
        init();
    }
    document.getElementById("gameSpace").appendChild(play);
}

// function for logging data across game sections
function logData(section) {
    var myHeaders = new Headers();

    myHeaders.append("Content-Type",
        "application/x-www-form-urlencoded");

    var urlencoded = new URLSearchParams();

    urlencoded.append("session",
        session_id);

    urlencoded.append("section",
        section);

    urlencoded.append("prototype",
        "SpielGeburt");

    urlencoded.append("info",
        getGameProgress());

    urlencoded.append("debug",
        "");

    var requestOptions = {
        method: 'POST', headers: myHeaders, body: urlencoded, redirect: 'follow'
    };

    fetch("https://link.jil.sh/eval/evaluate.php",
        requestOptions).then(response => response.text()).then(result => console.log(result)).catch(error => console.log('error', error));

}

function getGameProgress() {
    return parseInt((destatis + news + standes + renten + lasd + family) / 6 * 100).toFixed(0) + "%";
}

