/* Author = DigS-Gov Projekt
hitboxes of the gameobjects
*/

var mapShapes;
var destatis = 0;
var news = 0;
var standes = 0;
var printer = 0;
var computer = 0;
var letter = 0;
var clickedPostit = 0;
var call = 0;
var certificate = 0;
var renten = 0;
var lasd = 0;
var family = 0;

var pin1_sound_played = false;
var pin2_sound_played = false;
var pin3_sound_played = false;
var pin4_sound_played = false;

//function to draw image maps
function setMapShapes() {
  const map = document.getElementById("map");
  const gameSpace = document.getElementById("gameSpace");

  let resultingMapShapes = [];

  if (mapShapes && mapShapes.length) {
    resultingMapShapes = mapShapes.map(shape => {
      const resultingCoords = [];

      for (let i = 0; i < shape.coords.length; i++) {
        if (i % 2 === 0)
          resultingCoords.push(shape.coords[i] * gameSpace.getBoundingClientRect().width);
        else
          resultingCoords.push(shape.coords[i] * gameSpace.getBoundingClientRect().height);
      }

      const resultingShape = JSON.parse(JSON.stringify(shape));
      resultingShape.coords = resultingCoords;

      return resultingShape;
    });

    let resultingMapContent = '';

    resultingMapShapes.forEach(shape => {
      const coords = shape.coords.join(',');
      const hover = shape.hover ? ` onmouseenter="${shape.hover}"` : '';
      const leave = shape.leave ? ` onmouseleave="${shape.leave}"` : '';
      const click = shape.click ? ` onclick="${shape.click}"` : '';
      const href = shape.href ? ` href="${shape.href}"` : ' nohref';
      resultingMapContent += `<area shape="poly"${hover}${leave}${click}${href} coords="${coords}" />`;
    });

    map.innerHTML = resultingMapContent;
  }
}

//create back-to-pinboard button
function initPinboardButton() {
  var pinboardButton = document.createElement('div');
  pinboardButton.id = "pinboardButton";
  pinboardButton.className = "uiButton";
  document.getElementById("gameSpace").appendChild(pinboardButton);

  pinboardButton.onclick = function (event) {

    // TODO
    // Return to Pinboard
    // console.log(pinboardState);
    stopBlinking();
    removeAllHitboxes();
    fadeToBlack();
    Dialogue.remove();

    // switch(pinboardState){
    //   case 3:
    //     window.setTimeout(initPinboard_1, 1000);
    //     drawHitboxesPinboard_1_2();
    //     break;
    //   case 5:
    //     window.setTimeout(initPinboard2, 1000);
    //     break;
    //   case 7:
    //     window.setTimeout(initPinboard3, 1000);
    //     break;
    //   case 10:
    //     window.setTimeout(initPinboard4, 1000);
    //     break;
    // }

    hideImage("narrator");
    hideImage("printer_page");
    hideImage("nurse");
    hideImage("paper_text");
    hideImage("message");

    switch (pinboardProgress) {
      // After hospital has been visited (tax-id-pin and hospital pin connected)
      case 2:
        window.setTimeout(initPinboard_1, 1000);
        window.setTimeout(drawHitboxesPinboard_1_2, 1000);
        break;
      // After hospital has been played til the end (office pin visible, yet not connected)
      // Needed for correct display when going back to pinboard, playing hospital again
      case 3:
        window.setTimeout(initPinboard2, 1000);
        window.setTimeout(drawHitboxesPinboard_2, 1000);
        break;
      // After office has been visited (office pin connected)
      case 4:
        // hideImage("narrator");
        // hideImage("printer_page");
        window.setTimeout(initPinboard_2, 1000);
        window.setTimeout(drawHitboxesPinboard_2, 1000);
        break;
      // After office has been played til the end (authority pin visible, yet not connected)
      case 5:
        // hideImage("narrator");
        window.setTimeout(initPinboard_3, 1000);
        window.setTimeout(drawHitboxesPinboard_3, 1000);
        break;
      // After authority has been visited (authority pin connected)
      case 6:
        // hideImage("narrator");
        hideImagesScene4();
        window.setTimeout(initPinboard_3, 1000);
        window.setTimeout(drawHitboxesPinboard_3, 1000);
        break;
      // After authority has been played til the end (Bzfst pin visible, yet not connected)
      case 7:
        // hideImage("narrator");
        window.setTimeout(initPinboard_4, 1000);
        window.setTimeout(drawHitboxesPinboard_4, 1000);
        break;
      // After Bzfst has been clicked (Bzfst pin connected)
      case 8:
        // hideImage("narrator");
        if (family == 0) {
          window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
        } else {
          window.setTimeout('showImage(\'pinFamily\')', 1000);
        }
        window.setTimeout('showImage(\'arrow_red\')', 1000);
        window.setTimeout('showImage(\'arrow_grey\')', 1000);
        window.setTimeout(initPinboard_4, 1000);
        window.setTimeout(drawHitboxesPinboard_4_2, 1000);
        break;
      case 9:
        // hideImage("narrator");
        if (family == 0) {
          window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
        } else {
          window.setTimeout('showImage(\'pinFamily\')', 1000);
        }
        window.setTimeout('showImage(\'arrow_red\')', 1000);
        window.setTimeout('showImage(\'arrow_grey\')', 1000);
        window.setTimeout(initPinboard_4, 1000);
        window.setTimeout(drawHitboxesPinboard_4_2, 1000);
        break;
      case 10:
        window.setTimeout(initPinboard5, 1000);
        window.setTimeout(drawHitboxesPinboard_5, 1000);
        break;
    }
  }

  pinboardButton.onmouseenter = function (event) {
    hideTXT();
  }

  pinboardButton.onmouseleave = function (event) {
    showTXT();
  }

}

//create fullscreen button
function initFullscreen() {
  var fullscreenButton = document.createElement('div');
  fullscreenButton.id = "fullscreenButton";
  fullscreenButton.className = "uiButton";
  document.getElementById("gameSpace").appendChild(fullscreenButton);

  fullscreenButton.onclick = function (event) {

    if (document.fullscreenElement) {
      document.exitFullscreen();
    }

    else {
      checkAspectRatio();
      gameContainer.requestFullscreen();
    }
  }

  fullscreenButton.onmouseenter = function (event) {
    hideTXT();
  }

  fullscreenButton.onmouseleave = function (event) {
    showTXT();
  }

  //Event listener to change the fullscreenButton
  document.getElementById("gameContainer").addEventListener("fullscreenchange", () => {
    document.fullscreenElement ? fullscreenButton.classList.add("notFull") : fullscreenButton.classList.remove("notFull");
    setFontSize();
  });
}

//create mute button
function initSound() {
  var muteButton = document.createElement('div');
  muteButton.id = "muteButton";
  muteButton.className = "uiButton";
  document.getElementById("gameSpace").appendChild(muteButton);

  muteButton.onmouseenter = function (event) {
    hideTXT();
  }

  muteButton.onmouseleave = function (event) {
    showTXT();
  }

  muteButton.onclick = function () {
    if (!muted) {
      muted = true;
      toggle_mute_running_audio()
      muteButton.classList.add("unMute");
    } else {
      muted = false;
      toggle_mute_running_audio()
      muteButton.classList.remove("unMute");
    }

    Object.values(environment_sounds).forEach((audio) => {
      audio.muted = muted;
    });
  }
}

//create continue button --> EDIT: Altered to create exit button
function createContinueButton() {
  if (document.getElementById("continueButton")) document.getElementById("continueButton").remove();
  var continueButton = document.createElement('div');
  continueButton.id = "continueButton";
  continueButton.className = "uiButton";
  document.getElementById("gameSpace").appendChild(continueButton);
  continueButton.innerHTML += "Beenden";
  setFontSize();
  continueButton.onclick = function () {
    continueButton.remove();
    // updatePinboard();

    let percentage = (parseInt((destatis + news + standes + renten + lasd + family) / 6 * 100)).toFixed(0);
    let messageEnd;
    let completion;
    call == 0 ? completion = gameEndMessage4 : completion = gameEndMessage2;
    percentage == 100 ? messageEnd = gameEndMessage3 : messageEnd = completion;
    removeAllHitboxes();
    PopUp.init(gameEndMessage1 + percentage + messageEnd + gameEndMessage5, {
      title: "Auf Pinnwand bleiben", action: () => {
        PopUp.remove();
        drawHitboxesPinboard_5();
        createContinueButton();
      }
    },
      //  {
      //   title: "Credits ansehen", action: () => {
      //     PopUp.remove();
      //     window.location.href = "impressum/impressum.html";
      //   }
      // }, {
      //   title: "Spiel bewerten", action: () => {
      //     window.open("https://survey.imis.uni-luebeck.de/index.php/247384", "_blank").focus();
      //   }
      // }
    );
  }
}

//create close screen message button
function createScreenMessageButton() {
  if (document.getElementById("screenMessageButton")) document.getElementById("screenMessageButton").remove();
  var screenMessageButton = document.createElement('div');
  screenMessageButton.id = "screenMessageButton";
  screenMessageButton.className = "uiButton";
  screenMessageContainer = document.getElementById("screenMessageContainer");
  screenMessage = document.getElementById("screenMessage");
  screenMessageContainer.appendChild(screenMessageButton);
  screenMessageButton.innerHTML += "Weiter";
  setFontSize();

  screenMessageButton.onclick = function () {
    // screenMessageButton.remove();
    window.setTimeout(fadeBack, 1000);
    window.setTimeout(tutorialDialogue1, 1500);
    document.getElementById("layer3").classList.add("hidden");
    window.setTimeout('document.getElementById("layer3").style.display = "none"', 900);
    // screenMessageButton.classList.add("hidden");
    // screenMessage.classList.add("hidden");
    // window.setTimeout('screenMessageButton.remove()', 900);
    // window.setTimeout('screenMessage.remove()', 900);
    activeGame = true;

    // window.setTimeout('document.getElementById("screenMessage").remove()', 1000);
  }
}

//remove continue button
function removeContinueButton() {
  if (document.getElementById("continueButton")) document.getElementById("continueButton").remove();
}

// #region pinboard hitboxes
//mapShapes = [{}];
//draw image maps for scene 1 pinboard
function drawHitboxesPinboard_1() {
  mapShapes = [{
    //tax id
    click: 'Dialogue.remove(); createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_1_2, \'pinboard_Info_TaxId\'); updatePinboard(); drawHitboxesPinboard_1_2();',
    coords: [
      0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
}

//draw image maps for scene 1 pinboard instance 2
function drawHitboxesPinboard_1_2() {
  mapShapes = [{
    //hospital pin
    // click: 'Dialogue.remove(); if(pinboardState == 1) {updatePinboard(); createContinueButton()} createOneDialogue(\'Herr Becker\', pinboard_Intro_Hospital, drawHitboxesPinboard_1_2)',
    click: 'Dialogue.remove(); if(pinboardState == 1) {updatePinboard();} createOneDialogue(\'Herr Becker\', pinboard_Intro_Hospital, \'loadPopupScene(1)\' , \'pinboard_Intro_Hospital\')',
    hover: 'if(pinboardState == 1) showImage(\'pinHospital_grey\')',
    leave: 'if(pinboardState == 1) hideImage(\'pinHospital_grey\')',
    coords: [
      0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
    ]
  }, {
    //tax id
    click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_1_2, \'pinboard_Info_TaxId\')',
    coords: [
      0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
}

//draw image maps for scene 2 pinboard
function drawHitboxesPinboard_2() {
  mapShapes = [{
    //office pin
    // click: 'if(pinboardState == 3) {updatePinboard(), createContinueButton()} createOneDialogue(\'Frau Becker\', pinboard_Intro_Office, drawHitboxesPinboard_2); ',
    click: 'if(pinboardState == 3) {updatePinboard()} createOneDialogue(\'Frau Becker\', pinboard_Intro_Office, \'loadPopupScene(2)\', \'pinboard_Intro_Office\'); ',
    hover: 'if(pinboardState == 3) showImage(\'pinOffice_grey\')',
    leave: 'if(pinboardState == 3) hideImage(\'pinOffice_grey\')',
    coords: [
      0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
      0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
    ]
  }, {
    //tax id
    click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_2, \'pinboard_Info_TaxId\')',
    coords: [
      0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
    ]
  }, {
    //hospital pin
    click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
    coords: [
      0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
}

//draw image maps for scene 3 pinboard
function drawHitboxesPinboard_3() {
  if (destatis == 1) showImage("pinDestatis");
  if (standes == 1) showImage("pinStandes");
  if (news == 1) showImage("pinNews");
  if (call == 0) {
    showImage("pinHideNews");
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_3, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_3, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'if(pinboardState == 5) {updatePinboard(); createContinueButton()} createOneDialogue(\'Herr Becker\', pinboard_Intro_Authority, drawHitboxesPinboard_3)',
      click: 'if(pinboardState == 5) {updatePinboard()} createOneDialogue(\'Herr Becker\', pinboard_Intro_Authority, \'loadPopupScene(3)\', \'pinboard_Intro_Authority\'); ',
      hover: 'if(pinboardState == 5) showImage(\'pinAuthority_grey\')',
      leave: 'if(pinboardState == 5) hideImage(\'pinAuthority_grey\')',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_3, \'pinboard_Info_TaxId\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_3)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_3)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }
    ];
  }
  else {
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_3, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //newspaper
      click: 'news = 1; createOneDialogue(\'Information\', pinboard_Info_News, drawHitboxesPinboard_3, \'pinboard_Info_News\')',
      hover: 'if(news == 0) showImage(\'pinNews\')',
      leave: 'if(news == 0) hideImage(\'pinNews\')',
      coords: [
        0.7323, 0.3528, 0.7448, 0.2472, 0.8125, 0.2759, 0.8005, 0.3787
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_3, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'if(pinboardState == 5) {updatePinboard(); createContinueButton()} createOneDialogue(\'Herr Becker\', pinboard_Intro_Authority, drawHitboxesPinboard_3)',
      click: 'if(pinboardState == 5) {updatePinboard()} createOneDialogue(\'Herr Becker\', pinboard_Intro_Authority, \'loadPopupScene(3)\', \'pinboard_Intro_Authority\'); ',
      hover: 'if(pinboardState == 5) showImage(\'pinAuthority_grey\')',
      leave: 'if(pinboardState == 5) hideImage(\'pinAuthority_grey\')',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_3, \'pinboard_Info_TaxId\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_3)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_3)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }
    ];
  }
  setMapShapes();
  resetInactiveTime();
}

//function to draw all hitboxes for scene 4 pinboard
function drawHitboxesPinboard_4() {
  if (destatis == 1) showImage("pinDestatis");
  if (standes == 1) showImage("pinStandes");
  if (news == 1) showImage("pinNews");
  if (renten == 1) showImage("pinRenten");
  if (lasd == 1) showImage("pinLASD")
  if (call == 0) {
    showImage("pinHideNews");
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_4, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_4, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_4)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\'); ',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_4, \' \')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_4)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_4)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_4, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_4, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2); updatePinboard()',
      click: 'if(pinboardState == 7) {updatePinboard()} removeAllHitboxes(); createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\'); ',
      hover: 'showImage(\'pinBzfst_grey\')',
      leave: 'hideImage(\'pinBzfst_grey\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }
    ];
  }
  else {
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_4, \'\', \'\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //newspaper
      click: 'news = 1; createOneDialogue(\'Information\', pinboard_Info_News, drawHitboxesPinboard_4, \'pinboard_Info_News\')',
      hover: 'if(news == 0) showImage(\'pinNews\')',
      leave: 'if(news == 0) hideImage(\'pinNews\')',
      coords: [
        0.7323, 0.3528, 0.7448, 0.2472, 0.8125, 0.2759, 0.8005, 0.3787
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_4, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_4)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\'); ',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId, drawHitboxesPinboard_4, \'pinboard_Info_TaxId\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_4)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_4)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_4, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_4, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2); updatePinboard()',
      click: 'if(pinboardState == 7) {updatePinboard()} removeAllHitboxes(); createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\'); ',
      hover: 'showImage(\'pinBzfst_grey\')',
      leave: 'hideImage(\'pinBzfst_grey\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }
    ];
  }

  setMapShapes();
  resetInactiveTime();
}

//function to draw all hitboxes for scene 4 pinboard
function drawHitboxesPinboard_4_2() {
  if (destatis == 1) showImage("pinDestatis");
  if (standes == 1) showImage("pinStandes");
  if (news == 1) showImage("pinNews");
  if (renten == 1) showImage("pinRenten");
  if (lasd == 1) showImage("pinLASD")
  if (call == 0) {
    showImage("pinHideNews");
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_4_2, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_4_2, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_4_2)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\'); ',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      // click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId2, drawHitboxesPinboard_4_2); if(pinboardState == 8) {updatePinboard(); createContinueButton()}',
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId2, \'loadPopupScene(4)\', \'pinboard_Info_TaxId2\');',
      // hover: 'if(pinboardState == 8||9) document.getElementById(\'arrow\').src = \'images/pinboard/Pinnwand_pfeil_100.png\'',
      hover: 'if(pinboardState == 8||9) showImage(\'arrow_red\')',
      // leave: 'if(pinboardState == 8||9) document.getElementById(\'arrow\').src = \'images/pinboard/Pinnwand_pfeil.png\'',
      leave: 'if(pinboardState == 8||9) showImage(\'arrow_grey\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_4_2)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_4_2)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_4_2, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_4_2, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }, {
      //family pin
      click: 'family = 1; createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_4_2, \'pinboard_Info_Family1\', \'pinboard_Info_Family2\')',
      // hover: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_familienkasse_100.png\'',
      hover: 'if(family == 0) showImage(\'pinFamily\')',
      // leave: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_Familienkasse.png\'',
      leave: 'if(family == 0) showImage(\'pinFamily_grey\')',
      coords: [
        0.3255, 0.7231, 0.3260, 0.8056, 0.2906, 0.8065, 0.2844, 0.8102, 0.2771, 0.7843, 0.2766, 0.7204
      ]
    }
    ];
  }
  else {
    //destatis
    mapShapes = [{
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_4_2, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //newspaper
      click: 'news = 1; createOneDialogue(\'Information\', pinboard_Info_News, drawHitboxesPinboard_4_2, \'pinboard_Info_News\')',
      hover: 'if(news == 0) showImage(\'pinNews\')',
      leave: 'if(news == 0) hideImage(\'pinNews\')',
      coords: [
        0.7323, 0.3528, 0.7448, 0.2472, 0.8125, 0.2759, 0.8005, 0.3787
      ]
    }, {
      //standesämter der eltern
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_4_2, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_4_2)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\'); ',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      // click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId2, drawHitboxesPinboard_4_2); if(pinboardState == 8) {updatePinboard(); createContinueButton()}',
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId2, \'loadPopupScene(4)\', \'pinboard_Info_TaxId2\');',
      // hover: 'if(pinboardState == 8||9) document.getElementById(\'arrow\').src = \'images/pinboard/Pinnwand_pfeil_100.png\'',
      hover: 'if(pinboardState == 8||9) showImage(\'arrow_red\')',
      // leave: 'if(pinboardState == 8||9) document.getElementById(\'arrow\').src = \'images/pinboard/Pinnwand_pfeil.png\'',
      leave: 'if(pinboardState == 8||9) showImage(\'arrow_grey\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_4_2)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_4_2)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_4_2, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_4_2, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_4_2, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }, {
      //family pin
      click: 'family = 1; createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_4_2, \'pinboard_Info_Family1\', \'pinboard_Info_Family2\')',
      // hover: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_familienkasse_100.png\'',
      hover: 'if(family == 0) showImage(\'pinFamily\')',
      // leave: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_Familienkasse.png\'',
      leave: 'if(family == 0) showImage(\'pinFamily_grey\')',
      coords: [
        0.3255, 0.7231, 0.3260, 0.8056, 0.2906, 0.8065, 0.2844, 0.8102, 0.2771, 0.7843, 0.2766, 0.7204
      ]
    }
    ];
  }
  setMapShapes();
  resetInactiveTime();
}

//function to draw all hitboxes for scene 5 pinboard
function drawHitboxesPinboard_5() {
  if (destatis == 1) showImage("pinDestatis");
  if (standes == 1) showImage("pinStandes");
  if (news == 1) showImage("pinNews");
  if (renten == 1) showImage("pinRenten");
  if (lasd == 1) showImage("pinLASD")
  if (call == 0) {
    mapShapes = [{
      //destatis
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_5)',
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_5, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //standesämter der eltern
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_5)',
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_5, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_5)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene5(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\')',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      // click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId3, drawHitboxesPinboard_5)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId3, \'loadPopupScene5(4)\', \'pinboard_Info_TaxId3\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_5)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene5(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_5)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_5)',
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_5, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_5)',
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_5, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_5, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }, {
      //family pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_5)',
      click: 'family = 1; createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_5, \'pinboard_Info_Family1\', \'pinboard_Info_Family2\')',
      hover: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_familienkasse_100.png\'',
      leave: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_Familienkasse.png\'',
      coords: [
        0.3255, 0.7231, 0.3260, 0.8056, 0.2906, 0.8065, 0.2844, 0.8102, 0.2771, 0.7843, 0.2766, 0.7204
      ]
    }
    ];
  }
  else {
    //destatis
    mapShapes = [{
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_5)',
      click: 'destatis = 1; createTwoDialogues(\'Information\', pinboard_Info_Destatis1, pinboard_Info_Destatis2, drawHitboxesPinboard_5, \'pinboard_Info_Destatis1\', \'pinboard_Info_Destatis2\')',
      hover: 'if(destatis == 0) showImage(\'pinDestatis\')',
      leave: 'if(destatis == 0) hideImage(\'pinDestatis\')',
      coords: [
        0.7406, 0.1463, 0.7375, 0.2333, 0.7750, 0.2343, 0.7901, 0.2250, 0.7880, 0.2019, 0.7896, 0.1481
      ]
    }, {
      //newspaper
      // click: 'createOneDialogue(\'Information\', pinboard_Info_News, drawHitboxesPinboard_5)',
      click: 'news = 1; createOneDialogue(\'Information\', pinboard_Info_News, drawHitboxesPinboard_5, \'pinboard_Info_News\')',
      hover: 'if(news == 0) showImage(\'pinNews\')',
      leave: 'if(news == 0) hideImage(\'pinNews\')',
      coords: [
        0.7323, 0.3528, 0.7448, 0.2472, 0.8125, 0.2759, 0.8005, 0.3787
      ]
    }, {
      //standesämter der eltern
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_5)',
      click: 'standes = 1; createOneDialogue(\'Information\', pinboard_Info_Standes, drawHitboxesPinboard_5, \'pinboard_Info_Standes\')',
      hover: 'if(standes == 0) showImage(\'pinStandes\')',
      leave: 'if(standes == 0) hideImage(\'pinStandes\')',
      coords: [
        0.7323, 0.3972, 0.7323, 0.4546, 0.7297, 0.4722, 0.7458, 0.4833, 0.7818, 0.4833, 0.7813, 0.3972
      ]
    }, {
      //authority pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, drawHitboxesPinboard_5)',
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Authority1, pinboard_Info_Authority2, \'loadPopupScene5(3)\', \'pinboard_Info_Authority1\', \'pinboard_Info_Authority2\')',
      coords: [
        0.5620, 0.6787, 0.5698, 0.4963, 0.6630, 0.5074, 0.6557, 0.6898
      ]
    }, {
      //tax id
      // click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId3, drawHitboxesPinboard_5)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_TaxId3, \'loadPopupScene5(4)\', \'pinboard_Info_TaxId3\')',
      coords: [
        0.2224, 0.3759, 0.2203, 0.2694, 0.2286, 0.2565, 0.2297, 0.2231, 0.2521, 0.2222, 0.2682, 0.1991, 0.2828, 0.2204, 0.3073, 0.2176, 0.3089, 0.2546, 0.3177, 0.2667, 0.3198, 0.3694
      ]
    }, {
      //hospital pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, drawHitboxesPinboard_5)',
      click: 'createOneDialogue(\'Information\', pinboard_Info_Hospital, \'loadPopupScene5(1)\', \'pinboard_Info_Hospital\')',
      coords: [
        0.3865, 0.2565, 0.3854, 0.4324, 0.4750, 0.4333, 0.4755, 0.2583
      ]
    }, {
      //office pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, drawHitboxesPinboard_5)',
      click: 'createFourDialogues(\'Information\', pinboard_Info_Office1, pinboard_Info_Office2, pinboard_Info_Office3, pinboard_Info_Office4, \'loadPopupScene(2)\', \'pinboard_Info_Office1\', \'pinboard_Info_Office2\' , \'pinboard_Info_Office3\' , \'pinboard_Info_Office4\'); ',
      coords: [
        0.5432291666666667, 0.19814814814814816, 0.6369791666666667, 0.18981481481481483, 0.6421875,
        0.37222222222222223, 0.5484375, 0.38055555555555554, 0.5432291666666667, 0.19814814814814816
      ]
    }, {
      //Renten pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_5)',
      click: 'renten = 1; createOneDialogue(\'Information\', pinboard_Info_Renten, drawHitboxesPinboard_5, \'pinboard_Info_Renten\')',
      hover: 'if(renten == 0) showImage(\'pinRenten\')',
      leave: 'if(renten == 0) hideImage(\'pinRenten\')',
      coords: [
        0.7406, 0.6222, 0.7401, 0.6824, 0.7375, 0.6981, 0.7552, 0.7093, 0.7901, 0.7102, 0.7896, 0.6231
      ]
    }, {
      //LASD pin
      // click: 'createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_5)',
      click: 'lasd = 1; createOneDialogue(\'Information\', pinboard_Info_LASD, drawHitboxesPinboard_5, \'pinboard_Info_LASD\')',
      hover: 'if(lasd == 0) showImage(\'pinLASD\')',
      leave: 'if(lasd == 0) hideImage(\'pinLASD\')',
      coords: [
        0.6911, 0.7648, 0.7370, 0.7769, 0.7318, 0.8352, 0.7328, 0.8509, 0.7177, 0.8583, 0.6818, 0.8519
      ]
    }, {
      //Bzfst pin
      click: 'createTwoDialogues(\'Information\', pinboard_Info_Bzfst1, pinboard_Info_Bzfst2, drawHitboxesPinboard_5, \'pinboard_Info_Bzfst1\', \'pinboard_Info_Bzfst2\')',
      coords: [
        0.4896, 0.7204, 0.4849, 0.5389, 0.3922, 0.5454, 0.3953, 0.7306
      ]
    }, {
      //family pin
      // click: 'createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_5)',
      click: 'family = 1; createTwoDialogues(\'Information\', pinboard_Info_Family1, pinboard_Info_Family2, drawHitboxesPinboard_5, \'pinboard_Info_Family1\', \'pinboard_Info_Family2\')',
      hover: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_familienkasse_100.png\'',
      leave: 'if(family == 0) document.getElementById(\'pinFamily\').src = \'images/pinboard/Pinnwand_Familienkasse.png\'',
      coords: [
        0.3255, 0.7231, 0.3260, 0.8056, 0.2906, 0.8065, 0.2844, 0.8102, 0.2771, 0.7843, 0.2766, 0.7204
      ]
    }
    ];
  }
  setMapShapes();
  resetInactiveTime();
}

// #endregion pinboard hitboxes

//function to draw all hitboxes relevant for the tutorial
function drawHitboxesTutorial() {

  mapShapes = [{
    id: 'cupcake',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'cupcake\');',
    leave: 'hideImage(\'cupcake\'); stopInactiveTime(); ',
    // click: 'hideImage(\'cupcake\'); removeAllHitboxes(); Dialogue.remove(); fadeToBlack(); window.setTimeout(initScene1,1000)',
    click: 'hideImage(\'cupcake\'); removeAllHitboxes(); Dialogue.remove(); tutorialDialogue2();',
    coords: [
      0.546875, 0.46296296296296297, 0.5453125, 0.4638888888888889,
      0.5447916666666667, 0.4666666666666667, 0.5453125, 0.4685185185185185,
      0.546875, 0.4777777777777778, 0.5489583333333333, 0.4898148148148148,
      0.5494791666666666, 0.4925925925925926, 0.5520833333333334, 0.4962962962962963,
      0.5552083333333333, 0.4981481481481482, 0.5604166666666667, 0.4981481481481482,
      0.5645833333333333, 0.4962962962962963, 0.5666666666666667, 0.4935185185185185,
      0.56875, 0.48148148148148145, 0.5703125, 0.46944444444444444, 0.5697916666666667,
      0.4638888888888889, 0.5697916666666667, 0.45740740740740743, 0.5677083333333334,
      0.4537037037037037, 0.5666666666666667, 0.4527777777777778, 0.5645833333333333,
      0.44722222222222224, 0.5640625, 0.43333333333333335, 0.5604166666666667,
      0.43796296296296294, 0.5546875, 0.44166666666666665, 0.5546875, 0.4462962962962963,
      0.5510416666666667, 0.45, 0.5489583333333333, 0.45185185185185184,
      0.5473958333333333, 0.4564814814814815, 0.546875, 0.46296296296296297
    ]
  },
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();

  // mapShapes.forEach(element => {
  //   console.log(element.id);
  // });
}

// #region scene hitboxes

//draw image maps for scene 1
function drawHitboxesScene1() {
  mapShapes = [{
    id: 'doorHighlight',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'doorHighlight\')',
    leave: 'hideImage(\'doorHighlight\'); stopInactiveTime();',
    click: 'hideImage(\'doorHighlight\'); removeAllHitboxes(); playDoorOpen(); window.setTimeout(initScene1_2, 200)',
    coords: [
      0.0583, 0.5435, 0.0479, 0.0796, 0.1771, 0.0981, 0.1766, 0.5481
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw image maps for scene 1_2
function drawHitboxesScene1_2() {
  mapShapes = [{
    id: 'letterHighlight',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'letterHighlight\')',
    leave: 'hideImage(\'letterHighlight\'); stopInactiveTime();',
    click: 'hideImage(\'letterHighlight\'); removeAllHitboxes(); playLetterOpen(); window.setTimeout(openLetter, 1500)',
    coords: [
      0.3609, 0.4759, 0.6495, 0.4324, 0.6661, 0.7991, 0.3854, 0.8426
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene 2
function drawHitboxesScene2() {
  mapShapes = [{
    id: 'paper_highlight',
    click: 'hideImage(\'paper_highlight\'); initScene2_1()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'paper_highlight\')',
    leave: 'hideImage(\'paper_highlight\'); stopInactiveTime();',
    coords: [
      0.2234, 0.5694, 0.2281, 0.5787, 0.2833, 0.5046, 0.2536, 0.4380, 0.2120, 0.4944, 0.2203, 0.5213, 0.2245, 0.5602
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}
//draw hitbox for the paper
function drawHitboxesScene2_1() {
  mapShapes = [{
    id: 'paper_highlight_big',
    click: 'hideImage(\'paper_highlight_big\'); initScene2_2()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'paper_highlight_big\')',
    leave: 'hideImage(\'paper_highlight_big\'); stopInactiveTime();',
    coords: [
      0.29739583333333336, 0.0712962962962963, 0.2984375, 0.9851851851851852,
      0.6442708333333333, 0.9925925925925926, 0.6213541666666667, 0.8916666666666667,
      0.5802083333333333, 0.7824074074074074, 0.5869791666666667, 0.7592592592592593,
      0.6197916666666666, 0.7851851851851852, 0.6541666666666667, 0.8435185185185186,
      0.6802083333333333, 0.825, 0.6755208333333333, 0.7416666666666667, 0.6828125,
      0.7342592592592593, 0.684375, 0.07592592592592592, 0.29739583333333336, 0.0712962962962963
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3
function drawHitboxesScene3() {
  mapShapes = [{
    id: 'buro_highlight',
    click: 'hideImage(\'buro_highlight\'); initScene3_1();',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'buro_highlight\')',
    leave: 'hideImage(\'buro_highlight\'); stopInactiveTime();',
    // coords: [
    //   0.28125, 0.5972222222222222, 0.2859375, 0.9675925925925926, 0.44427083333333334, 0.975, 
    //   0.45, 0.662962962962963, 0.6526041666666667, 0.6527777777777778, 0.6515625, 0.975, 
    //   0.8255208333333334, 0.9777777777777777, 0.8369791666666667, 0.5888888888888889, 
    //   0.6557291666666667, 0.5888888888888889, 0.6630208333333333, 0.37592592592592594, 0.4640625, 
    //   0.38055555555555554, 0.47552083333333334, 0.5462962962962963, 0.4328125, 0.5944444444444444, 0.28125, 0.5972222222222222
    // ]
    coords: [
      0.5566994210141812, 0.6495999608995856,
      0.4460099655828721, 0.6536995703600045,
      0.445160220657487, 0.9461239803687048,
      0.39255665180540184, 0.9496308849588438,
      0.39387174102670397, 0.6655716131575842,
      0.2939249602077422, 0.6702474859444362,
      0.29326741559709113, 0.5954335213548039,
      0.4846128972965508, 0.5860817757810999,
      0.4846128972965508, 0.5521816980764229,
      0.41096790090363167, 0.5486747934862838,
      0.3958443748586572, 0.36865369119248137,
      0.5963954811072317, 0.3651467866023424,
      0.6082312840989509, 0.5428299525027188,
      0.5148599493864998, 0.5545196344698489,
      0.5148599493864998, 0.5802369347975349,
      0.8081248457368743, 0.587250743977813,
      0.7976041319664573, 0.9507998531555569,
      0.6345330685249935, 0.9472929485654179,
      0.6358481577462956, 0.649206058403602]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3_2
function drawHitboxesScene3_2() {
  mapShapes = [{
    //pc hitbox
    id: 'pc_highlight',
    click: 'Dialogue.remove(); hideImage(\'pc_highlight\'); if(letter != 0)initScene3_2(); else {scene3_Dialogue_opt2(); computer++}',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'pc_highlight\')',
    leave: 'hideImage(\'pc_highlight\'); stopInactiveTime();',
    coords: [
      0.55625, 0.006481481481481481, 0.5520833333333334, 0.0, 0.5369791666666667, 0.0,
      0.14635416666666667, 0.06574074074074074, 0.140625, 0.075, 0.18489583333333334, 0.2796296296296296,
      0.19270833333333334, 0.28425925925925927, 0.5307291666666667, 0.22685185185185186, 0.5338541666666666,
      0.21944444444444444, 0.55625, 0.006481481481481481
    ]
  },
  {
    //postit hitbox
    id: 'postit_highlight',
    click: 'Dialogue.remove(); hideImage(\'postit_highlight\'); scene3_Dialogue_postit()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'postit_highlight\')',
    leave: 'hideImage(\'postit_highlight\'); stopInactiveTime();',
    coords: [
      0.18020833333333333, 0.30833333333333335, 0.1796875, 0.3888888888888889, 0.1921875,
      0.39444444444444443, 0.2296875, 0.39537037037037037, 0.22916666666666666, 0.30925925925925923,
      0.18020833333333333, 0.30833333333333335
    ]
  }, {
    //printer hitbox
    id: 'printer_highlight',
    click: 'Dialogue.remove(); hideImage(\'printer_highlight\'); scene3_Dialogue_opt(1); printer++',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'printer_highlight\')',
    leave: 'hideImage(\'printer_highlight\'); stopInactiveTime();',
    coords: [
      0.6505208333333333, 0.0, 0.6505208333333333, 0.008333333333333333, 0.6447916666666667,
      0.013888888888888888, 0.6369791666666667, 0.02962962962962963, 0.6338541666666667, 0.05092592592592592,
      0.5890625, 0.05092592592592592, 0.5817708333333333, 0.058333333333333334, 0.578125, 0.06851851851851852, 0.5760416666666667, 0.08796296296296297,
      0.5755208333333334, 0.2675925925925926, 0.584375, 0.2777777777777778, 0.5984375, 0.2777777777777778,
      0.5994791666666667, 0.28703703703703703, 0.6067708333333334, 0.2953703703703704, 0.6427083333333333,
      0.2953703703703704, 0.646875, 0.32314814814814813, 0.6578125, 0.3398148148148148, 0.6578125,
      0.39444444444444443, 0.7770833333333333, 0.39351851851851855, 0.7770833333333333, 0.3425925925925926,
      0.790625, 0.32314814814814813, 0.7953125, 0.30092592592592593, 0.7953125, 0.2935185185185185,
      0.84375, 0.2953703703703704, 0.85, 0.2833333333333333, 0.8505208333333333, 0.2777777777777778,
      0.8578125, 0.27314814814814814, 0.8604166666666667, 0.2657407407407407, 0.8609375, 0.0787037037037037,
      0.85625, 0.06111111111111111, 0.8489583333333334, 0.05, 0.803125, 0.05277777777777778,
      0.8010416666666667, 0.03148148148148148, 0.7947916666666667, 0.01574074074074074, 0.7869791666666667,
      0.009259259259259259, 0.7869791666666667, 0.0, 0.6505208333333333, 0.0
    ]
  }, {
    //handy hitbox
    id: 'handy_highlight',
    click: 'Dialogue.remove(); hideImage(\'handy_highlight\'); scene3_Dialogue_opt5()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'handy_highlight\')',
    leave: 'hideImage(\'handy_highlight\'); stopInactiveTime();',
    coords: [
      0.022395833333333334, 0.2722222222222222, 0.08541666666666667, 0.2351851851851852, 0.0953125,
      0.24722222222222223, 0.12447916666666667, 0.4148148148148148, 0.1203125, 0.4324074074074074,
      0.06302083333333333, 0.4648148148148148, 0.0546875, 0.45740740740740743, 0.022395833333333334,
      0.2722222222222222,
    ]
  }, {
    //letter on desk
    id: 'letter2_highlight',
    click: 'Dialogue.remove(); if(letter == 0) {scene3_Dialogue3(); letter++} else scene3_Dialogue_opt4(); hideImage(\'letter2_highlight\')',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'letter2_highlight\')',
    leave: 'hideImage(\'letter2_highlight\'); stopInactiveTime();',
    coords: [
      0.7796875, 0.575925925925926, 0.9192708333333334, 0.49907407407407406, 0.9453125, 0.6537037037037037,
      0.8067708333333333, 0.7296296296296296, 0.7796875, 0.575925925925926
    ]
  }];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3_3, the desktop and its windows
function drawHitboxesScene3_3() {

  mapShapes = [{
    id: 'window2_highlight',
    click: 'showImage(\'window2_data\'), hideImage(\'window2_highlight\'), drawHitboxesScene3_3_2()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'window2_highlight\')',
    leave: 'hideImage(\'window2_highlight\'); stopInactiveTime();',
    coords: [
      0.3260416666666667, 0.1648148148148148, 0.3260416666666667, 0.7388888888888889,
      0.7276041666666667, 0.7398148148148148, 0.7286458333333333, 0.1648148148148148,
      0.3260416666666667, 0.1648148148148148
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3_3_2, the desktop and its windows
function drawHitboxesScene3_3_2() {

  mapShapes = [{
    id: 'forward_highlight',
    click: 'showImage(\'forward_crosses\'), hideImage(\'forward_highlight\'), drawHitboxesScene3_4()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'forward_highlight\')',
    leave: 'hideImage(\'forward_highlight\'); stopInactiveTime();',
    coords: [
      0.6099, 0.4667, 0.7156, 0.4657, 0.7156, 0.6037, 0.6094, 0.6037
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3_4, the windows button
function drawHitboxesScene3_4() {

  mapShapes = [{
    id: 'window2_button',
    click: 'hideImage(\'window2\'), hideImage(\'window2_data\'), hideImage(\'window2_button\'), hideImage(\'forward_crosses\'), removeAllHitboxes(),scene3_Dialogue4();',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'window2_button\')',
    leave: 'hideImage(\'window2_button\'); stopInactiveTime();',
    coords: [
      0.6979166666666666, 0.6546296296296297, 0.6984375, 0.687037037037037, 0.6286458333333333,
      0.687037037037037, 0.628125, 0.6546296296296297, 0.6979166666666666, 0.6546296296296297
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//draw hitboxes for scene3_5, the windows print button
function drawHitboxesScene3_5() {

  mapShapes = [{
    id: 'window3_button',
    click: 'Dialogue.remove(); playPrinterSound(); hideImage(\'window3_button\'); crossFade(); showImage(\'printer_page\'); removeAllHitboxes(); window.setTimeout(drawHitboxesScene3_printer, 1500); certificate = 1',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'window3_button\')',
    leave: 'hideImage(\'window3_button\'); stopInactiveTime();',
    coords: [
      0.26927083333333335, 0.30277777777777776, 0.36302083333333335, 0.30277777777777776,
      0.3625, 0.36018518518518516, 0.26979166666666665, 0.3592592592592593,
      0.26927083333333335, 0.30277777777777776
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

function drawHitboxesScene3_printer() {
  letter = 3;
  mapShapes = [{
    //paper hitbox
    id: 'page_highlight',
    click: 'Dialogue.remove();hideImage(\'printer_page\'); hideImage(\'page_highlight\'); initScene3_last()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'page_highlight\')',
    leave: 'hideImage(\'page_highlight\'); stopInactiveTime();',
    coords: [
      0.7776041666666667, 0.23796296296296296, 0.7776041666666667, 0.39351851851851855, 0.6578125,
      0.39351851851851855, 0.6572916666666667, 0.23796296296296296, 0.7776041666666667, 0.23796296296296296
    ]
  },
  {
    //handy hitbox
    id: 'handy_highlight',
    // click: 'Dialogue.remove(); if(clickedPostit == 1 && call == 0) {playPhoneSound(); showImage(\'handy_face\'); removeAllHitboxes(); dialogue_handy(); clickedPostit = 2} else scene3_Dialogue_opt5(); hideImage(\'handy_highlight\')',
    click: 'Dialogue.remove(); if(clickedPostit == 1 && call == 0) {playPhoneSound(); showImage(\'handy_face\'); removeAllHitboxes(); dialogue_handy();} else scene3_Dialogue_opt5(); hideImage(\'handy_highlight\')',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'handy_highlight\')',
    leave: 'hideImage(\'handy_highlight\'); stopInactiveTime();',
    coords: [
      0.022395833333333334, 0.2722222222222222, 0.08541666666666667, 0.2351851851851852, 0.0953125,
      0.24722222222222223, 0.12447916666666667, 0.4148148148148148, 0.1203125, 0.4324074074074074,
      0.06302083333333333, 0.4648148148148148, 0.0546875, 0.45740740740740743, 0.022395833333333334,
      0.2722222222222222,
    ]
  }, {
    //postit hitbox
    id: 'postit_highlight',
    // click: 'Dialogue.remove(); hideImage(\'postit_highlight\'); clickedPostit++; scene3_Dialogue_postit()',
    click: 'Dialogue.remove(); hideImage(\'postit_highlight\'); scene3_Dialogue_postit()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'postit_highlight\')',
    leave: 'hideImage(\'postit_highlight\'); stopInactiveTime();',
    coords: [
      0.18020833333333333, 0.30833333333333335, 0.1796875, 0.3888888888888889, 0.1921875,
      0.39444444444444443, 0.2296875, 0.39537037037037037, 0.22916666666666666, 0.30925925925925923,
      0.18020833333333333, 0.30833333333333335
    ]
  }, {
    //pc hitbox
    id: 'pc_highlight',
    click: 'Dialogue.remove(); hideImage(\'pc_highlight\'); scene3_Dialogue_opt3(); computer++',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'pc_highlight\')',
    leave: 'hideImage(\'pc_highlight\'); stopInactiveTime();',
    coords: [
      0.55625, 0.006481481481481481, 0.5520833333333334, 0.0, 0.5369791666666667, 0.0,
      0.14635416666666667, 0.06574074074074074, 0.140625, 0.075, 0.18489583333333334, 0.2796296296296296,
      0.19270833333333334, 0.28425925925925927, 0.5307291666666667, 0.22685185185185186, 0.5338541666666666,
      0.21944444444444444, 0.55625, 0.006481481481481481
    ]
  }, {
    //letter on desk
    id: 'letter2_highlight',
    click: 'Dialogue.remove(); scene3_Dialogue_opt4(); hideImage(\'letter2_highlight\')',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'letter2_highlight\')',
    leave: 'hideImage(\'letter2_highlight\'); stopInactiveTime();',
    coords: [
      0.7796875, 0.575925925925926, 0.9192708333333334, 0.49907407407407406, 0.9453125, 0.6537037037037037,
      0.8067708333333333, 0.7296296296296296, 0.7796875, 0.575925925925926
    ]
  }];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//hitbox for the buro
function drawHitboxesScene4() {
  mapShapes = [{
    id: 'buro2_highlight',
    click: 'hideImage(\'buro2_highlight\'); removeAllHitboxes(); initScene4_1()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'buro2_highlight\')',
    leave: 'hideImage(\'buro2_highlight\'); stopInactiveTime();',
    coords: [
      0.2203125, 0.975, 0.22864583333333333, 0.9953703703703703, 0.7541666666666667, 0.975,
      0.7921875, 0.575925925925926, 0.5052083333333334, 0.5805555555555556, 0.4973958333333333,
      0.549074074074074, 0.5541666666666667, 0.5444444444444444, 0.5645833333333333, 0.36203703703703705,
      0.37552083333333336, 0.36203703703703705, 0.3671875, 0.5398148148148149, 0.19322916666666667,
      0.5861111111111111, 0.2203125, 0.975
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//hitboxes for the desk
function drawHitboxesScene4_1() {
  mapShapes = [{
    id: 'pc2_highlight',
    click: 'Dialogue.remove(); hideImage(\'pc2_highlight\'); initScene4_2();',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'pc2_highlight\')',
    leave: 'hideImage(\'pc2_highlight\'); stopInactiveTime();',
    coords: [
      0.2755208333333333, 0.1037037037037037, 0.2640625, 0.14444444444444443, 0.3484375, 0.362962962962963,
      0.3640625, 0.3685185185185185, 0.6859375, 0.37592592592592594, 0.6984375, 0.362962962962963,
      0.7916666666666666, 0.15, 0.7802083333333333, 0.11203703703703703, 0.2755208333333333,
      0.1037037037037037
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

var email = 0;
var database = 1;
var persondataOpen = 0;
var s = 0;
var n = 0;
var c = 0;

//hitboxes for the desktop
function drawHitboxesScene4_apps() {

  //open the mails
  if (email == 0) {
    mapShapes = [{
      //email icon
      id: 'email_highlight',
      click: 'email = 1; database = 1; hideImage(\'email_highlight\'); hideImage(\'message\'); showImage(\'email\'); scene4_dialogue_email()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'email_highlight\')',
      leave: 'hideImage(\'email_highlight\'); stopInactiveTime();',
      coords: [
        0.14322916666666666, 0.2712962962962963, 0.1953125, 0.2740740740740741, 0.20104166666666667,
        0.20185185185185187, 0.17916666666666667, 0.16944444444444445, 0.14166666666666666,
        0.1712962962962963, 0.14322916666666666, 0.2712962962962963
      ]
    },
    {
      //database icon
      id: 'database_highlight',
      click: 'hideImage(\'database_highlight\'); database++; scene4_dialogue_database()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'database_highlight\')',
      leave: 'hideImage(\'database_highlight\'); stopInactiveTime();',
      coords: [
        0.13229166666666667, 0.46111111111111114, 0.2125, 0.462037037037037, 0.21302083333333333,
        0.3296296296296296, 0.13229166666666667, 0.32685185185185184, 0.13229166666666667, 0.46111111111111114
      ]
    }
    ];
  }

  //make sure the mails are open
  else if (email >= 1 && persondataOpen == 0) {
    mapShapes = [{
      //email icon
      id: 'email_highlight2',
      click: 'Dialogue.remove(); hideImage(\'email_highlight2\'); email++; scene4_dialogue_email()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'email_highlight2\')',
      leave: 'hideImage(\'email_highlight2\'); stopInactiveTime();',
      coords: [
        0.14322916666666666, 0.2712962962962963, 0.1953125, 0.2740740740740741, 0.20104166666666667,
        0.20185185185185187, 0.17916666666666667, 0.16944444444444445, 0.14166666666666666,
        0.1712962962962963, 0.14322916666666666, 0.2712962962962963
      ]
    },
    {
      //database icon
      id: 'database_highlight',
      click: 'Dialogue.remove(); hideImage(\'database_highlight\'); database++; scene4_dialogue_database()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'database_highlight\')',
      leave: 'hideImage(\'database_highlight\'); stopInactiveTime();',
      coords: [
        0.13229166666666667, 0.46111111111111114, 0.2125, 0.462037037037037, 0.21302083333333333,
        0.3296296296296296, 0.13229166666666667, 0.32685185185185184, 0.13229166666666667, 0.46111111111111114
      ]
    },
    {
      //persondata from the email
      id: 'email_data',
      click: 'Dialogue.remove(); persondataOpen = 1; hideImage(\'email_data\'); showImage(\'person_data\'); scene4_dialogue_personData()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'email_data\')',
      leave: 'hideImage(\'email_data\'); stopInactiveTime();',
      coords: [
        0.48385416666666664, 0.6722222222222223, 0.48333333333333334, 0.5953703703703703,
        0.42916666666666664, 0.5962962962962963, 0.42916666666666664, 0.6731481481481482,
        0.48385416666666664, 0.6722222222222223
      ]
    }
    ];
  }
  //open the database
  else if (email >= 1 && persondataOpen == 1 && database >= 1) {
    mapShapes = [{
      //email icon
      id: 'email_highlight2',
      click: 'Dialogue.remove(); hideImage(\'email_highlight2\'); email++; scene4_dialogue_email()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'email_highlight2\')',
      leave: 'hideImage(\'email_highlight2\'); stopInactiveTime();',
      coords: [
        0.14322916666666666, 0.2712962962962963, 0.1953125, 0.2740740740740741, 0.20104166666666667,
        0.20185185185185187, 0.17916666666666667, 0.16944444444444445, 0.14166666666666666,
        0.1712962962962963, 0.14322916666666666, 0.2712962962962963
      ]
    },
    {
      //database icon
      id: 'database_highlight',
      click: 'Dialogue.remove(); hideImage(\'database_highlight\'); database = 0; showImage(\'databaseWindow\'); scene4_dialogue_database()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'database_highlight\')',
      leave: 'hideImage(\'database_highlight\'); stopInactiveTime();',
      coords: [
        0.13229166666666667, 0.46111111111111114, 0.2125, 0.462037037037037, 0.21302083333333333,
        0.3296296296296296, 0.13229166666666667, 0.32685185185185184, 0.13229166666666667, 0.46111111111111114
      ]
    }
    ];
  }
  else if (email >= 1 && database == 0) {
    mapShapes = [{
      //email icon
      id: 'email_highlight2',
      click: 'Dialogue.remove(); hideImage(\'email_highlight2\'); email++; scene4_dialogue_email()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'email_highlight2\')',
      leave: 'hideImage(\'email_highlight2\'); stopInactiveTime();',
      coords: [
        0.14322916666666666, 0.2712962962962963, 0.1953125, 0.2740740740740741, 0.20104166666666667,
        0.20185185185185187, 0.17916666666666667, 0.16944444444444445, 0.14166666666666666,
        0.1712962962962963, 0.14322916666666666, 0.2712962962962963
      ]
    },
    {
      //database icon
      id: 'database_highlight',
      click: 'Dialogue.remove(); hideImage(\'database_highlight\'); scene4_dialogue_database()',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'database_highlight\')',
      leave: 'hideImage(\'database_highlight\'); stopInactiveTime();',
      coords: [
        0.13229166666666667, 0.46111111111111114, 0.2125, 0.462037037037037, 0.21302083333333333,
        0.3296296296296296, 0.13229166666666667, 0.32685185185185184, 0.13229166666666667, 0.46111111111111114
      ]
    },
    {
      //sophia txt data
      click: 'Dialogue.remove(); stopBlinking(); if(s == 2){scene4_dialogue_alreadyDid();} else if(s == 0 && (n == 0 || n == 2) && (c == 0 || c == 2)) {s = 1; followMouse(\'sophia_txt\')}',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.3140625, 0.32592592592592595, 0.2703125, 0.32592592592592595, 0.2703125, 0.23796296296296296,
        0.3145833333333333, 0.2388888888888889, 0.3140625, 0.32592592592592595
      ]
    },
    {
      //nadine txt data
      click: 'Dialogue.remove(); stopBlinking(); if(n == 2){scene4_dialogue_alreadyDid();} else if(n == 0 && (s == 0 || s == 2) && (c == 0 || c == 2)) {followMouse(\'nadine_txt\'); n = 1}',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.32395833333333335, 0.32592592592592595, 0.3692708333333333, 0.325, 0.3692708333333333,
        0.23796296296296296, 0.3229166666666667, 0.23796296296296296, 0.32395833333333335,
        0.32592592592592595
      ]
    },
    {
      //clemens txt data
      click: 'Dialogue.remove(); stopBlinking(); if(c == 2){scene4_dialogue_alreadyDid();} else if(c == 0 && (n == 0 || n == 2) && (s == 0 || s == 2)) {followMouse(\'clemens_txt\'); c = 1}',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.37447916666666664, 0.325, 0.425, 0.32592592592592595, 0.4244791666666667, 0.2361111111111111,
        0.37395833333333334, 0.23703703703703705, 0.37447916666666664, 0.325
      ]
    },
    //hitboxes for the drops
    {
      //sophia txt data drop
      click: 'Dialogue.remove(); stopBlinking(); if(s == 1){s = 2; hideImage(\'sophia_txt\'); followMouse(\'sophia_txt\'); showImage(\'sophia_txt_right\')} else  if (c == 1 || n == 1)scene4_dialogue_wrongDrop();',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.4609375, 0.537962962962963, 0.5291666666666667, 0.537962962962963, 0.5291666666666667,
        0.6509259259259259, 0.4609375, 0.65, 0.4609375, 0.537962962962963
      ]
    },
    {
      //nadine txt data drop
      click: 'Dialogue.remove(); stopBlinking(); if(n == 1){n = 2; hideImage(\'nadine_txt\'); followMouse(\'nadine_txt\'); showImage(\'nadine_txt_right\')} else if (s == 1 || c == 1)scene4_dialogue_wrongDrop();',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.4609375, 0.2814814814814815, 0.5291666666666667, 0.2824074074074074, 0.5291666666666667,
        0.39444444444444443, 0.4609375, 0.39444444444444443, 0.4609375, 0.2814814814814815
      ]
    },
    {
      //clemens txt data drop
      click: 'Dialogue.remove(); stopBlinking(); if(c == 1){c = 2; hideImage(\'clemens_txt\'); followMouse(\'clemens_txt\'); showImage(\'clemens_txt_right\')} else if (s == 1 || n == 1)scene4_dialogue_wrongDrop();',
      hover: 'stopBlinking(); stopInactiveTime();',
      leave: 'stopBlinking(); stopInactiveTime();',
      coords: [
        0.4609375, 0.4111111111111111, 0.5291666666666667, 0.4111111111111111, 0.5291666666666667,
        0.5231481481481481, 0.4609375, 0.5231481481481481, 0.4609375, 0.4111111111111111
      ]
    },
    {
      //"Person anlegen" button
      id: 'addPerson_highlight',
      click: 'Dialogue.remove(); hideImage(\'addPerson_highlight\'); if(s == 2 && n == 2 && c == 2){showImage(\'confirmation\'); drawHitboxesScene4_confirmation()} else{scene4_dialogueTooEarly()}',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'addPerson_highlight\')',
      leave: 'hideImage(\'addPerson_highlight\'); stopInactiveTime();',
      coords: [
        0.7171875, 0.6851851851851852, 0.7171875, 0.7166666666666667, 0.8078125,
        0.7185185185185186, 0.8078125, 0.6861111111111111, 0.7171875, 0.6851851851851852
      ]
    }
    ];
  }
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

// #endregion scene hitboxes

// #region other functions

function followMouse(id) {

  document.addEventListener('mousemove', function handler(e) {
    if (s == 1 || c == 1 || n == 1) {
      showImage(id);
      let mouseImg = document.getElementById(id);
      let left = e.offsetX;
      let top = e.offsetY;
      mouseImg.style.left = left + 'px';
      mouseImg.style.top = top + 'px';
    }
    else if (!(s == 1) && !(c == 1) && !(n == 1)) {
      document.removeEventListener('mousemove', handler);
    }
  });
}

function drawHitboxesScene4_confirmation() {
  mapShapes = [{
    id: 'confirmation_highlight',
    click: 'changeAppsScene4(); removeAllHitboxes(); scene4_dialogue_newEmail()',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'confirmation_highlight\')',
    leave: 'hideImage(\'confirmation_highlight\'); stopInactiveTime();',
    coords: [
      0.4630208333333333, 0.5203703703703704, 0.4630208333333333, 0.5472222222222223,
      0.5338541666666666, 0.5472222222222223, 0.5338541666666666, 0.5203703703703704,
      0.4630208333333333, 0.5203703703703704
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}
function hideImagesScene4() {
  hideImage("message");
  hideImage("email_data");
  hideImage("sophia_txt");
  hideImage("nadine_txt");
  hideImage("clemens_txt");
  hideImage("email");
  hideImage("person_data");
  hideImage("databaseWindow");
  hideImage("nadine_txt_right");
  hideImage("sophia_txt_right");
  hideImage("clemens_txt_right");
  hideImage("confirmation");
  // hideImage("confirmation_highlight");
  hideAppsScene4();
  hideImage("reference_txt");
  hideImage("email_add");
  hideScene4Email();
}

function hideAppsScene4() {
  hideImage("email");
  hideImage("person_data");
  hideImage("databaseWindow");
  hideImage("nadine_txt_right");
  hideImage("sophia_txt_right");
  hideImage("clemens_txt_right");
  hideImage("confirmation");
  hideImage("confirmation_highlight");
}
function changeAppsScene4() {
  hideAppsScene4();
  showImage("email_new");
  showImage("reference_txt");
  showImage("email_add");
  showImage("email_send");
}

function drawHitboxesScene4_reference() {
  mapShapes = [
    //reference
    {
      id: 'reference_highlight',
      click: 'drawHitboxesScene4_text(); hideImage(\'reference_txt\'); showImage(\'reference\'); showImage(\'to\'); showImage(\'cc\'); hideImage(\'reference_highlight\'); hideImage(\'to_highlight\'); hideImage(\'cc_highlight\')',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'reference_highlight\'); showImage(\'to_highlight\'); showImage(\'cc_highlight\')',
      leave: 'hideImage(\'reference_highlight\'); hideImage(\'to_highlight\'); hideImage(\'cc_highlight\'); stopInactiveTime();',
      coords: [
        0.44114583333333335, 0.22870370370370371, 0.44114583333333335, 0.2638888888888889,
        0.6927083333333334, 0.26296296296296295, 0.6927083333333334, 0.22870370370370371,
        0.44114583333333335, 0.22870370370370371
      ]
    }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

function drawHitboxesScene4_text() {
  mapShapes = [
    //mail text
    {
      id: 'text_highlight',
      click: 'drawHitboxesScene4_file(); showImage(\'text\'); hideImage(\'text_highlight\')',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'text_highlight\')',
      leave: 'hideImage(\'text_highlight\'); stopInactiveTime();',
      coords: [
        0.6911458333333333, 0.5472222222222223, 0.6911458333333333, 0.3277777777777778,
        0.4421875, 0.3296296296296296, 0.44166666666666665, 0.5481481481481482,
        0.6911458333333333, 0.5472222222222223
      ]
    }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

function drawHitboxesScene4_file() {
  mapShapes = [
    //file hitbox
    {
      id: 'file_highlight',
      click: 'drawHitboxesScene4_send(); hideImage(\'email_add\'); showImage(\'file\'); hideImage(\'file_highlight\')',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'file_highlight\')',
      leave: 'hideImage(\'file_highlight\'); stopInactiveTime();',
      coords: [
        0.44166666666666665, 0.5990740740740741, 0.5046875, 0.5981481481481481, 0.5046875, 0.6907407407407408,
        0.44166666666666665, 0.6898148148148148, 0.44166666666666665, 0.5990740740740741
      ]
    }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

function sendEmail() {

  Dialogue.remove();
  hideScene4Email();
  removeAllHitboxes();
  fadeToBlack();
  // if (reachedFinalPinboard) { window.setTimeout(initPinboard5, 1000); }
  // else { window.setTimeout(initPinboard4, 1000); }

  if (pinboardProgress < 7) pinboardProgress = 7;

  switch (pinboardProgress) {
    // case 2:
    //   window.setTimeout(initPinboard2, 1000);
    //   window.setTimeout(drawHitboxesPinboard_2, 1000);
    //   break;
    // // After hospital has been played til the end (office pin visible, yet not connected)
    // // Needed for correct display when going back to pinboard, playing hospital again
    // case 3:
    //   window.setTimeout(initPinboard2, 1000);
    //   window.setTimeout(drawHitboxesPinboard_2, 1000);
    //   break;
    // // After office has been visited (office pin connected)
    // case 4:
    //   hideImage("narrator");
    //   hideImage("printer_page");
    //   window.setTimeout(initPinboard_2, 1000);
    //   window.setTimeout(drawHitboxesPinboard_2, 1000);
    //   break;
    // // After office has been played til the end (authority pin visible, yet not connected)
    // case 5:
    //   hideImage("narrator");
    //   hideImage("printer_page");
    //   window.setTimeout(initPinboard_3, 1000);
    //   window.setTimeout(drawHitboxesPinboard_3, 1000);
    //   break;
    // // After authority has been visited (authority pin connected)
    // case 6:
    //   hideImage("narrator");
    //   hideImagesScene4();
    //   window.setTimeout(initPinboard_3, 1000);
    //   window.setTimeout(drawHitboxesPinboard_3, 1000);
    //   break;
    // After authority has been played til the end (Bzfst pin visible, yet not connected)
    case 7:
      window.setTimeout(initPinboard_4, 1000);
      window.setTimeout(drawHitboxesPinboard_4, 1000);
      break;
    // After Bzfst has been clicked (Bzfst pin connected)
    case 8:
      hideImage("narrator");
      if (family == 0) {
        window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
      } else {
        window.setTimeout('showImage(\'pinFamily\')', 1000);
      }
      window.setTimeout('showImage(\'arrow_red\')', 1000);
      window.setTimeout('showImage(\'arrow_grey\')', 1000);
      window.setTimeout(initPinboard_4, 1000);
      window.setTimeout(drawHitboxesPinboard_4_2, 1000);
      break;
    case 9:
      hideImage("narrator");
      if (family == 0) {
        window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
      } else {
        window.setTimeout('showImage(\'pinFamily\')', 1000);
      }
      window.setTimeout('showImage(\'arrow_red\')', 1000);
      window.setTimeout('showImage(\'arrow_grey\')', 1000);
      window.setTimeout(initPinboard_4, 1000);
      window.setTimeout(drawHitboxesPinboard_4_2, 1000);
      break;
    case 10:
      window.setTimeout(initPinboard5, 1000);
      window.setTimeout(drawHitboxesPinboard_5, 1000);
      break;
  }
}

function drawHitboxesScene4_send() {
  mapShapes = [
    //file hitbox
    {
      id: 'send_highlight',
      // click: 'hideScene4Email(); removeAllHitboxes(); fadeToBlack(); window.setTimeout(initPinboard4,1000)',
      click: 'sendEmail();',
      hover: 'stopBlinking(); stopInactiveTime(); showImage(\'send_highlight\')',
      leave: 'hideImage(\'send_highlight\'); stopInactiveTime();',
      coords: [
        0.6166666666666667, 0.7388888888888889, 0.6166666666666667, 0.775,
        0.7067708333333333, 0.7759259259259259, 0.7078125, 0.7407407407407407,
        0.6166666666666667, 0.7388888888888889
      ]
    }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

function hideScene4Email() {
  hideImage("send_highlight");
  hideImage("email_send");
  hideImage("email_new");
  hideImage("reference");
  hideImage("to");
  hideImage("cc");
  hideImage("text");
  hideImage("file");
}

gameSpace.addEventListener("mouseleave", e => { hideTXT(); });
gameSpace.addEventListener("mouseover", e => { showTXT(); });

function hideTXT() {
  if (s == 1) {
    s = 4;
    hideImage("sophia_txt");
    followMouse("sophia_txt");
  }
  else if (c == 1) {
    c = 4;
    hideImage("clemens_txt");
    followMouse("clemens_txt");
  }
  else if (n == 1) {
    n = 4;
    hideImage("nadine_txt");
    followMouse("nadine_txt");
  }
}

function showTXT() {
  if (s == 4) {
    s = 1;
    followMouse("sophia_txt");
  }
  else if (c == 4) {
    c = 1;
    followMouse("clemens_txt");
  }
  else if (n == 4) {
    n = 1;
    followMouse("nadine_txt");
  }
}

//function to draw image maps for scene 5
function drawHitboxesScene5() {
  mapShapes = [{
    id: 'doorHighlight',
    hover: 'stopBlinking(); stopInactiveTime(); showImage(\'doorHighlight\')',
    leave: 'hideImage(\'doorHighlight\');',
    click: 'hideImage(\'doorHighlight\'); removeAllHitboxes(); playDoorOpen(); window.setTimeout(initScene5_2, 200); stopInactiveTime();',
    coords: [
      0.0583, 0.5435, 0.0479, 0.0796, 0.1771, 0.0981, 0.1766, 0.5481
    ]
  }
  ];
  setMapShapes();
  resetInactiveTime();
  startInactiveTime();
}

//function to remove all image maps
function removeAllHitboxes() {

  mapShapes = [{
    coords: []
  },
  ];
  setMapShapes();

}

// #endregion other functions