/* constructor for the dialogue
Author = DigS-Gov Projekt*/

var DIALOG_OFFSET = 250

class Dialogue {
    static currentDialogue
    static init(name, content, click) {
        var messageContainer = document.createElement("div");
        Dialogue.currentDialogue = messageContainer;
        messageContainer.id = "dialogue";
        messageContainer.innerHTML += "<div class = 'charName'>" + name + "</div>";
        messageContainer.innerHTML += content;
        messageContainer.innerHTML += "<div id = 'dots'>...</div>";
        document.getElementById("gameSpace").appendChild(messageContainer);
        messageContainer.style.fontSize = gameSpace.getBoundingClientRect().height / 25 + "px";
        document.getElementById("dots").style.fontSize = gameSpace.getBoundingClientRect().height / 10 + "px";
        window.setTimeout(function() {Dialogue.currentDialogue.onclick = click}, DIALOG_OFFSET);
        Dialogue.currentDialogue.onmouseenter = function (event) {
            hideTXT();
        };
        Dialogue.currentDialogue.onmouseleave = function (event) {
            showTXT();
        };    
    }

    //function to remove dialogue boxes
    static remove() {
        if (Dialogue.currentDialogue) {
            Dialogue.currentDialogue.remove();
            Dialogue.currentDialogue = null;
            stop_running_audio();
        }

    }
}

//tutorial
function tutorialDialogue1() {
    playSound(dialogue_sounds.tutorialPart1_audio);
    Dialogue.init("Tutorial", tutorialPart1, function () {
        //playSound(dialogue_sounds.tutorialPart1,1);
        Dialogue.remove();
        playSound(dialogue_sounds.tutorialPart2_audio);
        Dialogue.init("Tutorial", tutorialPart2, function () {
            Dialogue.remove();
            window.setTimeout(drawHitboxesTutorial, 1000);
            playSound(dialogue_sounds.tutorialPart3_audio);
            Dialogue.init("Tutorial", tutorialPart3, function () {
            });
        });
    });
}
function tutorialDialogue2() {
    playSound(dialogue_sounds.tutorialPart4_audio);
    Dialogue.init("Tutorial", tutorialPart4, function () {
        removeAllHitboxes();
        Dialogue.remove();
        fadeToBlack_slow();
        window.setTimeout(initScene1, 2000);
    });
}

//scene 1
function scene1_Dialogue_1(target) {
    playSound(dialogue_sounds.scene1Part1_audio);
    Dialogue.init("Frau Becker", scene1Part1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.scene1Part2_audio);
        Dialogue.init("Herr Becker", scene1Part2, function () {
            Dialogue.remove();
            window.setTimeout(playDoorBell, 500);
            window.setTimeout(target, 1500);
            window.setTimeout(scene1_Dialogue_2, 1500);
        });
    });
}

function scene1_Dialogue_2() {
    playSound(dialogue_sounds.scene1Part3_audio);
    Dialogue.init("Frau Becker", scene1Part3, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.scene1Part4_audio);
        Dialogue.init("Herr Becker", scene1Part4, function () {
            Dialogue.remove();
        });
    });
}

//scene 1_2
function scene1_2_Dialogue_1() {
    showImage("narrator");
    playSound(dialogue_sounds.scene1_2Part1_audio);
    Dialogue.init("Frau Becker", scene1_2Part1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.scene1_2Part2_audio);
        Dialogue.init("Herr Becker", scene1_2Part2, function () {
            Dialogue.remove();
            hideImage("narrator");
            // stopBirdSound(); 
            window.setTimeout(hideImage.bind(null, "letter"), 1100);
            removeAllHitboxes();
            Dialogue.remove();
            fadeToBlack();
            window.setTimeout(initPinboard, 1000);
        });
    });
}

//scene 2
function scene2_Dialogue_1() {
    drawHitboxesScene2();
    playSound(dialogue_sounds.scene2Part1_audio);
    Dialogue.init("Krankenschwester", scene2Part1, function () {
        Dialogue.remove();
        // window.setTimeout(drawHitboxesScene2, 100);
    });
}

function scene2_Dialogue_2() {
    showImage("narrator");
    playSound(dialogue_sounds.scene2Part2_audio);
    Dialogue.init("Herr Becker", scene2Part2, function () {
        hideImage("narrator");
        Dialogue.remove();
        showImage("nurse");
        playSound(dialogue_sounds.scene2Part3_audio);
        Dialogue.init("Krankenschwester", scene2Part3, function () {
            Dialogue.remove();
            playSound(dialogue_sounds.scene2Part4_audio);
            Dialogue.init("Krankenschwester", scene2Part4, function () {
                Dialogue.remove();
                playSound(dialogue_sounds.scene2Part5_audio);
                Dialogue.init("Krankenschwester", scene2Part5, function () {
                    Dialogue.remove();
                    hideImage("nurse");
                    fadeToBlack();
                    // stopBacksound2();

                    switch (pinboardProgress) {
                        case 2:
                            window.setTimeout(initPinboard2, 1000);
                            window.setTimeout(drawHitboxesPinboard_2, 1000);
                            break;
                        // After hospital has been played til the end (office pin visible, yet not connected)
                        // Needed for correct display when going back to pinboard, playing hospital again
                        case 3:
                            window.setTimeout(initPinboard2, 1000);
                            window.setTimeout(drawHitboxesPinboard_2, 1000);
                            break;
                        // After office has been visited (office pin connected)
                        case 4:
                            hideImage("narrator");
                            hideImage("printer_page");
                            window.setTimeout(initPinboard_2, 1000);
                            window.setTimeout(drawHitboxesPinboard_2, 1000);
                            break;
                        // After office has been played til the end (authority pin visible, yet not connected)
                        case 5:
                            hideImage("narrator");
                            hideImage("printer_page");
                            window.setTimeout(initPinboard_3, 1000);
                            window.setTimeout(drawHitboxesPinboard_3, 1000);
                            break;
                        // After authority has been visited (authority pin connected)
                        case 6:
                            hideImage("narrator");
                            hideImagesScene4();
                            window.setTimeout(initPinboard_3, 1000);
                            window.setTimeout(drawHitboxesPinboard_3, 1000);
                            break;
                        // After authority has been played til the end (Bzfst pin visible, yet not connected)
                        case 7:
                            window.setTimeout(initPinboard_4, 1000);
                            window.setTimeout(drawHitboxesPinboard_4, 1000);
                            break;
                        // After Bzfst has been clicked (Bzfst pin connected)
                        case 8:
                            hideImage("narrator");
                            if (family == 0) {
                                window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
                            } else {
                                window.setTimeout('showImage(\'pinFamily\')', 1000);
                            }
                            window.setTimeout('showImage(\'arrow_red\')', 1000);
                            window.setTimeout('showImage(\'arrow_grey\')', 1000);
                            window.setTimeout(initPinboard_4, 1000);
                            window.setTimeout(drawHitboxesPinboard_4_2, 1000);
                            break;
                        case 9:
                            hideImage("narrator");
                            if (family == 0) {
                                window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
                            } else {
                                window.setTimeout('showImage(\'pinFamily\')', 1000);
                            }
                            window.setTimeout('showImage(\'arrow_red\')', 1000);
                            window.setTimeout('showImage(\'arrow_grey\')', 1000);
                            window.setTimeout(initPinboard_4, 1000);
                            window.setTimeout(drawHitboxesPinboard_4_2, 1000);
                            break;
                        case 10:
                            window.setTimeout(initPinboard5, 1000);
                            window.setTimeout(drawHitboxesPinboard_5, 1000);
                            break;
                    }
                    // if (reachedFinalPinboard) {
                    //     window.setTimeout(initPinboard5, 1000);
                    // } else {
                    //     window.setTimeout(initPinboard2, 1000);
                    // }
                    window.setTimeout(hideImage.bind(null, "paper_text"), 1100);
                });
            });
        });
    });
}

function scene3_Dialogue() {
    drawHitboxesScene3();
    showImage("narrator");
    playSound(dialogue_sounds.scene3Part1_audio);
    Dialogue.init("Herr Becker", scene3Part1, function () {
        hideImage("narrator");
        // window.setTimeout(drawHitboxesScene3, 100);
        Dialogue.remove();
    });
}

function scene3_Dialogue2() {

    drawHitboxesScene3_2();
    playSound(dialogue_sounds.scene3Part2_audio);
    Dialogue.init("Standesbeamter", scene3Part2, function () {
        Dialogue.remove();
        // window.setTimeout(drawHitboxesScene3_2, 100);
        playSound(dialogue_sounds.scene3Part2_1_audio);
        Dialogue.init("Standesbeamter", scene3Part2_1, function () {
            Dialogue.remove();
        })
    });

}

function scene3_Dialogue3() {
    drawHitboxesScene3_2();
    playSound(dialogue_sounds.scene3Part3_audio);
    Dialogue.init("Standesbeamter", scene3Part3, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.scene3Part4_audio);
        Dialogue.init("Standesbeamter", scene3Part4, function () {
            Dialogue.remove();
            // window.setTimeout(drawHitboxesScene3_2, 100);
        })
    });
}


var HANDY_DIALOG_OFFSET = 3000;
function dialogue_handy() {
    //handy got clicked in printer scene
        window.setTimeout(function () { playSound(dialogue_sounds.handyPart2_audio)
            Dialogue.init("Standesbeamter", handyPart2, function () {
                Dialogue.remove();
                window.setTimeout(function () {
                    playSound(dialogue_sounds.handyPart4_audio);
                    Dialogue.init("Standesbeamter", handyPart4, function () {
                    Dialogue.remove();
                    window.setTimeout(function () {
                        playSound(dialogue_sounds.handyPart6_audio);
                        Dialogue.init("Standesbeamter", handyPart6, function () {
                        Dialogue.remove();
                        window.setTimeout(function () {
                            playSound(dialogue_sounds.handyPart8_audio);
                            Dialogue.init("Standesbeamter", handyPart8, function () {
                            Dialogue.remove();
                            window.setTimeout(drawHitboxesScene3_printer, 100);
                            window.setTimeout(hideImage.bind(null, "handy_face"), 100);
                            call = 1;
                            })}, HANDY_DIALOG_OFFSET / 2) 
                        })
                    }, HANDY_DIALOG_OFFSET / 2)})
                }, HANDY_DIALOG_OFFSET / 2)
            })}, HANDY_DIALOG_OFFSET);
    };



function scene3_Dialogue4() {
    drawHitboxesScene3_5();
    //playSound(dialogue_sounds.scene3Part5_audio);
    playSound(dialogue_sounds.scene3_Opt6_1_audio)
    Dialogue.init("Standesbeamter", scene3_Opt6_1, function () {
        // window.setTimeout(drawHitboxesScene3_5,150);
        Dialogue.remove();
        playSound(dialogue_sounds.scene3_Opt6_2_audio)
        Dialogue.init("Standesbeamter", scene3_Opt6_2, function() {
            Dialogue.remove();
        })
    });
};


function scene3_Dialogue_last() {
    showImage("narrator");
    playSound(dialogue_sounds.scene3Part_last_audio);
    Dialogue.init("Frau Becker", scene3Part_last, function () {
        Dialogue.remove();
        hideImage("narrator");
        removeAllHitboxes();
        fadeToBlack();
        // stopBacksound3();

        if (pinboardProgress<5) pinboardProgress=5;

        switch (pinboardProgress) {
            // case 2:
            //     window.setTimeout(initPinboard2, 1000);
            //     window.setTimeout(drawHitboxesPinboard_2, 1000);
            //     break;
            // // After hospital has been played til the end (office pin visible, yet not connected)
            // // Needed for correct display when going back to pinboard, playing hospital again
            // case 3:
            //     window.setTimeout(initPinboard2, 1000);
            //     window.setTimeout(drawHitboxesPinboard_2, 1000);
            //     break;
            // After office has been visited (office pin connected)
            case 4:
                hideImage("narrator");
                hideImage("printer_page");
                window.setTimeout(initPinboard_2, 1000);
                window.setTimeout(drawHitboxesPinboard_2, 1000);
                break;
            // After office has been played til the end (authority pin visible, yet not connected)
            case 5:
                hideImage("narrator");
                hideImage("printer_page");
                window.setTimeout(initPinboard_3, 1000);
                window.setTimeout(drawHitboxesPinboard_3, 1000);
                break;
            // After authority has been visited (authority pin connected)
            case 6:
                hideImage("narrator");
                hideImagesScene4();
                window.setTimeout(initPinboard_3, 1000);
                window.setTimeout(drawHitboxesPinboard_3, 1000);
                break;
            // After authority has been played til the end (Bzfst pin visible, yet not connected)
            case 7:
                window.setTimeout(initPinboard_4, 1000);
                window.setTimeout(drawHitboxesPinboard_4, 1000);
                break;
            // After Bzfst has been clicked (Bzfst pin connected)
            case 8:
                hideImage("narrator");
                if (family == 0) {
                    window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
                } else {
                    window.setTimeout('showImage(\'pinFamily\')', 1000);
                }
                window.setTimeout('showImage(\'arrow_red\')', 1000);
                window.setTimeout('showImage(\'arrow_grey\')', 1000);
                window.setTimeout(initPinboard_4, 1000);
                window.setTimeout(drawHitboxesPinboard_4_2, 1000);
                break;
            case 9:
                hideImage("narrator");
                if (family == 0) {
                    window.setTimeout('showImage(\'pinFamily_grey\')', 1000);
                } else {
                    window.setTimeout('showImage(\'pinFamily\')', 1000);
                }
                window.setTimeout('showImage(\'arrow_red\')', 1000);
                window.setTimeout('showImage(\'arrow_grey\')', 1000);
                window.setTimeout(initPinboard_4, 1000);
                window.setTimeout(drawHitboxesPinboard_4_2, 1000);
                break;
            case 10:
                window.setTimeout(initPinboard5, 1000);
                window.setTimeout(drawHitboxesPinboard_5, 1000);
                break;
            }
        // if (reachedFinalPinboard) {
        //     window.setTimeout(initPinboard5, 1000);
        // } else {
        //     window.setTimeout(initPinboard3, 1000);
        // }
    });
}

//function for dialogue when clicking printer at incorrect time
function scene3_Dialogue_opt(origin) {
    // removeAllHitboxes();
    if (printer == 0) {
        playSound(dialogue_sounds.scene3_Opt1_1_audio);
        Dialogue.init("Standesbeamter", scene3_Opt1_1, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (printer == 1) {
        playSound(dialogue_sounds.scene3_Opt1_2_audio);
        Dialogue.init("Standesbeamter", scene3_Opt1_2, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (printer == 2) {
        playSound(dialogue_sounds.scene3_Opt1_3_audio);
        Dialogue.init("Standesbeamter", scene3_Opt1_3, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (printer == 3) {
        playSound(dialogue_sounds.scene3_Opt1_4_audio);
        Dialogue.init("Standesbeamter", scene3_Opt1_4, function () {
            Dialogue.remove();
            printer = 0;
            drawHitboxesScene3_2();
        })
    }
}

//function for dialogue when clicking computer at incorrect time
function scene3_Dialogue_opt2() {
    // removeAllHitboxes();
    if (computer == 0) {
        playSound(dialogue_sounds.scene3_Opt2_1_audio);
        Dialogue.init("Standesbeamter", scene3_Opt2_1, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (computer == 1) {
        playSound(dialogue_sounds.scene3_Opt2_2_audio);
        Dialogue.init("Standesbeamter", scene3_Opt2_2, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (computer == 2) {
        playSound(dialogue_sounds.scene3_Opt2_3_audio);
        Dialogue.init("Standesbeamter", scene3_Opt2_3, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (computer == 3) {
        playSound(dialogue_sounds.scene3_Opt2_4_audio);
        Dialogue.init("Standesbeamter", scene3_Opt2_4, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
            computer = 0;
        })
    }
}

//function for dialogue when clicking computer at incorrect time after use
function scene3_Dialogue_opt3() {
    // removeAllHitboxes();
    if (computer == 0) {
        playSound(dialogue_sounds.scene3_Opt3_1_audio);
        Dialogue.init("Standesbeamter", scene3_Opt3_1, function () {
            Dialogue.remove();
            drawHitboxesScene3_printer();
        })
    }
    else {
        playSound(dialogue_sounds.scene3_Opt3_2_audio);
        Dialogue.init("Standesbeamter", scene3_Opt3_2, function () {
            Dialogue.remove();
            drawHitboxesScene3_printer();
            computer = 0;
        })
    }
}

//function for dialogue when clicking computer at incorrect time
function scene3_Dialogue_opt4() {
    // removeAllHitboxes();
    if (letter == 1) {
        playSound(dialogue_sounds.scene3_Opt4_1_audio);
        Dialogue.init("Standesbeamter", scene3_Opt4_1, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
        })
    }
    else if (letter == 2) {
        playSound(dialogue_sounds.scene3_Opt4_2_audio);
        Dialogue.init("Standesbeamter", scene3_Opt4_2, function () {
            Dialogue.remove();
            drawHitboxesScene3_2();
            letter = 1;
        })
    }
    else if (letter == 3) {
        playSound(dialogue_sounds.scene3_Opt4_3_audio);
        Dialogue.init("Standesbeamter", scene3_Opt4_3, function () {
            Dialogue.remove();
            drawHitboxesScene3_printer();
            letter++;
        })
    }
    else if (letter >= 4) {
        playSound(dialogue_sounds.scene3_Opt4_4_audio);
        Dialogue.init("Standesbeamter", scene3_Opt4_4, function () {
            Dialogue.remove();
            drawHitboxesScene3_printer();
            letter = 3;
        })
    }
    letter++;
}

//function for dialogue when clicking mobile at incorrect time
function scene3_Dialogue_opt5() {
    playSound(dialogue_sounds.scene3_Opt5_1_audio);
    // removeAllHitboxes();
    Dialogue.init("Standesbeamter", scene3_Opt5_1, function () {
        Dialogue.remove();
        certificate == 0 ? drawHitboxesScene3_2() : drawHitboxesScene3_printer();
    });
}

//function for dialogue when clicking postit
function scene3_Dialogue_postit() {
    // removeAllHitboxes();
    if (clickedPostit == 0 && call == 0 && certificate == 0) {
        clickedPostit = 1;
        playSound(dialogue_sounds.scene3_postit1_audio);
        Dialogue.init("Standesbeamter", scene3_postit1, function () {
            Dialogue.remove();
            playSound(dialogue_sounds.scene3_postit1_1_audio);
            Dialogue.init("Standesbeamter", scene3_postit1_1, function () {
                Dialogue.remove();
                drawHitboxesScene3_2();
            });
        });
    }
    else if (clickedPostit == 0 && call == 0 && certificate == 1) {
        playSound(dialogue_sounds.scene3_postit1_audio);
        Dialogue.init("Standesbeamter", scene3_postit1, function () {
            clickedPostit = 1;
            Dialogue.remove();
            playSound(dialogue_sounds.scene3_postit1_2_audio);
            Dialogue.init("Standesbeamter", scene3_postit1_2, function () {
                Dialogue.remove();
                drawHitboxesScene3_printer();
            });
        });
    }
    else if (clickedPostit == 1) {
        playSound(dialogue_sounds.scene3_postit3_audio);
        Dialogue.init("Standesbeamter", scene3_postit3, function () {
            Dialogue.remove();
            certificate == 1 ? drawHitboxesScene3_printer() : drawHitboxesScene3_2();
        });
    }
}

//scene4 beginning
function scene4_dialogue() {
    drawHitboxesScene4();
    showImage("narrator");
    playSound(dialogue_sounds.scene4Part1_audio);
    Dialogue.init("Herr Becker", scene4Part1, function () {
        hideImage("narrator");
        // window.setTimeout(drawHitboxesScene4, 100);
        Dialogue.remove();
    });
}

//scene4 start to work
function scene4_dialogue1() {
    drawHitboxesScene4_1();
    playSound(dialogue_sounds.scene4Part2_audio);
    Dialogue.init("Meldebeamtin", scene4Part2, function () {
        // window.setTimeout(drawHitboxesScene4_1, 100);
        Dialogue.remove();
    });
}

//scene4 start to work
function scene4_dialogue2() {
    drawHitboxesScene4_apps();
    //playSound(dialogue_sounds.scene4Part3);
    Dialogue.init("Meldebeamtin", scene4Part3, function () {
        // window.setTimeout(drawHitboxesScene4_apps, 100);
        Dialogue.remove();
    });
}

//scene4 filler dialogue for the emails
function scene4_dialogue_email() {
    Dialogue.remove();
    drawHitboxesScene4_apps();
    // removeAllHitboxes();
    //succeed
    if (email == 1) {
        playSound(dialogue_sounds.scene4_email_success_audio);
        Dialogue.init("Meldebeamtin", scene4_email_success, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (email == 2) {
        playSound(dialogue_sounds.scene4_email_fail2_audio);
        Dialogue.init("Meldebeamtin", scene4_email_fail2, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (email == 3) {
        playSound(dialogue_sounds.scene4_email_fail3_audio);
        Dialogue.init("Meldebeamtin", scene4_email_fail3, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (email >= 4) {
        playSound(dialogue_sounds.scene4_email_fail4_audio);
        Dialogue.init("Meldebeamtin", scene4_email_fail4, function () {
            showTXT();
            Dialogue.remove();
            email = 1;
            // drawHitboxesScene4_apps();
        })
    }
}

function scene4_dialogue_personData() {
    // removeAllHitboxes();
    drawHitboxesScene4_apps();
    playSound(dialogue_sounds.scene4_openedData_audio);
    Dialogue.init("Meldebeamtin", scene4_openedData, function () {
        Dialogue.remove();
        // drawHitboxesScene4_apps();
    })
}

//scene4 filler dialogue for the database
function scene4_dialogue_database() {
    Dialogue.remove();
    drawHitboxesScene4_apps();
    // removeAllHitboxes();
    //succeed
    if (database == 0) {
        playSound(dialogue_sounds.scene4_database_success_audio);
        Dialogue.init("Meldebeamtin", scene4_database_success, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (database == 1) {
        playSound(dialogue_sounds.scene4_database_fail2_audio);
        Dialogue.init("Meldebeamtin", scene4_database_fail2, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (database == 2) {
        playSound(dialogue_sounds.scene4_database_fail3_audio);
        Dialogue.init("Meldebeamtin", scene4_database_fail3, function () {
            showTXT();
            Dialogue.remove();
            // drawHitboxesScene4_apps();
        })
    }
    else if (database >= 3) {
        playSound(dialogue_sounds.scene4_database_fail4_audio);
        Dialogue.init("Meldebeamtin", scene4_database_fail4, function () {
            showTXT();
            Dialogue.remove();
            database = 0;
            // drawHitboxesScene4_apps();
        })
    }
}

function scene4_dialogue_wrongDrop() {
    Dialogue.remove();
    drawHitboxesScene4_apps();
    playSound(dialogue_sounds.thatwasWrong_audio);
    Dialogue.init("Meldebeamtin", thatwasWrong, function () {
        showTXT();
        Dialogue.remove();
        // drawHitboxesScene4_apps();
    });
}

function scene4_dialogue_alreadyDid() {
    Dialogue.remove();
    drawHitboxesScene4_apps();
    playSound(dialogue_sounds.alreadyDone_audio);
    Dialogue.init("Meldebeamtin", alreadyDone, function () {
        showTXT();
        Dialogue.remove();
        // drawHitboxesScene4_apps();
    });
}

function scene4_dialogueTooEarly() {
    // removeAllHitboxes();
    Dialogue.remove();
    drawHitboxesScene4_apps();
    playSound(dialogue_sounds.thatwasWrong2_audio);
    Dialogue.init("Meldebeamtin", thatwasWrong2, function () {
        showTXT();
        Dialogue.remove();
        // drawHitboxesScene4_apps();
    });
}

function scene4_dialogue_newEmail() {
    Dialogue.remove();
    drawHitboxesScene4_reference();
    playSound(dialogue_sounds.scene4_newMail_audio);
    Dialogue.init("Meldebeamtin", scene4_newMail, function () {
        Dialogue.remove();
        // drawHitboxesScene4_reference();
    });
}

//pinboard dialogue
function pinboard1_Dialogue1() {
    drawHitboxesPinboard_1();
    playSound(dialogue_sounds.pinboard1_Part1_audio);
    Dialogue.init("Tutorial", pinboard1_Part1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.pinboard1_Part2_audio);
        Dialogue.init("Tutorial", pinboard1_Part2, function () {
            Dialogue.remove();
            playSound(dialogue_sounds.pinboard1_Part3_audio);
            Dialogue.init("Tutorial", pinboard1_Part3, function () {
                Dialogue.remove();
                playSound(dialogue_sounds.pinboard1_Part4_audio);
                Dialogue.init("Tutorial", pinboard1_Part4, function () {
                    Dialogue.remove();
                    playSound(dialogue_sounds.pinboard1_Part5_audio);
                    Dialogue.init("Tutorial", pinboard1_Part5, function () {
                        Dialogue.remove();
                    // drawHitboxesPinboard_1();
                    });
                });
            });
        });
    });
}

//function to create dialogue in one section
function createOneDialogue(name, content, target, audio_ref) {
    // removeAllHitboxes();
    Dialogue.remove();
    playSound(dialogue_sounds[audio_ref + '_audio']);
    Dialogue.init(name, content, function () {
        Dialogue.remove();
        window.setTimeout(target, 0);
    });
}

/*function find_var_string(checker_string, first_var_string = ''){
    if(first_var_string !== ''){
        console.log(checker_string, marker_sub_string);
        marker_sub_string = first_var_string;
        var index_start = checker_string.indexOf(marker_sub_string);
        var substring_after_start_index = checker_string.substring(index_start + marker_sub_string.length + 1);
        var index_end = substring_after_start_index.indexOf(',');
        return checker_string.substring(marker_sub_string.length + index_start + 1, index_start + marker_sub_string.length + index_end + 1).trim();
    }
    var marker_sub_string = 'create';
    console.log(checker_string, marker_sub_string);
    var index = checker_string.indexOf(marker_sub_string);
    //console.log('index: ' ,index);
    if(index == -1){
        console.log('Substring nicht gefunden');
        return undefined
    }
    var substring_after_index = checker_string.substring(index + marker_sub_string.length);
    //console.log('after first cut: ', substring_after_index);
    var index_start = substring_after_index.indexOf(',');
    //console.log('index start: ', index_start);
    var substring_after_start_index = substring_after_index.substring(index_start + 1);
    //console.log('after second cut: ', substring_after_start_index);
    var index_end = substring_after_start_index.indexOf(',');
    //console.log('index_end: ', index_end);
    return checker_string.substring(index + marker_sub_string.length + index_start +1, index + marker_sub_string.length + index_start + index_end + 1).trim();
}*/

//function to create dialogue in two sections
function createTwoDialogues(name, content1, content2, target, audio_ref1, audio_ref2) {
    // removeAllHitboxes();
    console.log(mapShapes[0].click);
    Dialogue.remove();
    playSound(dialogue_sounds[audio_ref1 + '_audio']);
    Dialogue.init(name, content1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds[audio_ref2 + '_audio']);
        Dialogue.init(name, content2, function () {
            Dialogue.remove();
            window.setTimeout(target, 0);
        });
    });
}

function createFourDialogues(name, content1, content2, content3, content4, target, audio_ref1, audio_ref2, audio_ref3, audio_ref4) {
    // removeAllHitboxes();
    console.log(mapShapes[0].click);
    Dialogue.remove();
    playSound(dialogue_sounds[audio_ref1 + '_audio']);
    Dialogue.init(name, content1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds[audio_ref2 + '_audio']);
        Dialogue.init(name, content2, function () {
            Dialogue.remove();
            playSound(dialogue_sounds[audio_ref3 + '_audio']);
            Dialogue.init(name, content3, function () {
                Dialogue.remove();
                playSound(dialogue_sounds[audio_ref4 + '_audio']);
                Dialogue.init(name, content4, function () {
                    Dialogue.remove();
                    window.setTimeout(target, 0);
            });
        });
    });
});
}

function get_audio_var(){

}
//function to create dialogue for scene 5
function scene5_Dialogue() {
    playSound(dialogue_sounds.scene5Part1_audio);
    Dialogue.init("Herr Becker", scene5Part1, function () {
        Dialogue.remove();
        playSound(dialogue_sounds.scene5Part2_audio);
        Dialogue.init("Frau Becker", scene5Part2, function () {
            Dialogue.remove();
            fadeToWhite();
            // stopBirdSound(); 
            window.setTimeout(hideImage.bind(null, "letter"), 1100);
            window.setTimeout(initPinboard5, 1000);
        });
    });
}