# DigS-Gov Geburt
Das Forschungsprojektes DigS-Gov (Digitale Souveränität durch E-Government) zielt auf die Förderung und Erhöhung der Digitalen Souveränität in allen Bevölkerungsgruppen ab. Ausgangspunkt sind kommunale Bürgerdienste im Rahmen von Bürgerservice-Websites und -Apps. In verschiedenen Lebenslagen ist ein Kontakt zur Verwaltung notwendig, bei dem Daten erhoben werden. Da Prozesse oft verwaltungsübergreifend ablaufen ist ein intensiver Datenaustausch erforderlich. Die föderale Struktur erhöht somit die Anzahl der möglichen Empfänger bürgerbezogener Daten und damit auch die Intransparenz mit Bezug auf die Datenweitergabe. 
Diese entwickelte Webanwendung bietet eine nutzerfreundliche Interaktionsformen zum selbstbestimmten und reflektierten Umgang mit Daten und digitalen Technologien. 

Dies ist ein Point&Click-Spiel, das Bürgerinnen und Bürger in der Lebenslage Geburt unterstützt.

## Oberfläche
| ![Start](readme_res/Tutorial.png) | ![Quiz](readme_res/Start.png) |
|---|---|
| *Tutorial* | *Der Beginn des Spiels* |
| ![Auswahl](readme_res/SteuerID.png) | ![Legende](readme_res/Krankenhaus.png) |
| *Die Empfangende Steuer-ID* | *Die Dateneingabe im Krankenhaus* |
| ![Lösung](readme_res/Geburtsurkunde.png) | ![Muster](readme_res/Meldeamt.png) |
| *Die Geburtsurkunde vom Standesamt* | *Die Datenweitergabe an das Meldeamt* |
| ![Info](readme_res/Pinwand.png) | ![Info2](readme_res/Ende.png) |
| *Die Übersicht auf der Pinnwand* | *Der Empfang der Steuer-ID* |


## Technik
- **Lizenz:**  [OpenSource](https://creativecommons.org/licenses/by/4.0/) 
    - **Projektbeteiligte**
        - DigS-Gov: Universität zu Lübeck: Institut für Multimediale und Interaktive Systeme, Ethical Innovation Hub
        - Mach AG
        - Hansestadt Lübeck
        - Gefördert durch das Bundesministerium für Bildung und Forschung

- **Software (Versionsnummer)** 
    - JavaScript (1.5)
    - Browser (mindestens)
        - Edge 88
        - Firefox 89
        - Safari 15
        - Chrome 88
        - Opera 74

- **Einrichten**
    - Download und Installation von [Visual Studio Code](https://code.visualstudio.com/download)
    - In VS Code die Extension *Live Server* installieren
    - Dieses Projekt in VS Code öffnen und unten in der blauen Leiste auf *Go Live* klicken.
    - Anwendung läuft auf Localhost im Browser
  
    
## Wissenschaftliche Erkenntnisse [JIL](https://jil.sh/portfolio/projekte/digs-gov/)
Das Joint Innovation Lab forscht, entwickelt und berät zur Digitalen Transformation im öffentlichen Sektor. Die wissenschaftlichen Erkenntnisse finden Sie auf der [DigS-Gov Projektwebsite](https://jil.sh/portfolio/projekte/digs-gov/).

## Kontakt
 - Universität zu Lübeck, Institut für Multimediale und Interaktive Systeme (IMIS),Ratzeburger Allee 160, 23562 Lübeck, Deutschland,
 - Tel.: +49 451 3101 5101

### Ansprechpartner
-  Karlson Hanke, karlson.hanke@uni-luebeck.de


#### Letzte Änderung 
- 18.02.2024