/*--------------------------------------------------------
 * Router der Seiten
 * @author DigS-Gov Projekt
 * ------------------------------------------------------
*/

import { createRouter, createWebHistory } from 'vue-router'
import Startseite from '../views/Startseite.vue'



const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/',
      component: Startseite
    },
    {
      path: '/normal',
      name: 'normal',
      component: () => import('@/views/Normal.vue')
    },
    {
      path: '/kinder',
      name: 'kinder',
      component: () => import('@/views/Kinder.vue')
    },
    {
      path: '/impressum',
      name: 'impressum',
      component: () => import('@/views/Impressum.vue')
    },
    {
      path: '/digsgov',
      component: Startseite,
      beforeEnter: (to, from, next) => {
        window.location.href = 'https://www.interaktive-technologien.de/projekte/digs-gov'
      }
    }
  ]
})

export default router
