# DigS-Gov Babybuch
Das Forschungsprojektes DigS-Gov (Digitale Souveränität durch E-Government) zielt auf die Förderung und Erhöhung der Digitalen Souveränität in allen Bevölkerungsgruppen ab. Ausgangspunkt sind kommunale Bürgerdienste im Rahmen von Bürgerservice-Websites und -Apps. In verschiedenen Lebenslagen ist ein Kontakt zur Verwaltung notwendig, bei dem Daten erhoben werden. Da Prozesse oft verwaltungsübergreifend ablaufen ist ein intensiver Datenaustausch erforderlich. Die föderale Struktur erhöht somit die Anzahl der möglichen Empfänger bürgerbezogener Daten und damit auch die Intransparenz mit Bezug auf die Datenweitergabe. 
Diese entwickelte Webanwendung bietet eine nutzerfreundliche Interaktionsformen zum selbstbestimmten und reflektierten Umgang mit Daten und digitalen Technologien. 

Dies ist ein interaktives Babybuch, das Bürgerinnen und Bürger in der Lebenslage Geburt unterstützt.
## Oberfläche
| ![Start](./readme_res/Startseite.png) | ![Quiz](./readme_res/Buchstart.png) |
|---|---|
| *Die Startseite mit beiden Buchvarianten.* | *Die erste Seite der beiden Bücher. Zusätzlich kann die rechte Seite (Kinderbuch) vorgelesen werden.* |
| ![Auswahl](./readme_res/Buch1.png) | ![Legende](./readme_res/Buch2.png) |
| *Das Buch mit weiteren Informationen.* | *Das Bilderbuch für Kinder.* |


## Technik
- **Lizenz:**  [OpenSource](https://creativecommons.org/licenses/by/4.0/) 
    - **Projektbeteiligte**
        - DigS-Gov: Universität zu Lübeck: Institut für Multimediale und Interaktive Systeme, Ethical Innovation Hub
        - Mach AG
        - Hansestadt Lübeck
        - Gefördert durch das Bundesministerium für Bildung und Forschung


- **Software (Versionsnummer)** 
    - Node.js (v16.14.0.)
    - npm (8.3.1)
    - Vite (v4.5.2)
    - Vue.js (3.4.15)
    - VSCode + Volar (ohne Vetur) 
    - TypeScript 

- **Befehle**
    - Projekt Setup
        - npm install
    - Kompilieren
        - npm run dev
    - Projekt bauen
        - npm run build
    - Testen
        - npm run test:unit
    - ESLint
        - npm run lint

## Vite Konfiguration
[Vite Configuration Reference](https://vitejs.dev/config/).
## Wissenschaftliche Erkenntnisse [JIL](https://jil.sh/portfolio/projekte/digs-gov/)
Das Joint Innovation Lab forscht, entwickelt und berät zur Digitalen Transformation im öffentlichen Sektor. Die wissenschaftlichen Erkenntnisse finden Sie auf der [DigS-Gov Projektwebsite](https://jil.sh/portfolio/projekte/digs-gov/)

## Kontakt
 - Universität zu Lübeck, Institut für Multimediale und Interaktive Systeme (IMIS),Ratzeburger Allee 160, 23562 Lübeck, Deutschland,
 - Tel.: +49 451 3101 5101

### Ansprechpartner
-  Karlson Hanke, karlson.hanke@uni-luebeck.de

#### Letzte Änderung 
- 18.02.2024